c
c
      subroutine setsiz
c
c	PROGRAM NAME:			SETSIZ.rat
c
c	DATE OF  FIRST  VERSION:	28-Feb-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLT routine to establish line weights and
c			various sizes for plotting, based on the
c			average axis length and the value of the
c			parameter SIZFAC:
c
c			  If SIZFAC is negative, use the values
c			    for the previous frame.
c			  If SIZFAC is zero, then compute the default
c			    weights and sizes.
c			  If SIZFAC is positive, then use its value
c			    as an average axis length on which to
c			    base the weights and sizes.
c			
c
c	USAGE:		call SETSIZ
c
c	PROGRAMMER:	Eric Javel / Matt Prucka
c
c****************************************************************
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
c
c----------------------------------------------------------------
c
c See if new weights are desired or is previous weights are to be used
      if(.not.(sizfac .lt. 0.))goto 23000
c If previous to be used
         return
c     else
23000    continue
         if(.not.(sizfac .eq. 0.))goto 23002
c If no factor provided
            avgaxl=(xlen+ylen)/2.
            goto 23003
c        else
23002       continue
c If factor provided
            avgaxl = sizfac
23003    continue
23001 continue
c Tick length
c If tick is outward
      tiklen = avgaxl / 40.
      if(.not.(ticmrk .ne. 0.))goto 23004
c If tick is inward
         tiklen = tiklen * 1.25
c Annotation height
23004 continue
      if(.not.(sizann .lt. 0.))goto 23006
         hitann = -sizann
         goto 23007
c     else
23006    continue
         hitann = sizann * tiklen
23007 continue
c Axis label height
      if(.not.(sizlab .lt. 0.))goto 23008
         hitlab = -sizlab
         goto 23009
c     else
23008    continue
         hitlab = sizlab * avgaxl / 30.
23009 continue
c Data symbol height
      if(.not.(sizsym .lt. 0.))goto 23010
         hitsym = -sizsym
         goto 23011
c     else
23010    continue
         hitsym = sizsym * avgaxl / 48.
23011 continue
c Message height
      if(.not.(sizmsg .lt. 0.))goto 23012
         hitmsg = -sizmsg
         goto 23013
c     else
23012    continue
         hitmsg = sizmsg * avgaxl / 40.
23013 continue
c Axis line weight
      if(.not.(wtlnax .lt. 0.))goto 23014
         iaxlnw = -wtlnax
         goto 23015
c     else
23014    continue
         iaxlnw = avgaxl * wtlnax
23015 continue
c Grid line weight
      if(.not.(grid .lt. 0.))goto 23016
         igrlnw = -grid
         goto 23017
c     else
23016    continue
         if(.not.(grid .eq. 0.))goto 23018
            igrlnw = 0.
            goto 23019
c        else
23018       continue
            igrlnw = avgaxl/8. + 1.
23019    continue
23017 continue
c Annotation line weight
      if(.not.(wtlnan .lt. 0.))goto 23020
         ianlnw = -wtlnan
         goto 23021
c     else
23020    continue
         ianlnw = wtlnan * hitann * 20.
23021 continue
c Label line weight
      if(.not.(wtlnlb .lt. 0.))goto 23022
         ilblnw = -wtlnlb
         goto 23023
c     else
23022    continue
         ilblnw = wtlnlb * hitlab * 20.
23023 continue
c Message line weight
      if(.not.(wtlnms .lt. 0.))goto 23024
         imslnw = -wtlnms
         goto 23025
c     else
23024    continue
         imslnw = wtlnms * hitmsg * 20.
23025 continue
c Data line weight
      if(.not.(pltlin .lt. 0.))goto 23026
         ipllnw = -pltlin
         goto 23027
c     else
23026    continue
         ipllnw = pltlin * avgaxl / 1.5
23027 continue
      return
      end
                                                                                                                                                                                                                                                                             