c
c
      subroutine imag (amin,amax,alen,allc,bmin,bmax,blen,bllc,percnt)
c
c
c	PROG NAME:			IMAG.rat
c
c	DATE OF FIRST VERSION:		 3-Jan-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL routine to determine imaginary axis
c			parameters if log axis is used.  The imaginary
c			axis is used internally for plotting data and
c			is based on full cycles, given the axis parameters
c			specified in the plot.
c
c	USAGE:		call IMAG (AMIN,AMAX,ALEN,ALLC,BMIN,BMAX,BLEN,BLLC,
c				   PERCNT)
c
c			where  AMIN = Actual minimum axis annotation value
c			       AMAX = Actual maximum axis annotation value
c			       ALEN = Actual axis length in inches
c			       ALLC = Actual lower left-hand corner of axis
c			       BMIN = Imaginary minimum axis annotation value
c			       BMAX = Imaginary maximum axis annotation value
c			       BLEN = Imaginary axis length in inches
c			       BLLC = Imaginary lower left-hand corner of axis
c			     PERCNT = Percentage of axis length to use
c
c	PROGRAMMER:	Eric Javel
c
c*********************************************************************
c
c Determine imaginary minimum
      n = alog10(amin)
      if(.not.(n .lt. 0))goto 23000
         n = n - 1
23000 continue
      bmin = 10.**float(n)
c Determine imaginary maximum
      a = alog10(amax)
      n = a
      if(.not.(a .ne. aint(a)))goto 23002
         n = n + 1
23002 continue
      bmax = 10.**float(n)
c Determine imaginary length and lower left-hand corner
c length of a full cycle
      a = alen * percnt/100. / alog10(amax/amin)
      blen = alog10(bmax/bmin) * a
      bllc = allc + (100.-percnt)/200.*alen - (alog10(amin/bmin) * a)
      return
      end
                                                                                                                                                                                                                                                                                                                                         