	SUBROUTINE MPOPEN( rdunit, munit, mfil )
C
C	open 1 map file at a time
C
C	rdunit = unit number used for RDM File
C	munit = unit number to associate mfil (map file) in open.
C	mfil = map file name( 14 characters).
C
C	Walt Shpuntoff		Institute for Resource Management
C				P.O. Box 869, Arnold, MD 21012 
C				(301) 757- 6503
c
c	RDM is a copyright of Interactive Technology, Inc
C
C
	IMPLICIT INTEGER (A-Z)
	INCLUDE 'RDMCOM'
	CHARACTER mfil*14
C
C	Map file definitions
C
	INTEGER*2 mprcsb,		!2 map file record size
C					! RDM v4=4 for INTEGER*4(21 mil. recs)
	1	  mRnum1,mRnum2		!40 number records(elements) in map
	CHARACTER mpfil*36		!4 file name that map is for.
C
	EQUIVALENCE( mblock(3),  mprcsb )
	EQUIVALENCE( mblock(5),  mpfil )
	EQUIVALENCE( mblock(41), mRnum1 )
	EQUIVALENCE( mblock(43), mRnum2 )
C
c.. variables for reversing words on "Longs"
c
	Integer*4 Long
	Integer*2 Short(2)
	Equivalence (Long,Short)
C
C.. Set Current file (if necessary)
C
	If (Rdunit.Ne.Units(Curfil)) Then
C
C.. search the table for the right file index (curfil)
C
	   Do 20 I = 1, Nfiles
	     Curfil = I
	     If (Units(I).Eq.funit) Goto 30
20	   Continue
C
C.. not in table
C
	   Stats = 4
	   Return
C
C.. Got it
C
30	   Continue
	   Ich = Ichan(Curfil)
	   oldblk = -1
	Endif
C
C.. update number of maps & check against maximum
C
	Nmaps = Nmaps + 1
	If (Nmaps.Gt.Maxmap) Stop 'Maximum number of map files exceeded'
	Curmap = Nmaps
	Mapunit(1,Curmap) = munit
	Mapunit(2,Curmap) = rdunit
C
C.. Open the file & read the first block
C
	OPEN(UNIT=munit,FILE=mfil,FORM='UNFORMATTED',RECL=128,
	1 ACCESS='DIRECT',STATUS='OLD',READONLY)
	oldmbk = 1		!for RDGET
	READ(munit'oldmbk) mblock
C
C.. check mpfil against RDM file name (ignores device)
C
	IF (mpfil(5:10).NE.RDMnam(Curfil)(5:10)) THEN
	   TYPE *,' Wrong map file, unit=',munit,', for RDM file.'
	   STOP
	ENDIF
C
C.. make sure it is a version 4 map
C
	If (mprcsb.Ne.4) Stop ' Not a version 4 Map'
C
C.. mark the rdm file as being mapped
C
	mapped(Curfil) = .TRUE.		! mark the file as mapped
	sort(3,Curfil) = sort(3,Curfil) + 1
C
C.. save any critical values
C
	Short(2) = mRnum1
	Short(1) = mRnum2
	mRnum(Curmap) = Long		! number of map records
	Msort(Curmap) = mblock(44) + fldofs(Curfil)	!primary sort field
	RETURN
	END
                                                                                                                                                                                               