/*
 *				s p a n . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	span	Pattern Match -- Span Required Matching Characters
index		Pattern match -- span required matching characters

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 char *
	 span(s,cs)
	 char s[];
	 CSET *cs;

description

	Span() matches the longest leading substring of s that consists
	entirely of characters that are members of the cset cs.  It returns
	a pointer to the first character after the matched characters.

	The null that terminates s is never considered to be a member of the
	cset, and is never included in the spanned characters; if all the
	other characters in s are members of cs, span() returns a pointer
	to the trailing null.

	Span() differs from ospan() in that it must find at least one matching
	character; otherwise, it returns NULL.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=01
 * Edit history
 * 0.0 19-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif
#define NULL 0

char *
span(s,cs)
register char *s;
register CSET *cs;
{	register char *p;

	p = s;

	while (*s && csmember(cs,*s))
		s++;
	return((p != s) ? s : NULL);
}
                                                                                                                                                                                                                                                                