	Program NicDmp
C
C Program to Read the contents of a Nicolet 3091 Digital Scope
C and store the 4k data set in a file.  The user inputs the file
C name as the first thing.  If a control-C is entered the program
C will abort.  If a control-Z is entered in response
C to the file name, the program will terminate normally.
C
	BYTE AUXON(4),AUXOFF(4),FILNAM(20),ID(8),Norm(44)
	BYTE BUFFER(80),LINE(82),TERM(2),TRANSF(2),INBUF(5000)
	Byte Copy(5),CopOff(5),Blank,Minus,Zero,Nine,MinFlg,Char
	Integer*2 Data(4000)
	Integer*2 Count,I,Isave,RtnCod,Value,Reset,Silent
	Data TERM/1,10/		! Define one terminator which is LineFeed.
	DATA AUXON/27,'[','5','i'/	! Turn console auxilary port on.
	DATA AUXOFF/27,'[','4','i'/	! Turn console auxilary port off.
	Data Copy/27,'[','?','7','i'/	! Turn console(aux port) copy mode on.
	Data CopOff/27,'[','?','6','i'/	! Turn console(auxport) copy mode off.
	Data Reset/"1000/	! Receive, Reset the buffer - flush remains.
	Data Silent/"10000/	! Receive without echo.
	Data Blank/' '/,Minus/'-'/,Zero/'0'/,Nine/'9'/,MinFlg/.false./
C
C  Using Aleda:
	If ( LENABL(0, , ,RtnCod) ) Goto 10	! Enable console input.
	If ( Lenabl(1, , ,RtnCod) ) Goto 10	! Enable console output.
C			! Default buffers are defined for the console.
	Goto 100	! If console enable succeeded, jump over error msg.
C
10	WRITE(5,20) RTNCOD
20	FORMAT(' Console failed to enable, Aleda error = ',F5.0)
	Stop
c
100	CALL LPUTST('Nicolet 3091 dump routine.\')
C
110	Call LgetST('Enter the file name to receive the data',
     *       FilNam,20,RtnCod)
	If (RtnCod .EQ. 1) Stop	! Break was requested.
c
	OPEN(UNIT=10,NAME=FILNAM,TYPE='NEW',Form='UNFORMATTED')
c
120	If ( Lenabl(2,Buffer,80,Rtncod) .eq. 0 ) Goto 150 ! NICOLET Port on.
	Call Lerror(Rtncod,120,'Nic Ena Fail',12)	  ! Error occured.
	Close( unit=10, Dispose='DELETE' )
	Goto 110
C
150	Call Lrecev(2, , , RtnCod, Reset)	! Start receiving from NIC.
	Call CRLF
	Call LputST('You may start the RS-232 transmit now...\')
C
c	Now read the the Nic3091 ID:
	Call LGetLN(2,ID,8,RtnCod,1,Term)	! Read until terminator.
	If (RtnCod) Call Lerror(RtnCod,150,'Failed to read ID',17)
c
c Now read the data values, Expecting 4000 data points, 5 chars/point:
c Note that to be exact about this you have to interpret ID.
c
	Idata = 1			! Start with the first data point.
160	CALL LGETLN(2,LINE,5,RtnCod,1,TERM)	! Get a data value.
	Count = RtnCod				! This is true if no error.
	If (RtnCod .eq. -34) Goto 180		! If not a terminator go on.
	If (RtnCod .gt. 0) Goto 190		! This should be a terminator.
        Call Lerror(RtnCod,160,'Data point read',15) ! Some unexpected error.
	Call LputST( 'The transfer is being aborted.\' )
	Close( unit=10, Dispose='DELETE' )
	Goto 300	! Give up on this one, try another.
C
180	MinFlg = .false.
	Value = 0
	Do 185 I=1,5	! Decode the data Point.
	Char = Line(I)
	If ( Char .eq. Minus) Goto 184
	If ( Char .eq. Blank) goto 185
	Value = (Value * 10) + ( Char - zero)
	Goto 185
184	MinFlg = .true.
185	Continue
	If (MinFlg) Value = -Value
	If (Idata .gt. 4000) Goto 187
	Data(Idata) = Value
	Idata = Idata + 1
	Goto 160		! Loop for next data point
c
187	Call Lputst('Too many data points read, exceeds 4000\')
	Call Lputst('Proceeding to save the data anyway...\')
	Goto 205
c
190	Call LgetLN(2,Norm,44,RtnCod,1,term)	! Read the normalization data.
	Count = RtnCod
	If (RtnCod .gt. 0) Goto 200	
	Call Lerror (RtnCod,190,'Failed norm data read',21)
c
200	Continue
c  For now I am ignoring the normalization data.
c
205	Write (10) Data			! Avoid conversion to ASCII.
	Close (unit=10,dispose='KEEP')	! Close the file
	Call LputST( 'The data has been saved in file ')
	Call LputST( FilNam )
	Call LputST( '.\' )
300	Continue		! Entered from above to abort the transfer.
	Call Ldsabl(2)			! Disable the Nic input port.
	Goto 100			! Go for it again.
c
	END
                                                                                                                                                                      