
      PROGRAM UNLOAD
C FUNCTION: CONVERTS A FIXED BLOCK FILE TO TEXT FOR TRANSMISSION
C AUTHOR: R.A.WELLS, MAR81
C DESCRIPTION: EACH TWO BYTES OF THE INPUT FILE ARE CONVERTED TO
C THREE TEXT CHARACTERS IN THE OUTPUT FILE. THE TWO
C BYTES ARE TREATED AS THREE 6-BIT FIELDS (2 ZERO BITS ON THE
C FRONT). EACH 6-BIT FIELD IS CONVERTED TO AN ASCII CHARACTER
C BY ADDING 32. THE TEXT IS OUTPUT AS 64-CHARACTER LINES TO A
C SEQUENTIAL FILE.
C FOR EXAMPLE, EC 9A (1110 1100 1001 1010) BECOMES
C 2E(10 1110)('.'), 41(100 0001)('A'), 3A(11 1010)(':')
C
      LOGICAL*1 FIXFIL(32),TXTFIL(32),TXTBF2(3,256),BELL
      INTEGER*2 FIXBF2(256),RETRY
      LOGICAL*1 IBD,IBD2,IFILL
      INTEGER*2 IWD,IWD2
      COMMON IFILL,IBD
      EQUIVALENCE (IWD,IBD), (IWD2,IBD2)
      DATA ITRMI/5/,ITRMO/7/,LUNFIX/2/,LUNTXT/3/
      DATA KFIX/0/
      DATA BELL/7/
C
      WRITE (ITRMO,1001)
 1001 FORMAT (' UNLOAD V2.0  Converts fixed block files to text format')
 10   ASSIGN 15 TO RETRY
 15   WRITE (ITRMO,1500)
 1500 FORMAT (' Enter full source file name: ',$)
      READ (ITRMI,1510,END=9999) FIXFIL
 1510 FORMAT (32A1)
C
C     OPEN THE DRAWING FILE
C
 17   OPEN (UNIT=LUNFIX,NAME=FIXFIL,ACCESS='DIRECT',READONLY,
     *   ERR=90,TYPE='OLD',RECORDSIZE=128,ASSOCIATEVARIABLE=KFIX)
      ASSIGN 18 TO RETRY
 18   WRITE (ITRMO,1800)
 1800 FORMAT (' Enter full text file name: ',$)
      READ (ITRMI,1510,END=9999) TXTFIL
C
C     OPEN THE TEXT FILE
C
      OPEN (UNIT=LUNTXT,NAME=TXTFIL,TYPE='NEW',CARRIAGECONTROL='LIST',
     *   ERR=91)
C
C     PUT THE SOURCE FILE NAME AND BLOCKSIZE AS A NOTE IN THE TEXT FILE
C
      WRITE (LUNTXT,1900) FIXFIL
 1900 FORMAT (32A1,'512')
C
      IBLK=0
 25   IBLK=IBLK+1
      READ (LUNFIX'IBLK,ERR=50,END=50) FIXBF2
      DO 30 I=1,256
      IWD=FIXBF2(I)
      TXTBF2(1,I)=(IWD.AND."000077)+32
      TXTBF2(2,I)=(IWD.AND."007700)/64+32
      IWD2=0
      IBD2=IBD
      TXTBF2(3,I)=(IWD2.AND."360)/16+32
 30   CONTINUE
      WRITE (LUNTXT,3500) TXTBF2
 3500 FORMAT (64A1)
      GO TO 25
C
C     FINISHED. LOOP FOR MORE.
C
 50   CLOSE (UNIT=LUNTXT)
      CLOSE (UNIT=LUNFIX)
      GO TO 10
C
C	Here for open errors.
C
 90   WRITE (ITRMO,9000) FIXFIL, BELL
 9000 FORMAT (' Unable to open file "',32A1,'" please try again.',A1)
      GO TO RETRY
 91   WRITE (ITRMO,9000) TXTFIL, BELL
      GO TO RETRY
 9999 CALL EXIT
      END
                                                                                                                                           