!&                                                                    &
!&**********************************************************************&
!&*                                                                    *&
!&*     V I R T U L . B A S     PROGRAM TO READ RT11 VIRTUAL DEVICES   *&
!&*                                                                    *&
!&**********************************************************************&
!&                                                                      &
!&                                                                      &
!&      PROGRAM:     VIRTUL.BAS                                         &
!&                                                                      &
!&      VERSION:     V02                                                &
!&                                                                      &
!&      PROGRAMMER:     EDWARD F. BEADEL, JR.                           &
!&                      Lakeshore LUG                                   &
!&                      c/o C.A.U.S.E. Instructional Computer Center    &
!&                      SUNY at Oswego                                  &
!&                      Oswego, NY  13126                               &
!&                                                                      &
!&      Phone:          (315)-341-3055                                  &
!&                                                                      &
!&                                                                      &
!&      DATE:           15-JUN-82                                       &
!&      EDIT:           00                                              &
!&      EDIT DATE:      13-APR-83                                       &
!&      EDITED BY:      E.F.B.,JR.                                      &
!&                                                                      &
!&                                                                      &
!&**********************************************************************&
!&**********************************************************************&
!&                                                                      &
!&                                                                      &
!&                      COPYRIGHT (c) 1982, 1983                        &
!&                                  BY                                  &
!&              C.A.U.S.E. Instructional Computing Center               &
!&                State University of New York at Oswego                &
!&                          Oswego, NY   13126                          &
!&                                                                      &
!&               contact:       Edward F. Beadel, Jr., Manager          &
!&                 phone:       315/341-3055                            &
!&                                                                      &
!&                                                                      &
!&          This software is furnished in an as-is  condition,          &
!&          with  no committments of support or updates.  This          &
!&          software or any other copies thereof  may  NOT  be          &
!&          sold  for  profit  nor  can  it be included in any          &
!&          package to be sold for profit without the  written          &
!&          consent  of  the  author and the coppyright owner.          &
!&          This software may be used and copied only  in  ac-          &
!&          cordance  with  the terms set forth above and with          &
!&          the inclusion of the above copyright notice.                &
!&                                                                      &
!&               The information in this software  is  subject          &
!&          to  change  without  notice and should not be con-          &
!&          strued as a commitment by The State University  of          &
!&          New  York, The C.A.U.S.E.  Instructional Computing          &
!&          Center, the author(s)  or  maintainer(s)  of  this          &
!&          software.                                                   &
!&                                                                      &
!&               The  State  University  of  New   York,   The          &
!&          C.A.U.S.E.   Instructional  Computing  Center, the          &
!&          author(s), and the maintainer(s) of this  software          &
!&          collectively  and individually assume no responsi-          &
!&          bility  for  the  use  or  reliability   of   this          &
!&          software.                                                   &
!&                                                                      &
!&**********************************************************************&
!&**********************************************************************&
!
20      ! &
        &
        !       M O D I F I C A T I O N      H I S T O R Y &
        &
        &
        !       VER/EDIT        EDIT DATE       BY      REASON &
        &
        !       V02-01          07-AUG-84       David Smith (Galileo Computer Center)   &
        !                       Didn't work.    Fixed it to accomadate &
        !                       multi-segment directories, made it work & 
        !       V02-00          13-APR-83       E.F.B,Jr. Combine old  &
        !                                               DIRDEV.BAS and &
        !                                               VIRDEV.BAS into&
        !                                               one program.    &
        !       V01-01          15-JUN-82       E.F.B.,Jr. Original    &
        !                                               version of     &
        !                                               VIRDEV.BAS      &
        !       V01-00          14-JUN-82       E.F.B.,Jr. Original     &
        !                                               version of      &
        !                                               DIRDEV.BAS      &
        !
100     ! &
        &
        !       G E N E R A L    D E S C R I P T I O N & 
        &
        &
        !                                                               &
        !               DIRDEV.BAS                                      &
        !                                                               &
        !       This program intererprets an RT-11 SIG virtual-device   &
        ! file that has been copied to a RSTS/E system with RSTS's PIP  &
        ! and extracts the directory information.  The information      &
        ! is used by the program to extract the individual files,       &
        ! allowing the user the option of placing the files in another  &
        ! account and/or on media other than the system device.         &
        !                                                               &
        !                                                               &
        !                                                               &
        !
120     ! &
        &
        !       O P E R A T I N G     I N S T R U C T I O N S &
        &
        &
        !       Copy the virtual device from the sorce to a block       &
        ! structured device using PIP, eg.:                             &
        !       RUN (1,2)PIP.SAV                                        &
        !       **.*=MT0:EXAMPL.VER                                     &
        !       *^Z                                                     &
        ! Then run this program and follow the directions as they       &
        ! are given.                                                    &
        !
300     ! &
        &
        !       I / O     C H A N N E L S &
        &
        &
        !       CHANNEL #                       USED FOR &
        &
        !       1%              INPUT - the virtual device is opened    &
        !                               as a virtual array              &
        !                                                               &
        !       2%              OUTPUT - for the directory              &
        !                                                               &
        !       3%              INPUT - the virtual device is opened    &
        !                               for record input                &
        !                                                               &
        !       4%              OUTPUT - for the individual files that  &
        !                               make up the virtual device.     &
        !
400     ! &
        &
        !       V A R I A B L E    D E S C R I P T I O N S &
        &
        &
        !       V A R I A B L E                 P U R P O S E &
        &
        !       A$                      Receives a yes or no answer  &
        !       ACCT$                   Account number that is to receive the files form &
        !                                       the virtual device &
        !       DATE%                   Date the file on the virtual device was created &
        !                                       in RT-11 internal format &
        !       DEVICE%(32767), #1      The RT-11 virtual device that this program opens &
        !                                       as a virtual array &
        !       DIRECTORY%(1024)        An array that receives the directory information &
        !                                       extracted from the RT-11 virtual array &
        !       EXT$                    An extracted file's extention &
        !       EXTRACT.FLAG%           A logical flag that equals 1 if the program is to &
        !                                       extract the files from the virtual device &
        !                                       and equals 0 if only the directory  &
        !                                       information is to be extracted &
        !       F$                      An extracted file's filename &
        !       INBIN$                  Name given to the binary input buffer used in  &
        !                                       conjunction with file #3 for record &
        !                                       input &
        !       J%                      Used as a loop index in various places &
        !       M%                      Receives the number of bytes "read" for record &
        !                                       input and insturcts howmany bytes to &
        !                                       "write" for record output &
        !       NXTSEG%                 Receives the block address within the virtual &
        !                                       device that contains the next segement &
        !                                       of the virtual device's directory &
        !       OFFSET%                 Offset into the directory for current sgement   &
        !       OUTBIN$                 Name given to the binary output buffer used in  &
        !                                       conjunction with file #4 for record &
        !                                       output &
        !       OUTFILE$                Name of the file to which the extracted RT-11  &
        !                                       directory is written (#2) &
        !       RECOUNT                 Standard useage..ie. number of characters read &
        !                                       by the latest GET (record input) operation &
        !       SEGMENT%                Sgemnet number that we're working on    &
        !       SIZE%                   Receives the file size of the file to extract from &
        !                                       the directory of the RT-11 virtual device &
        !       STARTB%                 Contains the starting block number of the file to &
        !                                       extract &
        !       STAT$                   Receives the alphnumeric RT-11 status of the file  &
        !                                       being extracted &
        !       STAT%                   Receives the RT-11 status of the file being extracted &
        !       THISBLOCK%              Index of the loop that extractes files from the RT-11 &
        !                                       virtual device &
        !       VIRNAM$                 Name of the file containing the RT-11 virtual &
        !                                       device &
        !
        !       Cross Reference listing of VIRTUL.BAS &
        &       
        &
        ! If you need a cross-reference, use BPCREF on this     &
450     ! &
        &
800     ! &
        &
        !       D I M E N S I O N        S T A T E M E N T S  &
        &
        !
810 DIM #1%, DEVICE%(32767)                                             &
        \DIM DIRECTORY%(8192)                                           &
        ! Dimension the virtual device, and the array that will hold    &
        ! it's directory.                                               &
        !
1000    ! &
        &
        !       M A I N    C O D I N G     S E C T I O N &
        &
        !
1010 PRINT "Virtual device file name"                                   &
        \INPUT LINE VIRNAM$                                             &
        \PRINT "Output to? <TT:>"                                       &
        \INPUT LINE OUTFILE$                                            &
        \ OUTFILE$ = CVT$$(OUTFILE$,4%)                                 &
        \ OUTFILE$ = "TT:" IF LEN(OUTFILE$) = 0                         &
        \ OPEN OUTFILE$  FOR OUTPUT AS FILE #2                          &
        ! Get the name of the file that is the virtual image of a RT-11 &
        ! block-structured device.                                      &
        ! Find out where the user wishes a decoded version of the       &
        ! virtual device's directory to be output and open it.          &
        !
1020 OPEN VIRNAM$ FOR INPUT AS FILE #1%                                 &
        \FOR J% = 0% TO 1024%                                           &
        \DIRECTORY%(J%) = DEVICE%(1024%+512%+J%)                        &
        \NEXT J%                                                        &
        \ CLOSE 1%                                                      &
        ! Open the virtual device                                       &
        ! and read blocks 6, 7, 8, and 9 into array A%                  &
        !  Close the virtual device.                                    &
        !
1030 PRINT "Do you want to EXTRACT files ?"                             &
        \ PRINT "{WARNING files of the same name.ext will be replaced}" &
        \ INPUT A$                                                      &
        \ IF LEFT(CVT$$(A$,47%),1%) = "Y" THEN EXTRACT.FLAG% = 1%       &
                 ELSE EXTRACT.FLAG% = 0                         &
        ! Ask the question, get the answer, strip the garbage and       &
        ! convert to uppercase, take only the first letter and set      &
        ! the flag accordingly.                                         &
        !
1040 IF EXTRACT.FLAG% =  1 THEN                                         &
                PRINT "Device and account to receive file <SY:> ?"      &
                \ INPUT LINE ACCT$                                      &
                \ ACCT$ = CVT$$(ACCT$,4%)                               &
                \ IF LEN(ACCT$) = 0 THEN ACCT$ = "SY:"                  &
        ! If we are going to extract files, see if user wants them in   &
        ! some other account and/or disk                                &
        !
1045    OFFSET%=0%                                                      &
\       SEGMENT%=1%                                                     &
1050 PRINT #2%, "Total # of directory segments = "; DIRECTORY%(0%)      &
        \ NXTSEG% = ((DIRECTORY%(1%+OFFSET%)*1024%)+2048%)/512%         &
        \ PRINT #2%, "Next directory segment starts at block ";NXTSEG%  &
        \ PRINT #2%, "Highest segment used = "; DIRECTORY%(2%)  &
        \ PRINT #2%, "Extra bytes/directory entry = ";DIRECTORY%(3%+OFFSET%)&
        \ PRINT #2%, "Block # where the stored data starts = ";         &
                                DIRECTORY%(4%+OFFSET%)                  &
        ! Print the introduction tothe directory of the virtual         &
        ! device.                                                       &
        \ PRINT #2%, "Current segment ";SEGMENT%                        &
        !
1060 STARTB%=DIRECTORY%(4%+OFFSET%)                                     &
        \ SIZE%=0%                                                      &
        ! Initalize the starting block number and the file size         &
        ! variables                                                     &
        !
1070 PRINT #2%,                                                         &
        \ PRINT #2%, "FILE .EXT","START","SIZE","CODED DATE","DESCRIPTION"&
        \ PRINT #2%                                                     &
        !
2000 FOR J%=5%+OFFSET% TO 1024% STEP 7%                                 &
        \ STARTB%=STARTB% + SIZE%                                       &
        \ STAT%=DIRECTORY%(J%)                                          &
        \ F$ = RAD$(DIRECTORY%(J%+1%)) + RAD$(DIRECTORY%(J%+2%))        &
        \ EXT$=RAD$(DIRECTORY%(J%+3%))                                  &
        \ SIZE%=DIRECTORY%(J%+4%)                                       &
        \ DATE%=DIRECTORY%(J%+6%)                                       &
        ! Start the loop, update the starting block number within the   &
        ! virtual device that points to the start of the file, extract  &
        ! the files status, the file  name and extension, it's size and &
        ! the encrypted date of creation                                &
        !
2100 IF STAT% = 256% THEN STAT$ = "Tentative File"                      &
        ELSE  IF STAT% = 512% THEN STAT$ = "***EMPTY FILE***"           &
        ELSE  IF STAT% = 1024% THEN STAT$ = "Permanent file"            &
        ELSE  IF STAT% = -31744% THEN STAT$ = "Protected permanent file"&
        ELSE  IF STAT% = 2048% THEN 32760                               &
        ! Decode the files status                                       &
        ! If the file's status is 2048% ("End of Segiment") then        &
        ! goto line 32760 to set up for an exit                         &
        !
2200 PRINT #2, F$+"."+EXT$,STARTB%,SIZE%,DATE%,STAT$                    &
        ! Print the "Directory" of the virtual device                   &
        !
2300 IF STAT% = 512% THEN 3000                                          &
        ! Don't try to extract empty files                              $
2400 IF EXTRACT.FLAG% = 1% THEN                                         &
         OPEN VIRNAM$ FOR INPUT AS FILE 3%                              &
        \ FIELD #3%, 512% AS INBIN$                                     &
        \ OPEN ACCT$ + F$ + "." + EXT$ FOR OUTPUT AS FILE 4%,           &
                RECORDSIZE 512%                                         &
        \ FIELD #4%, 512% AS OUTBIN$                                    &
        \ FOR THISBLOCK% = STARTB% + 1% TO STARTB% + SIZE%              &
                \ GET #3%, RECORD THISBLOCK%                            &
                \ M% = RECOUNT                                          &
                \ LSET OUTBIN$ = INBIN$ + ""                            &
                \ PUT #4%, COUNT M%                                     &
                \ NEXT THISBLOCK%                                       &
        \ CLOSE 3%, 4%                                                  &
        ! If the user wants to extract the files from the virtual       &
        ! device, then open the virtual device and the receiver file,   &
        ! get the file from the virtual device and put it in the&
        ! receiver file, close the files                                &
        !
3000 NEXT J%                                                            &
        ! Loop back for next directory entry                            &
        !
3100 GO TO 32760                                                        &
        ! Go close things down in an orderly fashion                    &
        !
32000   ! &
        &
        !       E X I T    R O U T I N E S    &
        &
        !
32760   SEGMENT%=SEGMENT%+1%                                            &
\       GOTO 32765 IF SEGMENT%>DIRECTORY%(0%)                           &
\       OFFSET%=J%+3%                                                   &
\       GOTO 1050                                                       &
!       Kluge to handle multi-segment directories.  Don't blame me, I've&
!       never seen RT-11 directories before                             &
32765   CLOSE 2%                                                        &
        ! Close the output file for the directory.                      &
        !
32767   END                                                             &
        ! Let's call it quits.                                          &
        !
                                                                                                                                                                                                                                                                                                                   