      PROGRAM TAPEDR

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90l06a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Make a directory of a VMS backup magnetic tape listing the names
C	of the several savesets on the tape along with other pertinent
C	data.
C
C	Call a routine to clear the screen.  Then identify the program
C	and its version.  Call a routine to control the initialization
C	process.  Call a routine to control the making of the tape
C	directory.  Call a routine to shut things down, neat and clean.
C	Finally, terminate the program with a parting message.
C
C	If the initialization routine returns an error condition, skip
C	directly to the termination routine call.
C
C
C Edit Record:
C
C	12-Oct-90:  Original creation started.
C	08-Nov-90:  Original creation completed.
C	27-Nov-90:  Added code to convert the HDR1 date.
C	06-Dec-90:  Cleaned up documentation.
C
C
C Building Requirements:
C
C	The following files are required for building this program:
C
C	Filename	Version		Remarks
C
C	TAPEDR.COM	90k27a	Command file to build TAPEDR.SAV.
C
C	TAPEDR.DAT	90l06a	COMMON and variables declarations.
C
C	CLRSCR.FOR	90j31a	Clear the terminal screen.
C	CNVDAT.FOR	90k27a	Convert the HDR1 date.
C	DOEOF1.FOR	90j31a	Report EOF1 data.
C	DOHDR1.FOR	90l06a	Report HDR1 data.
C	DOHDR2.FOR	90j31a	Report HDR2 data.
C	DORCD1.FOR	90j31a	Report saveset data.
C	GETFLD.FOR	90l06a	Get a directory data field.
C	GETID.FOR	90j31a	Get data field identification.
C	GETLEN.FOR	90j31a	Get data field length.
C	MNTTAP.FOR	90j31a	Mount the magnetic tape.
C	OPNFIL.FOR	90l06a	Open the output file.
C	RDVOL1.FOR	90j31a	Read the VOL1 label record.
C	TAPEDR.FOR	90l06a	This main control module.
C	TDINIT.FOR	90j31a	Initialization control module.
C	TDQUIT.FOR	90j31a	Termination module.
C	TDWORK.FOR	90k01a	Work control module.
C	WRTDIR.FOR	90j31a	Write directory data.
C
C	F77OTS.OBJ		FORTRAN 77 library.
C	MTLIB.OBJ		Magnetic tape subroutine library.
C	SYSLIB.OBJ		System subroutine library.
C
C	F77.SAV			FORTRAN 77 compiler.
C	LINK.SAV		RT-11 linker.
C
C	Copy the files from the distribution media as follows:
C
C		COPY	dev:TAPEDR.DSK	dev:TAPEDR.TMP
C
C	Then unpack the logical device as follows:
C
C		MOUNT	LDx	TAPEDR.TMP
C		CREATE/ALL:yyy	TAPEDR.DSK	      !Where yyy => 988.
C		MOUNT	LDz	TAPEDR.DSK	DK
C		COPY	LDx:	DK:
C		DISMOUNT	LDx
C		DELETE	TAPEDR.TMP
C
C	Build the program TAPEDR.SAV by executing the command file,
C	TAPEDR.COM as follows:
C
C		DISPLAY	:==	TIME		      !For RT-11 only.
C		@TAPEDR.COM
C
C
C Executing Instructions:
C
C	Under RT-11, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		LOAD	<mag tape handler>
C		SET	USR	NOSWAP		      !RT11SJ only.
C		RUN	<dev:>TAPEDR
C
C	Under TSX-Plus, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		RUN	<dev:>TAPEDR
C
C
C Hiearchical Diagram:
C
C	An asterisk following a module name indicates that there are
C	multiple calls made to the module.  Library routines are
C	identified with comments.
C
C	TAPEDR
C	    CLRSCR
C		PRINT			SYSLIB routine.
C	    TDINIT
C		MNTTAP
C		    MTFOR		MTLIB routine.
C		OPNFIL
C		    GTLIN		SYSLIB routine.
C		    DATE		SYSLIB routine.
C		    TIME		SYSLIB routine.
C		RDVOL1
C		    MTFOR		MTLIB routine.
C	    TDWORK
C		MTFOR		*	MTLIB routine.
C		DOHDR1
C		    CNVDAT
C		DOHDR2
C		DOEOF1
C		DORCD1
C		    GETLEN
C		    GETID
C		    GETFLD
C		    WRTDIR
C	    TDQUIT
C		MTFOR			MTLIB routine.
C
C
C Routines Called:
C
C	CLRSCR
C	TDINIT
C	TDQUIT
C	TDWORK
C
C***********************************************************************

      INCLUDE 'TAPEDR.DAT'		!Common & variables declarations

      CALL CLRSCR			!Clear the screen.
      TYPE *, ProgID			!Progran identification and
      TYPE *				! version.

      CALL TDINIT			!Initialization.
      IF (Error) GOTO 900

      CALL TDWORK			!Perform the task at hand.

900   CONTINUE
      CALL TDQUIT			!Neat and clean.

      TYPE *, EndMsg			!Say we're done.
      TYPE *

      END				!TAPEDR.FOR.
                                                                                                                                                                                                                                                                                               