      SUBROUTINE DOHDR1

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90l06a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Report information from the HDR1 label record.
C
C	If the tape is not a VMS backup tape, set the error flag,
C	display an error message, and exit this subroutine.  Write the
C	saveset name to the output directory file.  Call a routine to
C	convert the HDR1 date to RT-11 format.  If an error condition is
C	returned exit this subroutine.  Write the creation date to the
C	output directory file.
C
C	If a write error occurs, set the error flag, display an error
C	message, and exit this subroutine.
C
C
C Edit Record:
C
C	23-Oct-90:  Original creation started.
C	31-Oct-90:  Original creation completed.
C	27-Nov-90:  Added code to convert the HDR1 date.
C	06-Dec-90:  Cleaned up documentation.
C
C
C Calling sequence:
C
C	LblRcd = <string>
C	OutLun = <integer>
C	CALL DOHDR1
C
C
C Returns:
C
C	Error
C
C
C Called By:
C
C	TDWORK
C
C
C Routines Called:
C
C	CNVDAT
C
C***********************************************************************

      INCLUDE 'TAPEDR.DAT'		!Common & variables declarations

      IF (LblRcd(61:72) .NE. 'DECVMSBACKUP') THEN
          Error = .TRUE.
          TYPE *, 'DOHDR1:  tape not VMS backup'
          GO TO 900
      ELSE
          WRITE (OutLun,*,ERR=850) 'Saveset Name:                 ',
     *        LblRcd(5:21)
          CALL CNVDAT
          IF (Error) GOTO 900
          WRITE (OutLun,*,ERR=850) 'Creation Date:                ',
     *        DaMoC(1:2),'-',MonthC(1:3),'-',YearC(1:2)
      END IF
      GOTO 900

850   CONTINUE
      Error = .TRUE.
      TYPE *, 'DOHDR1:  write error'

900   CONTINUE
      RETURN
      END				!DOHDR1.FOR.
                                                                                                                                                