      SUBROUTINE SDWORK

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90l06a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Control the process of making a saveset directory.
C
C	Enter a loop and call a routine to read a data record from the
C	tape.  If a tape mark is encountered, exit the loop.  If the
C	data record is the first one, call a routine to get the XOR
C	grouping factor.  If the record is the last one, exit the loop.
C	Call a routine to scan and extract any file directory
C	information that may be present.  Loop back for another pass.
C
C	If an error condition is returned by any of the called routines,
C	exit this subroutine.
C
C
C Edit Record:
C
C	13-Nov-90:  Original creation started.
C	06-Dec-90:  Original creation completed.
C
C
C Calling sequence:
C
C	BtBfLn = <integer>
C	MtDvNm = <string>
C	Read = <integer>
C	CALL SDWORK
C
C
C Called By:
C
C	SVSTDR
C
C
C Routines Called:
C
C	MTFOR
C
C***********************************************************************

      INCLUDE 'SVSTDR.DAT'		!Common & variables declarations

100   CONTINUE

          CALL MTFOR (MTDvNm,Read,BtBfLn,ByteBf,Iret)
          IF (Iret .EQ. 0) GOTO 900	!End of saveset, exit loop.
          BytPtr = 0

          IF (SSRcNm .EQ. 1) THEN	!Get the XOR grouping factor.
              CALL GETXOR
              IF (Error) GO TO 900
          END IF

          IF (MOD(SSRcNm,XORFct+1) .EQ. 0) THEN
              GOTO 100			!Skip over the XOR data records.
          END IF

          IF (LRFlg .EQ. 2) GOTO 900	!Last record is an XOR.

          BytPtr = BytPtr + (16 - MOD(BytPtr,16)) + 1
200       CONTINUE
              IF ((ByteBf(BytPtr) .EQ. 0) .AND.
     *            (ByteBf(BytPtr+1) .EQ. 1) .AND.
     *            (ByteBf(BytPtr+2) .EQ. 3) .AND.
     *            (ByteBf(BytPtr+3) .EQ. 0)) THEN
                  CALL GETDIR		!Extract directory data.
                  BytPtr = BytPtr + (16 - MOD(BytPtr,16)) + 1
              ELSE
                  BytPtr = BytPtr + 16	!Bump the pointer.
                  IF (BytPtr .GT. SSRcLn) GOTO 300
              END IF
          GOTO 200
300       CONTINUE

      GOTO 100

900   CONTINUE
      RETURN
      END				!SDWORK.FOR.
                                                                                                                                                                             