      PROGRAM CVRCDS

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Convert VMS ASCII data records to RT-11 style ASCII records.
C
C	VMS ASCII records consist of a 16-bit integer character count
C	followed by the characters and a null byte if the character
C	count is odd.  RT-11 ASCII records consist of the characters
C	followed by a CARRIAGE RETURN and a LINE FEED.
C
C	Call a routine to clear the screen.  Then identify the program
C	and its version.  Call a routine to control the initialization
C	process.  Call a routine to control the conversion of the data
C	records.  Call a routine to shut things down, neat and clean.
C	Finally, terminate the program with a parting message.
C
C	If the initialization routine returns an error condition, skip
C	directly to the termination routine call.
C
C
C Edit Record:
C
C	24-Apr-91:  Original creation started.
C	04-Jun-91:  Original creation completed.
C
C
C Building Requirements:
C
C	The following files are required for building this program:
C
C	Filename	Version		Remarks
C
C	CRCMPL.COM	91e07a	Compile the .FOR modules.
C	CRLINK.COM	91e07a	Link the .OBJ modules.
C	CRMEM.COM	91d24a	Set the memory partition allocation.
C	CVRCDS.COM	91d24a	Command file to build CVRCDS.SAV.
C
C	CVRCDS.DAT	91f04a	COMMON and variables declarations.
C
C	CLRSCR.FOR	91d24a	Clear the screen.
C	CRINIT.FOR	91f04a	Control the initialization process.
C	CRQUIT.FOR	91f04a	Control the termination process.
C	CRWORK.FOR	91f04a	Control the task at hand.
C	CVRCDS.FOR	91f04a	This main control module.
C	CVTRCD.FOR	91f04a	Convert an ASCII data record.
C	GTFLNM.FOR	91f04a	Get the I/O file names.
C	OPNFLS.FOR	91f04a	Open the I/O files.
C	RDRCD.FOR	91f04a	Read an input file block.
C	TSFLNM.FOR	91f04a	Convert file name to RAD50.
C	WTRCD.FOR	91f04a	Write an output file ASCII record.
C
C	F77OTS.OBJ		FORTRAN 77 library.
C	SYSLIB.OBJ		System subroutine library.
C
C	F77.SAV			FORTRAN 77 compiler.
C	LINK.SAV		RT-11 linker.
C
C	Copy the files from the distribution media as follows:
C
C		COPY	dev:CVRCDS.DSK	dev:CVRCDS.TMP
C
C	Then unpack the logical device as follows:
C
C		MOUNT	LDx	CVRCDS.TMP
C		CREATE/ALL:yyy	CVRCDS.DSK	      !Where yyy => 988.
C		MOUNT	LDz	CVRCDS.DSK	DK
C		COPY	LDx:	DK:
C		DISMOUNT	LDx
C		DELETE	CVRCDS.TMP
C
C	Build the program, CVRCDS.SAV, by executing the command file,
C	CVRCDS.COM, as follows:
C
C		DISPLAY	:==	TIME		      !For RT-11 only.
C		@CVRCDS.COM
C
C
C Executing Instructions:
C
C	Execute this program as follows:
C
C		RUN	dev:CVRCDS
C
C
C Hiearchical Diagram:
C
C	An asterisk following a module name indicates that there are
C	multiple calls made to the module.  Library routines are
C	identified with comments.
C
C	CVRCDS
C	    CLRSCR
C		PRINT			SYSLIB routine.
C	    CRINIT
C		GTFLNM
C		    GTLIN		SYSLIB routine.
C		    TSFLNM
C		OPNFLS
C	    CRWORK
C		RDRCD
C		CVTRCD
C		    RDRCD	*
C		    WTRCD	*
C		WTRCD
C	    CRQUIT
C
C
C Routines Called:
C
C	CLRSCR
C	CRINIT
C	CRQUIT
C	CRWORK
C
C***********************************************************************

      INCLUDE 'CVRCDS.DAT'		!Common & variables declarations

      CALL CLRSCR			!Clear the screen.
      TYPE *, ProgID			!Program identification and
      TYPE *				! version.

      CALL CRINIT			!Initialization.
      IF (Error) GOTO 900

      CALL CRWORK			!Perform the task at hand.

900   CONTINUE
      CALL CRQUIT			!Neat and clean.

      TYPE *, EndMsg			!Say we're done.
      TYPE *

      END				!CVRCDS.FOR.
                                                                                                                                                                                                                                                                                                                                                    