/* TSCLIB.H - Parameter File for TSCLIB */

/* Additional suggestions:
	Window and region control block bits & offsets
*/


/* Non-Error Return */

#define ok 0

/* GVAL Negative Offsets */

#define	g.jobno		(-2)		/* Job Number */
#define	g.leadin	(-4)		/* "Lead-in" Character for terminal */
#define	g.sysprv	(-6)		/* 1 if has SYSPRV, 0 otherwise */
#define	g.iopage	(-8)		/* 1 if PAR 7 = I/O page, else 0 */
#define	g.proj		(-10)		/* Project number */
#define	g.prog		(-12)		/* Programmer number */
#define	g.licence	(-14)		/* Licence number */
#define	g.prio		(-16)		/* Current job priority */
#define	g.maxpri	(-18)		/* Maximum allowed job priority */
#define	g.uclblk	(-20)		/* Blocks/job in TSXUCL */
#define	g.primary	(-22)		/* Job # of primary process */
#define	g.boot		(-24)		/* Rad50 dev from which booted */
#define	g.lopri		(-26)		/* Minimum fixed-low-priority */
#define	g.hipri		(-28)		/* Maximum fixed-high-priority */
#define	g.parent	(-30)		/* Job number of parent process */


/* Job Status Word */

#define	jsw	(int*)044

#define	uswap$	0100000
#define	ttlc$	040000
#define	rstrt$	020000
#define	ttspc$	010000
#define	chnif$	04000
#define	virt$	02000
#define	ovly$	01000
#define	chain$	0400
#define	hlter$	0200
#define	tcbit$	0100
#define	spxit$	040
#define	edit$	020
#define	gtlin$	010


/* Error Bytes */

#define	errbyt	052
#define	userrb	053
#define		succs$	01
#define		warn$	02
#define		error$	04
#define		sever$	010
#define		ufatal$	020

/* Channel Status Word */

#define	activ$	0100000
#define	b.eof	020000
#define	eof$	020000
#define	dblk$m	017400
#define	dwrit$	0200
#define	renam$	0100
#define	indx$m	076
#define	b.hderr	01
#define	hderr$	01
	
/* Characters */

#define	con.c	03
#define	bel	07
#define	bs	010
#define	tab	011
#define	lf	012
#define	vt	013
#define	ff	014
#define	cr	015
#define	esc	033
#define	rubout	0177


/* CL SPFUNs */

#define	c.clr	201	/* Clear Handler */
#define	c.break	202	/* Control Break */
#define	c.rdbyt	203	/* Read with byte count */
#define	c.stat	204	/* Get handler status */
#define	c.term	205	/* Terminate I/O */

#define	c.setop	250	/* Set option flags */
#define	c.clrop	251	/* Clear option flags */
#define	c.setpg	252	/* Set page length */
#define	c.setsk	253	/* Set skip lines */
#define	c.setwi	254	/* Set page width */
#define	c.getms	255	/* Get modem status */
#define	c.speed	256	/* Set line speed */
#define	c.abort	257	/* Abort pending I/O */
#define	c.rdlin	260	/* Read a line of input */
#define	c.inpen	261	/* Get number of input characters pending */
#define	c.oupen	262	/* Get number of output characters pending */
#define	c.wrbyt	263	/* Write with byte cound */
#define	c.ends	264	/* Set ENDPAGE & ENDSTRING */
                                                                                                                                                                                                                                                                               