PROGRAM FFTEST(INPUT,OUTPUT);	{TEST FFT;  LINK FFTEST,L,PASCAL}

CONST	DT = 0.25;	{SAMPLING INTERVAL}
	M = 4;		{NUMBER OF POINTS}

TYPE COMPLEX = ARRAY [1..2] OF REAL;
TYPE ARRAYCOMPLEX = ARRAY [0..3] OF COMPLEX;	{3 = M-1}

VAR	Z: ARRAYCOMPLEX;
	LAYER, SIGN, I: INTEGER;
	T, DF: REAL;

PROCEDURE FFT(VAR Z: ARRAYCOMPLEX; VAR LAYER, SIGN: INTEGER); NONPASCAL;

BEGIN
DF:= 1/(M*DT);		{LOWEST FREQUENCY COMPONENT}
WRITELN ('DATA:');
FOR I:= 0 TO M-1 DO	{GENERATE 4 DATA POINTS}
	BEGIN
	T:= I*DT;
	Z[I,1]:= 1 + 3*SIN(DF* 6.2831*T) + 5*COS( 2*DF * 6.2831*T);
	Z[I,2]:= 0;		{PURELY REAL DATA POINTS}
	WRITELN(Z[I,1], Z[I,2]);
	END;

LAYER:= 2;		{LAYER AND SIGN MUST BE VARIABLES}
SIGN:= -1;
FFT (Z, LAYER, SIGN);	{FORWARD TRANSFORM ON 2 LAYERS (2**2 POINTS)}

WRITELN ('THE FFT IS:');
FOR I:= 0 TO M-1 DO WRITELN( Z[I,1], Z[I,2] )
{TYPEOUT:
	1	0	D.C TERM
	0      -1.5	EXP( DF * 2*PI*j*T )    FREQ = DF
	5	0	EXP( 2*DF * 2*PI*j*T )  NYQUIST FREQ. = 2*DF
	0	1.5	EXP( 3*DF * 2*PI*j*T) = EXP(-DF * 2*PI*j*T) NEQ.FREQ}
END.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       