C	FFTEST.FOR  TEST FFT;  LINK FFTEST,L
	COMPLEX Z(4)
	DATA DT/0.25/, M/4/
C	LOWEST FREQUENCY COMPONENT
	DF=1/(M*DT)
	TYPE *,'DATA:'
C	GENERATE 4 DATA POINTS
	DO 77 I=0,M-1
	T=I*DT
	X= 1 + 3*SIN(DF*6.2831*T) + 5*COS(2*DF*6.2831*T)
	Z(I+1) = CMPLX(X,0)
77	TYPE *,Z(I+1)

C	FORWARD TRANSFORM ON 2 LAYERS (2**2 POINTS)
	CALL FFT(Z,2,-1)

	TYPE *,'FFT:'
	DO 78 I=0,M-1
78	TYPE *,Z(I+1)
	STOP
C	TYPEOUT:
C	1	0	DC TERM
C	0      -1.5	EXP( DF*2*PI*j*T )    FREQ=DF
C	5	0	EXP( 2*DF*2*PI*j*T )  NYQUIST FREQ=2*DF
C	0	1.5	EXP( 3*DF*2*PI*j*T) = EXP(-DF * 2*PI*j*T) NEG.FREQ
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                