/* sktl95.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  skerrstring
 *
 *  returns the string associated with a particular error number
 *
 *  error number is formatted %4d at the beginning of the string
 */
static char *errs[] = {
	"   0 (Error Code)",
	/* addsess() messages */
	"  10 Require machine name/address",
	"  11 Querying the Domain Name Server",
	"  12 No name server, cannot resolve IP address",
	"  13 Internal Sdomain() allocation error",
	"  14 Trying to open TCP connection",
	"  15 Could not open the connection",
	"  16 Domain lookup failed",
	"  17 Domain lookup successful",
#ifdef	ERRORMESSAGES
	/* ??? */
	" 100 Network jammed, probable break in wire",
	" 101 Could not initialize hardware level network driver",
	" 102 The conflicting machine is using the same IP number",
	" 103 Request failed, an IP number is required",
	" 104 Event queue filled, probably non-fatal",
	/* IP: */
	" 300 Packet with options or wrong version received",
	" 301 Bad checksum",
	" 302 Fragmented packet reassembly error",
	" 303 Unknown higher layer protocol",
	/* TCP: */
	" 400 Bad checksum",
	" 401 Packet received for invalid port -- reset sent",
	" 402 ACK invalid, syn sent",
	" 403 Unknown state",
	" 404 Connection reset by other host",
	" 405 Null port specified for ack/trans",
	/* TCP: */
	" 500 Session limit reached",
	" 501 Socket limit reached",
	" 502 Job failed to start",
	" 503 Socket allocation error",
	" 504 Local host or gateway not responding",
	" 505 Not allowed to connect to broadcast address",
	" 506 Host is refusing connection",
	/* ICMP: */
	" 600 Echo reply",
	" 603 Destination unreachable",
	" 604 Source Quench",
	" 605 Redirect, another gateway is more efficient",
	" 608 Echo requested (ping requested)",
	" 611 Time Exceeded on Packet",
	" 612 Parameter problem in IP",
	" 613 Timestamp request",
	" 614 Timestamp reply",
	" 615 Information request",
	" 616 Information reply",
	" 699 Checksum error",
	/* UDP: */
	" 700 Bad checksum",
	/* Domain: */
	" 800 Name request to server failed",
	" 801 Using default domain",
	" 802 Name does not exist",
	" 803 UDP name server did not resolve the name",
	" 804 Name server failed, unknown reason",
	" 805 Host machine not in configuration file",
	" 806 Missing IP number, requires domain lookup",
	/* Session: */
	" 900 Cannot find or open configuration file",
	" 901 Cannot allocate memory for processing",
	" 902 Invalid keyword in configuration file",
	" 903 Element too long (>200), maybe missing quote",
	" 904 Probable missing quote marks, place field on one line",
	" 905 'name' field required before other machine entries",
	" 906 Invalid IP number",
	" 907 Subnet mask invalid",
	" 908 IP address for this machine is invalid",
	" 909 Invalid services request",
#endif
	""
};

static char errspace[80];	/* room for user-defined errors */

char *skerrstring(errno)
register int errno;
{
	register int i;
	char s[10];

	if(errno<0)
		return(errspace);

	sprintf(s,"%4d",errno);
	i = 1;
	do {
		if(!strncmp(errs[i],s,4))
			/*
			 * pointer to error message
			 */
			return(errs[i]+5);
		i++;
	/*
	 * until NULL found
	 */
	} while(*errs[i]);
	/*
	 * error unknown
	 */
	sprintf(errs[0],"%4d",errno);
	errs[0][4] = ' ';
	return(errs[0]);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             