/* queutl.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "queutl.h"


int quespace(w)
register struct window *w;
{
	register int diff;

	diff = w->wtptr - w->rdptr;
	if(diff>=0) {
		return(QUEUESIZE-1-diff);
	} else {
		return(-1-diff);
	}
}

/*
 *  enqueue
 *
 *  Place Data in Window Queue.
 *  QUEUESIZE is the size limitation of the advertised window.
 */
int enqueue(w,buffer,nbytes)
register struct window *w;
register char *buffer;
int nbytes;
{
	register int i;

	i = quespace(w);
	if(i<=0 || nbytes==0)
		/*
		 * no room at the inn
		 */
		return(0);

	if(nbytes>i)
		nbytes = i;
	/*
	 * room at end
	 */
	i = w->wtptr - w->where;
	i = QUEUESIZE - i;
	if(i<nbytes) {
		movebytes(w->wtptr,buffer,i);
		movebytes(w->where,(char *)(buffer+i),nbytes-i);
		w->wtptr = w->where + nbytes - i;
	} else {
		movebytes(w->wtptr,buffer,nbytes);
		if(i==nbytes) {
			w->wtptr = w->where;
		} else {
			w->wtptr += nbytes;
		}
	}
	/*
	 * more stuff here
	 */
	return(nbytes);
}

int quedata(w)
register struct window *w;
{
	register int diff;

	diff = w->wtptr - w->rdptr;
	if(diff>=0) {
		return(diff);
	} else {
		return(diff+QUEUESIZE);
	}
}

/*
 *  dequeue
 *
 *  This copies data out of a queue buffer
 *  and then deallocates it from the queue.
 *
 *  returns number of bytes copied from the queue
 */
int dequeue(w,buffer,nbytes)
register struct window *w;
register char *buffer;
register int nbytes;
{
	int i;

	i = quedata(w);
	if(i==0 || nbytes==0)
		return(0);

	if(i<nbytes)
		nbytes = i;

	i = w->rdptr - w->where;
	i = QUEUESIZE - i;
	if(i<nbytes) {
		movebytes(buffer,w->rdptr,i);
		movebytes((char *)(buffer+i),w->where,nbytes-i);
		w->rdptr = w->where + nbytes - i;
	} else {
		movebytes(buffer,w->rdptr,nbytes);
		if(i==nbytes) {
			w->rdptr = w->where;
		} else {
			w->rdptr += nbytes;
		}
	}
	return(nbytes);
}

/*
 *  rmqueue
 *
 *  does queue deallocation
 *  rmqueue of QUEUESIZE or greater bytes will empty the queue
 */
int rmqueue(w,nbytes)
register struct window *w;
register int nbytes;
{
	register int i;

	i = quedata(w);
	if(i==0)
		return(0);

	if(i<nbytes)
		nbytes = i;

	i = w->rdptr - w->where;
	i = QUEUESIZE - i;
	if(i<=nbytes) {
		w->rdptr = w->where + nbytes - i;
	} else {
		w->rdptr += nbytes;
	}
	return(nbytes);
}

int outqoff(skt)
register struct socket *skt;
{
	register int offset;

	if((skt->out.nxt != 0L) && (skt->out.ack != 0L)) {
		offset = (int) (skt->out.nxt - skt->out.ack);
		if((offset < 0) || (offset >= QUEUESIZE)) {
			skt->out.nxt = skt->out.ack;
			offset = 0;
		}
	} else {
		offset = 0;
	}
	return(offset);
}

/*
 *  outqpsh
 *
 *  Returns 1 if data should be sent
 */
int outqpsh(skt)
register struct socket *skt;
{
	register unsigned int bytes,qbytes;
	int offset;

	offset = outqoff(skt);
	qbytes = quedata(&skt->out) - offset;
	bytes = skt->out.size - offset;
	if(qbytes > 0 && bytes > 0) {
		if(skt->out.push) {
			return(1);
		}
		if(qbytes >= skt->sendsize && bytes >= skt->sendsize) {
			return(1);
		}
	}
	return(0);
}

                                                                                                                                                                                                                                                                              