/* ftprep.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * ftpreplies
 *
 * get responses to commands to server
 * return TRUE on successful completion,
 * INCOMPLETE if more commands needed for operation,
 * NONE on lost connection, ABORT on an abort, and ERROR on failure
 * PRELIMINARY and TRANSIENT responses wait for completion
 */
int ftpreplies(rcode)
int *rcode;
{
	int abrtcnt,digit;
	register int cnt,ev,j;

#ifdef	DEBUGOPTION
if(debug&0x10) {
	printf("entering ftpreplies()\r\n");
}
#endif
	abrtcnt = 0;
	tfrabtf = 0;
	j = 0;
loop:	while(1) {
		/*
		 * get line from remote host
		 */
		cnt = rgetline();
#ifdef	DEBUGOPTION
if(debug&0x10 && !(debug&0x20)) {
		printf("cnt=rgetline(): =%d\r\n  s=%s\r\n",cnt,s);
}
#endif
		if(cnt == NONE)
			/*
			 * lost connection
			 */
			return(NONE);
		if(cnt == ABORT) {
			/*
			 * user abort
			 */
			if(ftpabort(&abrtcnt) == ABORT)
				return(ABORT);
			goto loop;
		}
		if(!sscanf(s,"%d",rcode))
			/*
			 * continuation line
			 */
			*rcode = -1;

		/*
		 * informative/error message or display on
		 */
		if(verbose || (*rcode == -1) || (*rcode >= 500))
			filter(cnt);

		if((*rcode/100) == 2) {
			/*
			 * wait till transfers complete
			 */
			while(ftpdskt >= 0) {
				ev = checkevent();
#ifdef	DEBUGOPTION
if(debug&0x10) {
				printf("checkevent()=%d\r\n",ev);
}
#endif
				if(ev == NONE) {
					/*
					 * lost connection
					 */
					return(NONE);
				}
				if(ev == ABORT) {
					/*
					 * user abort
					 */
					if(ftpabort(&abrtcnt) == ABORT)
						return(ABORT);
				}
			}
		}
#ifdef	DEBUGOPTION
if(debug&0x10) {
		printf("*rcode=%d\r\n", *rcode);
}
#endif
		if(s[3] == '-') {
			/*
			 * line with continuations
			 * remember end code
			 */
			j = *rcode;
			continue;
		} else
		if(j) {
			if(*rcode == j) {
				/*
				 * end of continuation
				 */
				j = 0;
			} else {
				continue;
			}
		}
		/*
		 * first digit
		 */
		digit = (int)(*rcode/100);
		if(abrtcnt) {
			switch(digit) {
			case 1:		/* preliminary */
			case 4:		/* transient negative completion */
				continue;

			case 2:		/* positive completion */
			case 3:		/* intermediate */
			case 5:		/* Permanent negative completion */
				return(ABORT);

			default:
				break;
			}
		} else {
			switch(digit) {
			case 1:		/* preliminary */
			case 4:		/* transient negative completion */
				continue;
	
			case 2:		/* positive completion */
				return(TRUE);

			case 3:		/* intermediate */
				return(INCOMPLETE);
		
			case 5:		/* Permanent negative completion */
				return(ERROR);

			default:
				break;
			}
		}
		kb_puts("Server response not understood.\r\n");
		kb_puts("Terminating command\r\n");
		return(abrtcnt ? ABORT : ERROR);
	}
}

/*
 * ftpabort
 *
 * attempt to abort FTP operation
 * return ABORT on unconditional abort
 */
int ftpabort(i)
int *i;
{
	finished = TRUE;
	switch(ftpstate) {
		default:	/* Invalid states */
		case 0:
			break;

		case 20:	/* finished == TRUE */
		case 21:	/* will terminate transfers */
		case 22:
			break;

		case 30:
		case 31:
		case 40:
		case 41:
			/*
			 * Send the abort as an urgent message
			 */
			sksendwait(ftpcskt,(long) SENDWAIT);
			skwurgent(ftpcskt,1);
			/* IAC IP IAC DM */
			skwrite(ftpcskt,"\377\364\377\362",4);
			skwrite(ftpcskt,"ABOR\r\n",6);
			skenque(ftpcskt,1);
			sksendwait(ftpcskt,(long) SENDWAIT);
			skwurgent(ftpcskt,0);
			break;
	}
	*i += 1;
	if(*i > 2) {
		kb_puts("\r\nUnconditonal ABORT\r\n");
		return(ABORT);
	} else {
		kb_puts("\r\nAttempting to ABORT operation ...\r\n");
		return(0);
	}
}

/*
 * rgetline - get a line from remote server
 *
 * return ABORT on an abort, NONE on lost connection,
 * length of received line on success
 */

int rgetline()
{
	register int i,icnt,cnt,ev;

#ifdef	DEBUGOPTION
if(debug&0x20) {
	printf("entering rgetline()\r\n");
}
#endif
	i = 0;
	while(1) {
		ev = checkevent();
#ifdef	DEBUGOPTION
if(debug&0x20) {
		printf("checkevent()=%d\r\n", ev);
}
#endif
		switch(ev) {
		case NONE:	/* lost connection */
			skdeque(ftpcskt);

		case ABORT:	/* abort */
#ifdef	DEBUGOPTION
if(debug&0x20) {
			printf("leaving rgetline()\r\n");
}
#endif
			return(ev);

		case HAVEDATA:
			/*
			 * get some from queue
			 */
			icnt = 0;
			while(1) {
				cnt = skread(ftpcskt,&s[i],1);
				if(cnt == 0)
					/*
					 * nothing available
					 */
					break;
				icnt = 1;
				if((s[i++] == '\n') || (cnt < 0)){
					/*
					 * end of line
					 */
					s[i] = '\0';
#ifdef	DEBUGOPTION
if(debug&0x20) {
					printf(
			"i=%d, s=%s\r\nleaving rgetline()\r\n", i,s);
}
#endif
					skdeque(ftpcskt);
					/*
					 * return line length
					 */
					return(i);
				}
				if(i > sizeof(s) - 2)
					i = sizeof(s) - 2;
			}
			if (icnt)
				skdeque(ftpcskt);
			break;

		default:	/* ignore other events */
			break;
		}
	}
}
                                                                                                                                                                                                                 