/* ftppi5.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

VOID ftppi5(cmdno,command)
register int cmdno;
register char *command;
{
	register int curfilemode;
	char cmndline[82];
	char word[50];

	switch(cmdno) {
	case DIR:		/* get list of remote files */
	case LS:
		curfilemode = setmode(FASCII);
		sprintf(cmndline,cmdno==DIR ? "LIST" : "NLST");
		if(getword(command,word)) {
			sprintf(&cmndline[4]," %s",word);
		}
		ftpdo(cmndline);
		setmode(curfilemode);
		return;

	case GET:
	case RECV:		/* get remote file */
		if(askq(command,79,"File: "))
			return;
		sprintf(cmndline,"RETR %s",command);
		ftpdo(cmndline);
		return;		

	case MKDIR:		/* create directory */
		if(askq(command,79,"Directory: "))
			return;
		/*
		 * try XMKD
		 */
		sprintf(cmndline,"XMKD %s",command);
		if(ftpdo(cmndline) != ERROR)
			return;
		kb_puts("Trying again...\r\n");
		/*
		 * else try MKD
		 */
		sprintf(cmndline,"MKD %s",command);
		ftpdo(cmndline);
		return;

	default:
		return;
	}
}

/*
 *  setmode
 *
 *  set the transfer mode
 *  and return old mode
 */
int setmode(mode)
register int mode;
{
	register int cmode;

	cmode = ftpfilemode;
	switch(mode) {
	default:
		kb_puts("Invalid ftpfilemode, defaulting to ASCII\r\n");

	case FASCII:
		if (cmode != FASCII)
			ftpdo("TYPE A");
		break;

	case FIMAGE:
		if (cmode != FIMAGE)
			ftpdo("TYPE I");
		break;

	}
	return(cmode);
}
                                                                                                                                                                                                                                       