/* ftpopn.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 *  ftpopen
 *
 *  open an FTP connection
 */
int ftpopen(dst,port)
int port;
char *dst;
{
	register struct socket *skt;
	register struct machinfo *mp;
	register int flag;
	int cl,ev,dat;
	char st[82];

	/*
	 * Open a control connection
 	 */
	ftpcskt = opensess(dst,port);
	if(ftpcskt >= 0) {
		flag = 1;
	} else {
		flag = 0;
	}
	while(flag && !tstbrk()) {
	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev =  Sgetevent(USERCLASS  | CONCLASS  | SCKTCLASS |
			TCPCLASS   | MSGCLASS  | ERRCLASS  |
			ABORTCLASS | SCKTABORT | SRVCCLASS |
			SRVCATTACH | SRVCABORT | TASKCLASS,
			&cl, &dat);
	if(ev!=0 && dat==ftpcskt) {
	  switch(cl) {
	    case CONCLASS:
	      switch(ev) {
		case CONOPEN:
		  return(TRUE);

		case CONCLOSE:
		case CONFAIL:
		  flag = 0;
		  break;

		default:
		  Stmrset(cl,ev,dat,1);
		  break;
	      }
	      break;

	    case USERCLASS:		/* domain class */
	      skt = (struct socket *) skvalid(dat);
	      if(skt==-1) {
		flag = 0;
		break;
	      }
	      switch(ev) {
		  case DOMFAIL:
		    skptevent(ERRCLASS,16,dat);
		    skptevent(CONCLASS,CONFAIL,dat);
		    break;

		  case DOMOK:
		    mp = skt->mpp;
		    if(mp) {
		      skptevent(MSGCLASS,17,dat);
		      if(mp->sname) {
			if(mp->port!=skt->sktport) {
			  sprintf(st,"%s #%u",mp->sname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,st);
			} else {
			  addsess(dat,mp->sname);
			}
		      } else {
			if(mp->port!=skt->sktport) {
			  sprintf(st,"%s #%u",mp->hname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,st);
			} else {
			  addsess(dat,mp->hname);
			}
		      }
		    } else {
		      skptevent(ERRCLASS,16,dat);
		      skptevent(CONCLASS,CONFAIL,dat);
		    }
		    break;

		  default:
		    break;
	      }
	      break;

	    case MSGCLASS:
	    case ERRCLASS:
	      if( ev<100 || errmsg ) {
		kb_puts(skerrstring(ev));
		kb_nline();
	      }
	      break;

	    /*
	     * Unused Classes
	     */
	    default:
	      break;
	  }
	}	/* in    */
	}	/* while */
	/*
	 * error on open
	 */
	skclose(ftpcskt);
	ftpcskt = skrelease(ftpcskt,1);
	skclose(ftpdskt);
	ftpdskt = skrelease(ftpdskt,1);
	errhandle();
	kbprintf("Unable to connect to %s\r\n",dst);
	return(FALSE);
}
                                                                                                                                                                                                                                                                                         