/* dfault.h */

/*
 *  define number of sockets
 */
#define	LSCKTS		 2

/*
 *   Defines which have to do with Ethernet defaults.
 *
 *   The endrvr receive buffers have been set for packets
 *   with a maximum length of 566. bytes.  Thus MAXSEG
 *   must be limited to 512 bytes of data for a TCP packet.
 */
#define DADDLEN 	6		/* 6-byte ether address */
#define	LOWWATER	100		/* low water mark for input queue */
#define HIWATER		400		/* high water mark for output queue */
#define	HASHSIZE	1024		/* hash mark increment */
#define QUEUESIZE 	514		/* input/output queue length */
#define MINWNDOSIZE	128		/* minumum window size limit */
#define DEFWINDOW 	512		/* default window size for config */
#define MAXWNDOSIZE	513		/* maximum window size limit */
#define MINSEG		128		/* minimum mseg transfer size(in) */
#define DEFSEG		512		/* default segment size for config */
#define MAXSEG		512		/* maximum mseg transfer size(in) */
#define TMINSIZE	128		/* minimum mtu data packet size */
#define TSENDSIZE 	512		/* default data packet size(out) */
#define TMAXSIZE 	512		/* maximum mtu data packet size */
#define UMAXLEN 	512		/* maximum udp packet length */
#define	MINPCNT		1		/* minimum packets per transq */
#define	MAXPCNT		5		/* maximum packets per transq */

/*
 *  timing intervals in ticks (unless noted).
 */
#define TICKSPERSEC	   60
#define WRAPTIME      5184000L		/* ticks in a 24 hour period */

#define POKEINTERVAL	 1800
#define MAXRTO  	  300
#define MINRTO 		   20
#define ARPTIMEOUT	    5		/* in seconds */
#define	DOMTIMEOUT	    5		/* in seconds */
#define DLAYTIMEOUT	   15		/* in seconds */
#define CACHETO        216000L
#define	RELEASETIME	  150		/* RELEASETIME  <  WAITTIME */
#define WAITTIME	  300		/* WAITTIME     <  SENDWAIT */
#define	SENDWAIT	  600		/* SENDWAIT     <  LASTTIME */
#define LASTTIME 	 1200		/* LASTTIME                 */
#define CONNWAITTIME	   20		/* in seconds */
#define	ATTACHTIMEOUT	   10		/* in seconds */

#define	UDPTTL		   60		/* 'time to live' in router hops */
#define	TCPTTL		   60		/* 'time to live' in router hops */

#define CACHELEN 	   10
#define	DOMRETRY	    2

                                                                                                                                                                                                                                                                                                                                                                                      