/* arpchk.c */

/*
 * Includes
 */
#include <stdio.h>

#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"

/*
 *  arpinterpret
 *
 *  interpret ARP packets
 *  Look at incoming ARP packet and make required assessment of usefulness,
 *  check to see if we requested this packet, clear all appropriate flags.
 */
int arpinterpret(pkt)
register ARPKT *pkt;
{
	/*
	 *  check packet's desired IP address translation
	 *  to see if it wants me to answer.
	 */
	if(pkt->op==intswap(ARPREQ) && (comparen(pkt->tpa,nnipnum,4))) { 
#ifdef	DEBUGOPTION
if(ndebug&0x24) {
	dmpfil("arpreq",(ARPKT *)pkt,sizeof(ARPKT));
}
#endif
		/*
		 * keep her address for me
		 */
		cacheupdate(pkt->spa,pkt->sha);
		/*
		 * proper reply
		 */
		replyarp(pkt->sha,pkt->spa);
		return(0);
	}
	/* 
	 *  Check for a reply that I probably asked for.
	 */
	if(comparen(pkt->tpa,nnipnum,4) &&
		pkt->op==intswap(ARPREP) &&
		pkt->hrd==intswap(HTYPE) &&
		pkt->hln==DADDLEN && pkt->pln==4) {
		cacheupdate(pkt->spa,pkt->sha);
#ifdef	DEBUGOPTION
if(ndebug&0x24) {
	dmpfil("arprep",(ARPKT *)pkt,sizeof(ARPKT));
}
#endif
		return(0);
	}
#ifdef	DEBUGOPTION
if(ndebug&0x24) {
	dmpfil("arpinp",(ARPKT *)pkt,sizeof(ARPKT));
}
#endif
	return(1);
}

                                                                                                                                    