/* hstdef.h */

/*
 *  Host and local machine configuration information.
 */

#ifndef HOSTFORM_H

/*
*  Linked list of structures which describe other machines.
*  Arranged one per session with unique session names.
*/
struct machinfo {
	char 	*sname,		/* pointer to name of session */
		*hname,		/* pointer to name of that machine */
		hostip[4],	/* IP number of this machine */
		gateway,	/* gateway preference, start with 1 */
		nameserv,	/* nameserver preference, start with 1 */
		delete,		/* character deletion value */
		halfdup,	/* half duplex required */
		crmap;		/* Strange Berkeley 4.3 CR mode needed */
	int	port,		/* TCP port number to access, */
				/* telnet = 23 / ftp = 21 / other... */
		mno,		/* machine number for reference */
		mstat,		/* status of this machine entry */
		retrans,	/* initial retrans timeout */
		conto,		/* time out in seconds to wait for connect */
		window,		/* window, will be checked against buffers */
		maxseg,		/* maximum receivable segment size */
		mtu;		/* maximum transfer unit MTU (out) */
	struct machinfo *next;	/* surprise, its a linked list! */
				/* within a socket = NULL */
};

/*
 * 4.3BSDCRNUL Definition
 */
#define	BSDCRNUL	(-1)


extern struct machinfo	*Sgethost(),
			*Shostlook(),
			*Slooknum(),
			*Slookip(),
			*Smadd();
/*
 *  status fields for mstat, what do we know about that machine?
 */
#define NOIP	1	/* we don't have IP number */
#define UDPDOM	3	/* there is a UDP request pending on it */
/*
 *  The next 20 numbers are reserved for UDPDOM
 */
#define HAVEIP	50	/* at least we have the # */
#define HFILE	70	/* we have IP number from host file */
#define DOM	71	/* we have an IP number from DOMAIN */
/*
 *   Configuration information
 */
struct config {
char	netmask[4],	/* subnetting mask being used */
	havemask,	/* do we have a netmask? */
	myipnum[4],	/* what is my IP #? */
	me[70],		/* my name description (first 69 chars) */
	*defdom;	/* default domain */
struct service
	*srvc;		/* pointer to services list */
struct tasker
	*task;		/* pointer to task list */
int	nstype;		/* nameserver = 1-domain / 2-IEN-116 */
};


/*
 * Initial configuration.
 */

#ifdef CONFIG_DEF
struct machinfo *Sns = NULL;
struct config Scon = {
		0,0,0,0,	/* subnet mask */
		0,		/* do we have a net mask */
		0,0,0,0,	/* ip num */
		"",		/* my name */
		NULL,		/* pointer to default domain */
		NULL,		/* services list */
		NULL,		/* tasks list */
		1		/* name server type */
};

#else

extern struct machinfo *Sns;
extern struct config Scon;
#endif

extern char *Smachfile;

typedef struct service {
struct service
	*next;		/* linked list of services */
int	port,		/* incoming port number for service */
	maxses;		/* maximum sessions of this type */
char	cmdfil[16];	/* command file name to start service */
};

typedef struct tasker {
struct tasker
	*next;		/* linked list of tasks */
int	taskid,		/* task id number */
	timer,		/* time interval between task activation */
	jobnum;		/* internal job number */
char	cmdfil[16];	/* command file name to start task */
};

#define HOSTFORM_H
#endif

                                                                                                                                                                                                                                                                                                                                                                                                                   