/* scrnUZ.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"
#include "endrvr.h"

#include "fmtdat.h"
#include "vt1xx.h"

extern	char filstr[];

struct	status {
	int	blank;
	long	eiipkt;
	long	eiopkt;
	long	eirtmo;
	long	eixtmo;
	long	eirun[8];
	long	eixun[8];
};

char	xadd[10];
struct	status stats;
struct	status dstats;

scrnU(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register ARPKT *tl;
	register int row;
	char *ea;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #U)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	tl = &skt->tcpout;

	sprintf(s,
	"ARPKT		arp	size = %4.4d bytes", sizeof(struct plummer));
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"    DLAYER	d	size = %4.4d bytes", sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    ARPLAYER	a	size = %4.4d bytes",
		sizeof(struct plummer) - sizeof(struct ether));
	fmtplc(s,row++);

	row++;
	sprintf(s,
	"	ARPLAYER	a");
	fmtplc(s,row++);

	sprintf(s,
	"	hrd  . . . . . . . . . = 0x%04.4X", intswap(tl->hrd));
	fmtplc(s,row++);

	sprintf(s,
	"	pro  . . . . . . . . . = 0x%04.4X", intswap(tl->pro));
	fmtplc(s,row++);

	sprintf(s,
	"	hln  . . . . . . . . . = 0x__%02.2X", tl->hln & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	pln  . . . . . . . . . = 0x__%02.2X", tl->pln & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	op . . . . . . . . . . = 0x%04.4X", intswap(tl->op));
	fmtplc(s,row++);

	ea = &tl->sha;
	row++;
	sprintf(s,
	"	sha  . . . . . . . . . = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);

	ea = &tl->spa;
	sprintf(s,
	"	spa  . . . . . . . . . = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);

	ea = &tl->tha;
	row++;
	sprintf(s,
	"	tha  . . . . . . . . . = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);

	ea = &tl->tpa;
	sprintf(s,
	"	tpa  . . . . . . . . . = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);
}

scrnV(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register UDPKT *pkt;
	register int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #V)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	pkt = &skt->tcpout;

	uichar(&pkt->data);
}

scrnW(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register UDPKT *pkt;
	register int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #W)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	pkt = &skt->tcpout;

	uidata(&pkt->data,0);
}

scrnX(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register UDPKT *pkt;
	register int row;

	sknum = MSCKTS - 1;

	row = 0;
	sprintf(s,"SCKT%02.2d   (Screen #X)   Packet = %s", sknum, filstr);
	fmtplc(s,row++);

	row = 2;

	skt = (struct socket *) mapskt(sknum);
	if (skt == -1) {
		sprintf(s, "	No Diagnostic Packet Loaded !");
		fmtplc(s,row);
		return;
	}
	pkt = &skt->tcpout;

	uidata(&pkt->data,256);
}

uichar(pkt)
register TCPKT *pkt;
{
	register int c,j;
	register char *t;
	int i,row;
	char s[80];
	char *pos;

	row = 2;
	sprintf(s,
	"PKT	data");
	fmtplc(s,row++);

	row = 5;
	for(pos=pkt, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]    ", 64*i);
		for(t=s+12, j=0; j<64; j++) {
			c = *pos++;
			if(c<=31 || c>=127)
				c = '.';
			*t++ = c;
		}
		*t = 0;
		fmtplc(s,row+i);
	}
}

uidata(pkt,offset)
register TCPKT *pkt;
int offset;
{
	register int c,j;
	int i,row;
	char s[80],t[8];
	char *pos;

	row = 2;
	sprintf(s,
	"PKT	data");
	fmtplc(s,row++);

	row = 4;
	pos = pkt;
	for(pos+=offset, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]  ", 16*i + offset);
		for(j=0; j<16; j++) {
			sprintf(t,"  %02.2X", *pos++ & 0xFF);
			strcat(s,t);
		}
		fmtplc(s,row+i);
	}
}

scrnZ()
{
	char s[80];
	register int row;
	register long *ed,*es;

	engetaddr(xadd);

	for(row=0,ed=&dstats.eiipkt,es=&stats.eiipkt; row<19; row++) {
		ed[row] = es[row];
	}
	engetstats(&stats, sizeof(stats)>>1);
	for(row=0,ed=&dstats.eiipkt,es=&stats.eiipkt; row<19; row++) {
		ed[row] = es[row] - ed[row];
	}

	row = 0;
	sprintf(s,"(Screen #Z)");
	fmtplc(s,row++);

	sprintf(s,
	"			Ethernet Handler Statistics");
	fmtplc(s,row++);

	row += 2;
	sprintf(s,
	"	Physical Address  =  %02x-%02x-%02x-%02x-%02x-%02x",
		*xadd     & 0xFF, *(xadd+1) & 0xFF, *(xadd+2) & 0xFF,
		*(xadd+3) & 0xFF, *(xadd+4) & 0xFF, *(xadd+5) & 0xFF);
	fmtplc(s,row++);

	row += 2;
	sprintf(s,
	"	eiipkt = %8ld / %6ld       Receiver Interrupts",
		stats.eiipkt,dstats.eiipkt);
	fmtplc(s,row++);
	sprintf(s,
	"	eiopkt = %8ld / %6ld       Transmitter Interrupts",
		stats.eiopkt,dstats.eiopkt);
	fmtplc(s,row++);
	sprintf(s,
	"	eirtmo = %8ld / %6ld       Receiver Timeouts",
		stats.eirtmo,dstats.eirtmo);
	fmtplc(s,row++);
	sprintf(s,
	"	eixtmo = %8ld / %6ld       Transmitter Timeouts",
		stats.eixtmo,dstats.eixtmo);
	fmtplc(s,row++);

	row += 2;
	sprintf(s,
"	     EN0     EN1     EN2     EN3     EN4     EN5     EN6     EN7");
	fmtplc(s,row++);

	sprintf(s,
"	----------------------------------------------------------------");
	fmtplc(s,row++);

	row++;
	es = &stats.eirun[0];
	sprintf(s,
	"inppkt	%8ld%8ld%8ld%8ld%8ld%8ld%8ld%8ld",
	es[0], es[1], es[2], es[3], es[4], es[5], es[6], es[7]);
	fmtplc(s,row++);

	ed = &dstats.eirun[0];
	sprintf(s,
	"	%8ld%8ld%8ld%8ld%8ld%8ld%8ld%8ld",
	ed[0], ed[1], ed[2], ed[3], ed[4], ed[5], ed[6], ed[7]);
	fmtplc(s,row++);

	row++;
	es = &stats.eixun[0];
	sprintf(s,
	"outpkt	%8ld%8ld%8ld%8ld%8ld%8ld%8ld%8ld",
	es[0], es[1], es[2], es[3], es[4], es[5], es[6], es[7]);
	fmtplc(s,row++);

	ed = &dstats.eixun[0];
	sprintf(s,
	"	%8ld%8ld%8ld%8ld%8ld%8ld%8ld%8ld",
	ed[0], ed[1], ed[2], ed[3], ed[4], ed[5], ed[6], ed[7]);
	fmtplc(s,row++);
}
                                                                                                                                                                                                                                                                                                                              