/* scrnJO.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"

#include "fmtdat.h"
#include "vt1xx.h"

extern	char *cstate[];

scrnJ(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;
	int i;
	SQSPC *seqi;
	char c;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->in;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #J)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	windscrn(wind,"in");

	row = 15;

	sprintf(s,
/*
"        ---    --------    --------      ------        ----"
"        idx______sq(%x)_____nxt(%x)_____ptr(%o)_____flg(%x)"
"        [%c]    %8.8lx    %8.8lx      %6.6o        %4.4x",
*/
"        idx______sq(%%x)_____nxt(%%x)_____ptr(%%o)_____flg(%%x)"
			);
	fmtplc(s,row++);

	for(i=0; i<NITEMS; i++) {
		seqi = &skt->seq[i];
		if(i < skt->seqncs) {
			c = '0' + i;
		} else {
			c = '*';
		}
		sprintf(s,
	"        [%c]    %8.8lx    %8.8lx      %6.6o        %4.4x",
	c, seqi->sq, seqi->sqnxt, seqi->sqptr, seqi->sqflg
				);
		fmtplc(s,row++);
	}
}

scrnK(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->in;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #K)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	windchar(wind,"in");
}

scrnL(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->in;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #L)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	winddata(wind,"in");
}

scrnM(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->out;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #M)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	windscrn(wind,"out");
}

scrnN(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->out;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #N)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	windchar(wind,"out");
}

scrnO(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct window *wind;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	wind = &skt->out;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #O)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	winddata(wind,"out");
}

windscrn(wind,st)
register struct window *wind;
char *st;
{
	char s[80];
	register int row;

	row = 2;
	sprintf(s,
	"struct window %s	[%06.6o]	size = %4.4d bytes",
		st, wind, sizeof(struct window));
	fmtplc(s,row++);

	row = 4;
	sprintf(s,
	"	nxt . . . . . . . . . . = 0x%08.8lx", wind->nxt);
	fmtplc(s,row++);

	sprintf(s,
	"	ack . . . . . . . . . . = 0x%08.8lx", wind->ack);
	fmtplc(s,row++);

	sprintf(s,
	"	lasttime  . . . . . . . = 0x%08.8lx", wind->lasttime);
	fmtplc(s,row++);

	sprintf(s,
	"	where	[%06.6o]  size	=       %4.4d bytes",
		&wind->where, sizeof(wind->where));
	fmtplc(s,row++);

	sprintf(s,
	"	rdptr	[%06.6o]	=     %06.6o",
		&wind->rdptr, wind->rdptr);
	fmtplc(s,row++);

	sprintf(s,
	"	wtptr	[%06.6o]	=     %06.6o",
		&wind->wtptr, wind->wtptr);
	fmtplc(s,row++);

	sprintf(s,
	"	queue	[%06.6o]	=     %06.6o",
		&wind->queue, wind->queue);
	fmtplc(s,row++);

	sprintf(s,
	"	push  . . . . . . . . . =       0x%02.2x", wind->push & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	urgent  . . . . . . . . =     %06.6o", wind->urgent);
	fmtplc(s,row++);

	sprintf(s,
	"	size  . . . . . . . . . =     %6.6u", wind->size);
	fmtplc(s,row++);

	sprintf(s,
	"	port  . . . . . . . . . =     %6.6u", wind->port);
	fmtplc(s,row++);
}

static char *chrbgn = NULL;

windchar(wind,st)
struct window *wind;
char *st;
{
	register int c,j;
	register char *t;
	int diff,i,row;
	char s[80];
	char *pos;

	row = 2;
	sprintf(s,
	"Queue	%s.where	[%06.6o]	size = %4.4d bytes",
		st, wind->where, sizeof(wind->where));
	fmtplc(s,row++);

	if(chrbgn<wind->where || (wind->where+QUEUESIZE)<=chrbgn)
		chrbgn = wind->where;
	diff = wind->wtptr - chrbgn;
	if(diff<0)
		diff += QUEUESIZE;
	if(diff>=1024) {
		chrbgn = wind->wtptr - 512;
		if(chrbgn<wind->where)
			chrbgn = wind->where + QUEUESIZE;
	}
	chrbgn  = (char *) (((int) chrbgn) & 0xFFC0);
	chrbgn += (((int) wind->where) & 0x003F);

	row = 4;
	for(pos=chrbgn, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]    ", pos);
		for(t=s+12, j=0; j<64; j++) {
			c = *pos++;
			if(c<=31 || c>=127)
				c = '.';
			if(pos==wind->wtptr)
				c |= REVERSE;
			if(pos==wind->rdptr)
				c |= REVERSE;
			*t++ = c;
		}
		*t = 0;
		fmtplc(s,row+i);
		if(pos>=wind->where+QUEUESIZE)
			pos = wind->where;
	}
}

static char *datbgn = NULL;

winddata(wind,st)
struct window *wind;
char *st;
{
	register int c,j;
	int diff,i,row;
	char s[80],t[8];
	char *pos;

	row = 2;
	sprintf(s,
	"Queue	%s.where	[%06.6o]	size = %4.4d bytes",
		st, wind->where, sizeof(wind->where));
	fmtplc(s,row++);

	if(datbgn<wind->where || (wind->where+QUEUESIZE)<=datbgn)
		datbgn = wind->where;
	diff = wind->wtptr - datbgn;
	if(diff<0)
		diff += QUEUESIZE;
	if(diff>=256) {
		datbgn = wind->wtptr - 128;
		if(datbgn<wind->where)
			datbgn = wind->where + QUEUESIZE;
	}
	datbgn  = (char *) (((int) datbgn) & 0xFFC0);
	datbgn += (((int) wind->where) & 0x003F);

	row = 4;
	for(pos=datbgn, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]  ", pos);
		for(j=0; j<16; j++) {
			sprintf(t,"  %02.2x", *pos++ & 0xFF);
			if(pos==wind->wtptr || pos==wind->rdptr) {
				t[2] |= REVERSE;
				t[3] |= REVERSE;
			}
			strcat(s,t);
		}
		fmtplc(s,row+i);
		if(pos>=wind->where+QUEUESIZE)
			pos = wind->where;
	}
}

                                                                                                                                                                                                                                  