/* ntsnd.c */

#define	NTSNDMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vntsnd.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "datime.h"
#include "inicli.h"
#include "usrblk.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();		/* (txt) print text */
extern	int	dosess();		/* session loop */
extern	int	ntsndsess();		/* setup LPD session */
extern	VOID	lsterr();		/* error lister */
extern	int	rtresp();		/* keyboard response */
extern	VOID	ntsnd();		/* (code) process LPD commands */
extern	VOID	snddata();		/* send dfA data */
extern	int	getword();		/* (string,word) extract a word */
extern	VOID	strlwr();		/* (st) convert to lower case */
extern	int	chkusr();		/* check username / password */
extern	VOID	*new();			/* (n) allocate n bytes */
#endif

extern	char	*stptok();		/* (p,t,l,d) stop on token */
extern	char	*stpblk();		/* (ch) strip blanks */

/*
 * List of NTSND states
 */

#define	SNDDATA		(-1)

#define	WAITING		(0)
#define	NTSND		(1)
#define	SLOOP		(2)
#define	DONE		(3)

/*
 *	Global Variables For NTSND
 */

static int
	ntsndskt = -1,		/* socket for incoming RLPD */
	sndindx = 0,		/* file copy index */
	tcpport = 0,		/* Force TCP To Port */
	pswdreqd = 1,		/* password required */
	query = 0,		/* query for files */
	rcnt = 0,		/* number of characters to/from control */
	rfstate = WAITING,	/* state of the control channel */
	retstate = WAITING;	/* to emulate a subroutine call */

/*
 *	Global Buffers / Pointers
 */

#define BLOCKSIZE	(512)
#define BUFFERS		(128)
#define	GETWORD		(80)
#define	LISTSIZE	(6)

static char
	scratch[BUFFERS],		/* scratch string */
	defpath[BUFFERS],		/* default path */
	remhost[GETWORD],		/* remote host */
	username[USERPASSLEN+2],	/* current user name */
	password[USERPASSLEN+2];	/* password */

char	xs[BLOCKSIZE];			/* data buffer */
					/* dumby buffer for TSXUTL.C */

/*
 *	Various NTSND variables
 */

static	char
	sndfl[BUFFERS];		/* data file name */
static	FILE
	*sndfh = NULL;		/* data file handle */

static char *			/* Password File */
	pswdfl = "PAS:paswrd.fil";

static	char	list[LISTSIZE][GETWORD];

/*
 * Debugging options
 *
 *	bit 0	(0x01)	event printing
 *	bit 1	(0x02)	dosess() events
 *	bit 2	(0x04)	ntsnd()
 */

static char *ntsndtxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  NTSND [?] [-d level] [-inpq argument] file [file [...]]",
       "	?               List the Help Text and Exit NTSND",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() event printing",
       "		4 -	enable NTSND() printing",
#else
       "  NTSND [?] [-inpq argument] file [file [...]]",
       "	?               List the Help Text and Exit NTSND",
#endif
       "	i  IP Address	Remote Server Name / IP Address",
       "	n  Port Number	Remote Server Port Number",
       "	p  filespec	Password File",
       "	q		Query for File Name",
       "",
	0
       };

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	int ev,l;
	register int i,j,k;
	char c;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * Initialize some parameters
	 */
	remhost[0] = '\0';

	/*
	 * parse arguments
	 */
/*1*/	for(i=1,l=0; i<argc; i++) {
/*2*/		if(argv[i][0] == '?') {
		    printtxt(ntsndtxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
/*3*/		    while((c = argv[j][k]) != '\0') {
			switch(c) {
			/*
			 * Hidden option to bypass username/password
			 */
			case 'b':
				pswdreqd = 0;
				break;
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'i':	/* Remote Server IP Address */
				strcpy(remhost,argv[++i]);
				break;

			case 'n':	/* Remote Server Port Address */
				if (sscanf(argv[++i],"%d",&tcpport) <= 0)
					tcpport = 0;
				break;

			case 'p':	/* Password File */
				pswdfl = argv[++i];
				break;

			case 'q':	/* Query for Files */
				query = 1;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			default:
				break;
			}
			k++;
/*3*/		    }
/*2*/		} else
		if (l < LISTSIZE) {
			strcpy(list[l],argv[i]);
			strlwr(list[l]);
			l++;
		}
/*1*/	}

	if (remhost[0] == '\0') {
		if (question(remhost,sizeof(remhost),"NTSND To: ")) {
			if (!fndbrk)
				kb_puts("\r\nRemote Host Required\r\n");
			kb_puts("\r\nEscaping from NTSND\r\n");
			exit(1);
		}
	}

	while (!tcpport) {
		scratch[0] = '\0';
		if (question(scratch,sizeof(scratch),"NTSND Port: ")) {
			if (!fndbrk)
				kb_puts("\r\nRemote Port Required\r\n");
			kb_puts("\r\nEscaping from NTSND\r\n");
			exit(1);
		}
		if (sscanf(scratch,"%d",&tcpport) <= 0) {
			tcpport = 0;
			kb_puts("\r\nInvalid Port Entered\r\n");
		}
	}

	if (pswdreqd) {
		if (chkusr()) {
			if (!fndbrk)
				kb_puts("\r\nUsername/Password Required\r\n");
			kb_puts("\r\nEscaping from NTSND\r\n");
			exit(1);
		}
	}

	if (!query) {
		if (question(list[0],GETWORD,"File To Send: ")) {
			if (!fndbrk)
				kb_puts("\r\nFile Required\r\n");
			kb_puts("\r\nEscaping from NTSND\r\n");
			exit(1);
		}
	}

	/*
	 * Set Up Path
	 */
	gethome(defpath);
	cd(defpath);

	/*
	 * Initialize various things
	 */
	Snetinit();

	/*
	 *  Open a connection to the machine named.
	 *  Start up all of the configuration on the connection.
	 */
	ntsndskt = ntsndsess(remhost);

	if(ntsndskt<0) {
		kb_puts("\r\nNTSND Session Failed\r\n");
		kb_puts("\r\nEscaping from NTSND\r\n");
		exit(1);
	} else {
		while(!fndbrk && ev != -1) {
			ev = dosess();
			if(ev==0)
				suspnd(0);
		}

		skclose(ntsndskt);
		skrelease(ntsndskt,1);

		suspnd(0);
		errhandle();

		if(fndbrk) {
			kb_puts("\r\n^C\r\n");
		}

		cd("dk:");

		kb_puts("\r\nEscaping from NTSND\r\n");
		exit(0);
	}
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving message events
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("dosess(): cl = %d, ev = %d, dat = %u\r\n", cl,ev,dat);
}
#endif

	  switch(cl) {
	    case CONCLASS:
	      /*
	       * LPD Connection socket
	       */
	      ntsnd(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  kb_puts("\r\nNTSND session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    return(-1);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  ntsnd(0);
	}

	return(ev);
}

/*
 *  ntsndsess
 *  Start an NTSND session to the named machine
 */

int ntsndsess(str)
char *str;
{
	register struct socket *skt;
	register int port,sknum;

	/*
	 * Request a TCPIP socket
	 */
	sknum = socket(0);
	if(sknum<0)
		return(-1);
	
	/*
	 * Specify the connection type
	 */
	skt = (struct socket *) mapskt(sknum);
	skt->sktport = tcpport;

	/*
	 * Force the source port to be from
	 * a privileged port (721 - 731)
	 */
	port = skt->in.port;
	port = port % 11;
	port += 721;
	skt->skfport = port;

	/*
 	 * Request a connection
	 */
	connect(sknum,str);

	return(sknum);
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on an aborted input
 *	   else 0
 */
int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
		}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on an abort
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((keygets(st,ln,1)==-1) ? 1 : 0);
}

/*
 * keygets
 *
 * read a line from the keyboard
 * returns -1 if keyboard input aborted
 * or non-zero on success
 */

int keygets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';

	if(fndbrk) {
		kb_puts("^C\r\n");
		return(-1);
	}

	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(fndbrk) {
			*save = '\0';
			kb_puts("^C\r\n");
			return(-1);
		}
		suspnd(0);
	}
}

/*
 *	ntsnd
 */

VOID ntsnd(code)
int code;
{

#ifdef	DEBUGOPTION
if(debug&0x04) {
	if (rfstate) {
		printf("ntsnd(%d): rfstate = %d\r\n",
			code,rfstate);
	}
}
#endif

	switch(rfstate) {
	case WAITING:
		switch(code) {
		case CONOPEN:
			Stmrunset(ABORTCLASS,CLIENT,ntsndskt);
			rfstate = NTSND;
			break;

		case CONCLOSE:
			kb_puts("Connection Refused by Remote Server\r\n");
			rfstate = DONE;
			break;

		case CONFAIL:
			kb_puts("Failed to Connect to Remote Server\r\n");
			rfstate = DONE;
			break;

		default:
			break;
		}
		break;

	case NTSND:
		/*
		 * Log Session
		 */
		sprintf(scratch,
	/*Log*/
	"NTSND: %s", username
	/*Log*/
		);
		logsession(ntsndskt,scratch);

	case SLOOP:
		if (sndindx < LISTSIZE && list[sndindx][0] != '\0') {
			strcpy(sndfl,list[sndindx]);
			if (snddata(SLOOP)) {
				kbprintf("File %s not found\r\n",
					list[sndindx]);
				rfstate = SLOOP;
			}
			sndindx += 1;
		} else
		if (query) {
			sndfl[0] = '\0';
			if (question(sndfl,GETWORD,"File To Send: ")) {
				fndbrk = 0;
				rfstate = DONE;
				retstate = DONE;
			} else {
				if (snddata(SLOOP)) {
					kbprintf("File %s not found\r\n",
						sndfl);
					rfstate = SLOOP;
				}
			}
		} else {
			rfstate = DONE;
			retstate = DONE;
		}
		break;

	/*
	 *
	 * Command Processors Follow
	 *
	 */

	case SNDDATA:
		snddata(0);
		break;

	default:
	case DONE:
		rcnt = -1;
		break;
	}

	if(rcnt < 0) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("ntsnd(%d): rfstate = %d, rcnt = %d\r\n",
		code,rfstate,rcnt);
}
#endif
		rcnt = 0;

		if (sndfh)
			rtclose(sndfh);

		if(ntsndskt >= 0) {
			sksendwait(ntsndskt,(long) SENDWAIT);
			skclose(ntsndskt);
			ntsndskt = skrelease(ntsndskt,1);
		}

		fndbrk = 1;
	}
}

int
snddata(i)
int i;
{
	register int icnt;

	/*
	 * Initialize for sending data file
	 */
	if (i) {
		rfstate = SNDDATA;
		retstate = i;

		if ((sndfh = rtopen(sndfl,"rn",0,0)) == NULL) {
			return(1);
		} else {
			return(0);
		}
	}

	/*
	 * subroutine to send file data
	 */
	icnt = 0;
	while ((rcnt = skroom(ntsndskt)) > sizeof(xs)) {
		if (fread(xs,sizeof(xs),1,sndfh) != 0) {
			skwrite(ntsndskt,xs,sizeof(xs));
			icnt = 1;
		} else {
			rtclose(sndfh);
			sndfh = NULL;
			skwchar(ntsndskt,'\f');
			rfstate = retstate;
			break;
		}
	}

	if (icnt) {
		skenque(ntsndskt,1);
		suspnd(6);
		suspnd(-1);
	}

	return(0);
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */


int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len GETWORD
		 */
		q = stptok(p, word, GETWORD-1, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  chkusr
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password are validated and
 *  the user has the rquired privelege,
 *  then a valid return is made.
 *
 *  Returns valid(0)/invalid(1)
 */
int chkusr()
{
	FILE *fp;
	struct userblock user;
	char command[GETWORD];
	char word[GETWORD];

	username[0] = '\0';
	password[0] = '\0';
	/*
	 * username
	 */
	if(question(command,GETWORD,"Username: "))
		return(1);
	getword(command,word);
	strncat(username,word,USERPASSLEN);
	strlwr(username);
	/*
	 * password
	 */
	if (pswdreqd) {
		if(!(*stpblk(command))) {
			kb_puts("Password: ");
			if(keygets(command,GETWORD,0) == -1)
				return(1);
		}
		getword(command,word);
		strncat(password,word,USERPASSLEN);
		strlwr(password);
	}
	/*
	 * Check username / password file
	 */
	if(NULL==(fp = rtopen(pswdfl,"rn",0,0))) {
		return(1);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does username / password check ?
		 */
		if(!strncmp(username,&user.username,USERPASSLEN) &&
				(user.userflag[0]&PASSNOTREQUIRED ||
				!pswdreqd ||
				Scompass(password,&user.password))
			) {
			rtclose(fp);
			/*
			 * User valid
			 */
			return(0);
		}
	}
	kb_puts("Invalid Username / Password.\r\n");
	rtclose(fp);
	return(1);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
register char *ps,*en;
{
	register int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

                                                                    