/* kbdutl.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "kbdutl.h"
#include "termio.h"
#include "suspnd.h"


/*
 * kb_init() is an alias of tt_init()
 *
 *  Initialize keyboard I/O
 */

/*
 *  kb_inp() is an alias of tt_inp()
 *
 *  Get a single character if available
 *  else returns a NULL.
 */

/*
 *  kb_out() is an alias of tt_out()
 *
 *  Output a single character
 */

/*
 *  kb_puts is an alias of tt_puts()
 *
 *  print string to terminal
 */

/*
 *  kbprintf() is an alias of ttprintf()
 *
 *  print string to terminal using sprintf to parse arguments
 */

/*
 *  kb_nline() is an alias of tt_nline()
 *
 *  output "\r\n"
 */

/*
 *  kb_glin()
 *
 *  This routine gets a line from the console.
 */

int kb_glin(s,lim,echo)
char *s;
int lim;
char echo;
{
	register char c;

	*s = '\0';
	while (0 >= (c = kb_gets(s,lim,echo))) {
		suspnd(0);
	}
	return(c);
}

/*
 *  non-blocking kb_gets()
 *
 *  This routine will continually add to a string that is re-submitted
 *  until a special character is hit.  It never blocks.
 *
 *  As long as editing characters (bksp, Ctrl-U) and printable characters
 *  are pressed, this routine will update the string.  When any other special
 *  character is hit, that character is returned.
 */

int kb_gets(s,lim,echo)
register char *s;
int lim;
char echo;
{
	register int c,count;
	int i;
	char *save;

	save = s;
	count = strlen(s);
	s += count;
	lim -= 1;
	while(0<(c = kb_char())) {
		/* allow certain editing chars */
		switch (c) {
		case 8:		/* backspace */
		case 127:	/* delete */
			if(count) {
				if (echo) {
					tt_out(8);
					tt_out(' ');
					tt_out(8);
				}
				/* one less character */
				count--;
				/* move pointer backward */
				s--;
			}
			break;

		case 21:	/* ^U */
			if (echo)
				for(i=0; i<s-save; i++) {
					tt_out(8);
					tt_out(' ');
					tt_out(8);
				}
			s = save;
			break;

		case 13:	/* CR */
		case 9:		/* HT */
			/* terminate the string */
			*s = '\0';
			return(c);

		default:
			/* to length limit */
			if(count==lim) {
				tt_out(7);
				/* terminate */
				*s = '\0';
				return(0);
			}
			if(c>31 && c<127) {
				if (echo)
					tt_out(c);
				/* add to string */
				*s++ = (char)c;
				/* length of string */
				count++;
			} else {
				/* terminate the string */
				*s = '\0';
				return(c);
			}
			break;
		}
	}
	/* terminate the string */
	*s = '\0';
	return(c);
}

/*
 *  kb_gchar
 *
 *  check the keyboard for a character,
 *  don't return to the caller until it is there.
 */
int kb_gchar()
{
	register int c;

	while(0>=(c = kb_char())) {
		suspnd(0);
	}
	return(c);
}

/*
 *  kb_char
 *
 *  The kb_meta is the leadin control character.
 *  Two meta characters in succesion yeild a single meta character.
 *  The meta character followed by a character yields
 *  the code value of 128 + character value.
 *
 *  The default meta character is ^A ('\001').
 */

int kb_meta = '\001';

static
int meta_c;

int kb_char()
{
	register int c;

	if ((c = tt_inp())==0) {
		return(-1);
	} else {
		if(meta_c) {
			if(c!=kb_meta) {
				c = 128 + toupper(c);
			}
			meta_c = 0;
		} else {
			if(c==kb_meta) {
				c = -1;
				meta_c = 1;
			}
		}
		return(c);
	}
}
                                                                                                                                                                                     