.comment;sysgen.ss

.chapter;System Generation

The FTP and Telnet Package for Small Systems is for RT-11
versions 5.3 and later and TSX-PLus.  This package does not
require a mapped monitor.  Device handlers
supporting the DEQNA/DELQA (EQ and NQ),  DEUNA/DELUA (EU and NU), and
DECNA (NC) are provided for the various devices and processor
configurations.

The selection of the appropriate device handler is dependent upon
the RT11/TSX-Plus version and processor configuration.  A custom device
handler may be built using the supplied conditional files.
Options for building the EQ and EU device handlers include
the number of internal packet buffers, device timeout,
interrupt processing at FORK level, mfps/mtps or PSW processor types,
and optional spfun selection.

For small systems (i.e. 56K bytes)
the EQSB____ and EUSB____ handlers have been built for only 2 internal
packet buffers, no EIS instructions, and only support for spfun 206.
The EQSJ____ and EUSJ____ handlers add support for spfun 211.

For mapped RT-11 systems (96K bytes or larger) and TSX-Plus
systems select the appropriate mapped handler for your system.

.page
.lit
Summary of prebuilt EQ/EU/NC/NQ/NU
device drivers and supported systems:
.end lit
.sk 2
.lit
RT-11 VERSION	[5.3]	[5.4]	[5.5]	   [5.6 ...]	TSX
	        -----	-----	-----	   ---------	---
eqsjms.sys	SJ/FB	SJ/FB	SJ/FB	       -	 -
eusjms.sys	SJ/FB	SJ/FB	SJ/FB	       -	 -

eqsjps.sys	SJ/FB	SJ/FB	SJ/FB	       -	 -
eusjps.sys	SJ/FB	SJ/FB	SJ/FB	       -	 -

eqsbms.sys	  -	  -	  -	     SB/FB	 -
eusbms.sys	  -	  -	  -	     SB/FB	 -

eqsbps.sys	  -	  -	  -	     SB/FB	 -
eusbps.sys	  -	  -	  -	     SB/FB	 -

eq18xm.sys	  XM	  XM	  XM	  XB/XM/ZB/ZM	 -
eq22xm.sys	  XM	  XM	  XM	  XB/XM/ZB/ZM	 -

eu18xm.sys	  XM	  XM	  XM	  XB/XM/ZB/ZM	 -

ncxv56.sys	  -	  ?	  ?	  XB/XM/ZB/ZM	 -
nqxv56.sys	  -	  ?	  ?	  XB/XM/ZB/ZM	 -
nuxv56.sys	  -	  ?	  ?	  XB/XM/ZB/ZM	 -

eq18.v62	  -	  -	  -	       -	<= V6.2
eq22.v62	  -	  -	  -	       -	<= V6.2

eu18.v62	  -	  -	  -	       -	<= V6.2
eu22.v62	  -	  -	  -	       -	<= V6.2

eq18.tsx	  -	  -	  -	       -	>= V6.4
eq22.tsx	  -	  -	  -	       -	>= V6.4

eu18.tsx	  -	  -	  -	       -	>= V6.4
eu22.tsx	  -	  -	  -	       -	>= V6.4


____ms.sys	Drivers are for LSI/11 processors not having
		a processor status word (PSW == @#177776).

____ps.sys	Drivers are for all processors with a
		processor status word (PSW == @#177776).

__sj__.sys	Drivers contain special function 211 (abort
		job i/o) for RT11SJ monitors.
.end lit

.page
.lit
Summary of prebuilt EQ/EU/NC/NQ/NU
device driver features:
.end lit
.sk 2
.lit
		   SPFUNS				DEVICE
	     206  207  210  211    EIS  PSW  UMR  FORK  TIMEOUT
	     ---  ---  ---  ---    ---  ---  ---  ----  -------
eqsjms.sys    X    -    -    X      -    -    -     X      X
eusjms.sys    X    -    -    X      -    -    -     X      X

eqsjps.sys    X    -    -    X      -    X    -     X      X
eusjps.sys    X    -    -    X      -    X    -     X      X

eqsbms.sys    X    -    -    -      -    -    -     X      X 
eusbms.sys    X    -    -    -      -    -    -     X      X

eqsbps.sys    X	   -    -    -      -    X    -     X      X
eusbps.sys    X    -    -    -      -    X    -     X      X

eq18xm.sys    X    X    X    -      X    X    -     X      X
eq22xm.sys    X    X    X    -      X    X    -     X      X

eu18xm.sys    X    X    X    -      X    X    -     X      X

ncxv56.sys    X    X    X    -      X    X    -     -      -
nqxv56.sys    X    X    X    -      X    X    -     -      -
nuxv56.sys    X    X    X    -      X    X    X     -      -

eq18.v62      X    X    X    -      X    X    -     X      X
eq22.v62      X    X    X    -      X    X    -     X      X

eu18.v62      X    X    X    -      X    X    -     X      X
eu22.v62      X    X    X    -      X    X    X     X      X

eq18.tsx      X    X    X    -      X    X    -     X      X
eq22.tsx      X    X    X    -      X    X    -     X      X

eu18.tsx      X    X    X    -      X    X    -     X      X
eu22.tsx      X    X    X    -      X    X    X     X      X


____ms.sys	Drivers are for LSI/11 processors not having
		a processor status word (PSW == @#177776).

____ps.sys	Drivers are for all processors with a
		processor status word (PSW == @#177776).

__sj__.sys	Drivers contain special function 211 (abort
		job i/o) for RT11SJ monitors.
.end lit
                                                                                                         