{$nomain}

{ this is the file 'DSPFIL.PAS' which is intended to display files for
  examination }

const
  %include 'dircon.pas';

type
  %include 'dirtyp.pas';


{                                                            }
{                     function confirm                       }
{                                                            }

function confirm(default: char): boolean;

{ to prompt for a Y/N response and give the default value if <CR> only
  is given }

external;




{                                                            }
{                    procedure dspfil                        }
{                                                            }

procedure dspfil(var xfile: text;
                 var fname: packed array
                   [lower..upper: integer] of char);

external;

procedure dspfil;

  const
    bit8 = 8#200;

    pagelength = 20;    { lines }

    pagewidth = 80;     { chars }


  var

    byte: char;

    haltloop: boolean;

    namestring: packed array [1..fnamelen] of char;

    iptr: integer;

    nptr: integer;

    errstat: integer;

    linecount: integer;

    charcount: integer;


  begin
  iptr := lower;
  nptr := 1;
  haltloop := false;
  repeat
    namestring[nptr] := fname[iptr];
    nptr := nptr + 1;
    iptr := iptr + 1;
    if (nptr > fnamelen) or (iptr > upper) then
      haltloop := true;
  until haltloop;
  for iptr := nptr to fnamelen do
    namestring[iptr] := ' ';
  reset(xfile,namestring,,errstat);
  if errstat < 0 then
    begin
    writeln;
    write('?REVISE-E-Unable to open file ');
    for iptr := lower to upper do
      if fname[iptr] <> ' ' then
        write(fname[iptr]);
    end
  else
    begin
    haltloop := false;
    linecount := 0;
    charcount := 0;
    repeat
      if eof(xfile) then
        haltloop := true
      else
        if eoln(xfile) or (charcount >= pagewidth) then
          begin
          writeln;
          if eoln(xfile) then
            readln(xfile);
          linecount := linecount + 1;
          charcount := 0;
          if linecount >= pagelength then
            begin
            writeln;
            write('More');
            if confirm('Y') then
              begin
              linecount := 0;
              charcount := 0;
              writeln;
              end
            else
              haltloop := true;
            end;
          end
        else
          begin
          byte := chr(ord(xfile^) and (not bit8));
          if byte in [chr(9),' '..'~'] then
            write(byte)
          else
            write('?');
          get(xfile);
          charcount := charcount + 1;
          end;
    until haltloop;
    close(xfile);
    writeln;
    end;
  end;                        { of procedure dspfil }


                                                                                                                                                                      