	SUBROUTINE GRAPHM(IBUF,MODE,X,Y,NPTS,SHADE,IGR,FACTOR)
C
C
C	J. LISCOUSKI  DIGITAL EQUIPMENT CORPORATION
C	NOV. 9, 1979
C
C	THIS SUBROUTINE WILL PERMIT GRAPHS TO BE DRAWS GIVEN
C	A FEW ARGUMENTS.
C
C	IBUF	IS THE INFORMATION BUFFER DIMENSIONED BY THE
C		USER FOR 30 WORDS.
C
C	MODE	MODE IS USED TO ENABLE OR DISABLE CERTAIN DISPLAY
C		FEATURE OF THE SYSTEM.  SOME COMBINATIONS OF MODES
C		CAN BE EFFECTED BY SUMMING THE VALUES FOR THE VARIOUS
C		TYPES:
C		OPTION		VALUE (IF ENABLED)
C		-----		-----------------
C		FRAME			1
C		HOR. LINES		2
C		SHADING			4
C		INDEX			8 (not implemented as yet)
C		MOVE		       16
C		AUTOSCALING            32
C		UNITS		       64
C		MARKERS		      128
C
C	SOME COMBINATIONS INTERACT:
C
C	A) HORIZONTAL LINES CAN BE USED IFF FRAME IS CHOSEN
C	B) INDEX AND MOVE ARE MUTUALLY EXCLUSIVE
C
C	THE DEFAULT IS 35 (FRAME, HORIZONTAL LINES, UNITS,
C	MARKERS, AND AUTOSCALING)
C
C	X	IS THE ARRAY FOR THE HORIZONTAL AXIS, IT MAY BE DEFAULTED.
C		IF THE DEFAULT IS CHOSEN, A COUNTER FROM 1 TO NPTS WILL BE
C		USED IN ITS PLACE.
C
C	Y	IS THE ARRAY FOR THE VERTICAL AXIS AND IS MANDITORY.
C
C	NPTS	IS THE NUMBER OF POINTS TO BE PLOTTED.
C
C	SHADE	IS THE POINT ON THE VERTICAL AXIS (EXPRESSED IN USER VALUES)
C		AT WHICH SHADING IS TO BE DONE.  THE DEFAULT IS THE BOTTOM
C		OF THE GRAPH.
C
C	IGR	IS THE GRAPH NUMBER (0/1) FOR PLOTTING, THE DEFAULT IS 0.
C
C	FACTOR  IS A MULTIPLIER USED T PROVIDE AOME SCALING FOR THE
C		HORIZONTAL AXIS WHILE IN STRIPCHART MODE.  THE CALCULATION
C		IS (number of points)*(factor)
C
C	NOTE: ALL ARGUMENTS ARE NEEDED, EITHER BY DEFAULT OR BY USER
C	      DEFINITION.  IF ANY ARE MISSING, A TRAP TO 4 MAY RESULT.
C
	DIMENSION X(1),Y(1),IBUF(1),TEMP(4),ITEMP(8),IRB(2,3),IB(2)
	BYTE CMD(11),ENTRGR(3),EXITGR(3),IGCODE(2)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),XMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),XMAX)	!FROM IBUF INTO THE APPROPRIATE
	EQUIVALENCE (TEMP(3),YMIN)	!REAL VARIABLES
	EQUIVALENCE (TEMP(4),YMAX)
	DATA IRB/239,150,129,50,239,50/ !REGION BOUNDS
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	DATA IGCODE/'B','J'/
	DATA IB/10,18/
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. SUBROUTINE
C
C	BEGINNING OF EXECUTABLE CODE
C
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRAPHM - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).NE."52525)CALL GRINIT(IBUF) !GRINIT CALLED?
	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 3	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRAPHM - graph not assigned to region')
	CALL EXIT
	RETURN
3	CALL IDFLT(IMODE,227,MODE)	!CHECK DEFAULT ON MODE
	CALL GRCLN(IBUF,IGRAPH)		!CLEAN PLOTTING AREA
C
C	NOW, IS AUTO SCALING NECESSARY?
C
	IF((IMODE.AND.32).EQ.0)GOTO 10
C
C	PERFORM AUTOSCALING
C
	IFLAG=0	!FLAG TO SHOW IF X HAS BEEN DEFAULTED (1=YES)
	IF(IADDR(X).EQ."177777)GOTO 4	!HAS X BEEN DEFAULTED?
	CALL BOUNDS(1,X,XMAX,XMIN,NPTS)	!GET LIMITS
	GOTO 5
4	IFLAG=1	!SHOW X DEFAULTED
	XMIN=1
	XMAX=NPTS
5	IF(IADDR(Y).NE."177777)GOTO 6 	!HAS Y BEEN DEFAULTED?
	CALL ERRMSG('?GRAPHM - Y array cannot be defaulted')
	CALL EXIT
	RETURN
6	CALL BOUNDS(1,Y,YMAX,YMIN,NPTS)	!GET Y LIMITS
	IBASE=IB(IGRAPH+1)
	DO 7 I=1,8
7	IBUF(IBASE+I)=ITEMP(I)	!STORE LIMITS IN IBUF
	IBUF(2+IGRAPH)=1	!SHOW THAT SCALING FACTORS EXIST
	GOTO 20
10	IF(IBUF(2+IGRAPH).NE.0)GOTO 12	!HAVE SCALED VALUES BEEN ENTERED?
	CALL ERRMSG('?GRAPHM - scaling has not been provided for graph')
	CALL EXIT
	RETURN
12	IBASE=IB(IGRAPH+1)
	DO 15 I=1,8
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
C	(20) NOW SEE IF FRAME IS REQUIRED
C
20	IF((IMODE.AND.1).EQ.0)GOTO 30
	CALL GRFRAM(IBUF,IGRAPH,IMODE)
C
C	(30) CHECK FOR SHADE MODE
C
30	NCHAR=3 !SET CHARACTER COUNT TO 3
	IF((IMODE.AND.4).EQ.0)GOTO 40	!IF NOT, KEEP GOING
	CALL DFLTCK(SHADEL,YMIN,SHADE)	!CKECK FOR DEFAULT ON SHADE LINE
	I=2
	IF(IGRAPH.EQ.1)I=4	!SHADE APPROPRIATE GRAPH
	IBUF(5)=((IBUF(5).OR.I).OR.IGRAPH) !SET BITS FOR SHADING
	NCHAR=6 !RESET CHAR. COUNT TO 6 DUE TO SHADING
	CMD(4)='@'	!LOAD SHADE LINE
	Y1=F(SHADEL,YMAX,YMIN)*FLOAT(IRB(1,IRGN)-IRB(2,IRGN))
	IY=Y1+IRB(2,IRGN)
C
C	CHECK FOR SHADE LINE OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN) !TOO HIGH? SHADE FROM TOP
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN) !TOO LOW? SHADE FROM BOTTOM
C
	CMD(5)=32+(IY.AND."37)
	CMD(6)=32+((IY.AND."340)/32)
C
C	(40)	NOW LOAD GRAPHICS
C
40	IF((IBUF(4).AND.1).NE.0)GOTO 45	!DISPLAY GRAPHICS ENABLED?
	IBUF(4)=IBUF(4).OR.1
45	I=2	!ENABLE GRAPHICS FOR APPROPRIATE GRAPH
	IF(IGRAPH.EQ.1)I=4
	IBUF(4)=IBUF(4).OR.I	!SET BITS
C
C	SET BIT IF STRIP CHART MODE IS REQUIRED
C
	IF((IMODE.AND.16).NE.0)IBUF(5)=IBUF(5).OR."10 !3RD CHAR., REG. 0
	CMD(1)='A'
	CMD(2)=IBUF(4)
	CMD(3)=IBUF(5)
	CALL OUTSTR(ENTRGR)
	CALL OUTSTR(CMD,NCHAR)
C
C NOW (FINALLY) PUT UP THE GRAPH
C
	IF((IMODE.AND.16).NE.0)GOTO 200	!TEST FOR STRIP CHARTING
	RANGE=IRB(1,IRGN)-IRB(2,IRGN) !# OF DOTS ON Y-AXIS
	DO 100 I=1,NPTS
	X1=I
	IF(IFLAG.EQ.0)X1=X(I)	!USE ACTUAL X VALUES IF NO DEFAULT
	Y1=Y(I)
	IX=INT(F(X1,XMAX,XMIN)*511.)
C
C	CHECK FOR X OUT OF RANGE
C
	IF(IX.LT.0)IX=0
	IF(IX.GT.511)IX=511
C
	CMD(1)='H'
	CMD(2)=32+("37 .AND. IX)
	CMD(3)=32+(("740 .AND. IX)/32)
	IY=INT(F(Y1,YMAX,YMIN)*RANGE)
	IF(((IX/128)*128) .EQ. IX)IY=0 !LEAVE TICK MARKS ALONE
	IY=IY+IRB(2,IRGN)	!ADD OFFSET FOR BOTTOM OF GRAPH
C
C	CHECK FOR Y OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(4)=IGCODE(IGRAPH+1)
	CMD(5)=32+("37 .AND. IY)
	CMD(6)=32+(("340 .AND. IY)/32)
	CALL OUTSTR(CMD,6)
100	CONTINUE
	GOTO 500
C
C	THE FOLLOWING SECTION OF CODE IS FOR STRIP CHART MODE
C
200	CALL OUTSTR('H  ')	!START AT X=0
	IROW=20
	IF(IRGN.EQ.1)IROW=10 !SELECT ROW FOR LABLING
	ICNT=-1	!INITIALIZE COUNTER
	CALL DFLTCK(FACTR,1.,FACTOR)    !DEFAULT ON FACTOR IS 1
	IF((IMODE.AND.64).NE.0)CALL GRLM(ICNT,IROW,FACTR) !LABLE X-AXIS
	RANGE=IRB(1,IRGN)-IRB(2,IRGN)
	CMD(1)=IGCODE(IGRAPH+1) !DESIGNATE X VALUE
	DO 300 I=1,NPTS
	L=I !NEEDED TO AVOID A WARNING MESSAGE CONCERNING MODIF. TO I
	Y1=Y(I)
	IY=INT(F(Y1,YMAX,YMIN)*RANGE)
	IF(MOD(L,128) .NE. 1)GOTO 260 !NEED TO SKIP A POINT?
	IY=0	!RESET TO BASELINE
	IF((IMODE.AND.64).EQ.0)GOTO 260 !UNITS SELECTED?
	CALL GRLM(ICNT,IROW,FACTR)
260	IY=IY+IRB(2,IRGN)
C
C	CHECK FOR Y OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(2)=32+("37.AND.IY)
	CMD(3)=32+(("340.AND.IY)/32)
	CALL OUTSTR(CMD,3)
300	CONTINUE
500	CALL OUTSTR(EXITGR)	!EXIT GRAPHICS MODE
C
C	TURN OFF STRIP CHART MODE FOR GRAPH AND THE GRAPHICS
C	DISPLAY ENABLE.  
C
	IBUF(4)=IBUF(4).AND."177776 !DISABLE DISPLAY
	IBUF(5)=IBUF(5).AND."177767 !TURN OFF STRIP CHART
	RETURN
	END
	SUBROUTINE GRLM(ICNT,IROW,FACTOR)
C
C	GRLM IS A SUBROUTINE USED TO LABLE THE HORIZONTAL AXIS DURING
C	STRIP CHART MODE.
C
C	THE ARGUMENTS ARE AS FOLLOWS:
C
C	ICNT	A COUNTER, INCREMENTED AT EACH CALL.  SHOULD BE SET TO
C		-1 BY THE MAIN PROGRAM BEFORE THE FIRST CALL
C
C	IROW	THE ROW USED FOR LABLING
C
C	FACTOR	THE SCALING FACTOR NOTED IN GRAPH (FILE GRAPHM)
C
	DIMENSION ICOL(4)
	BYTE CMD(12),ENTRGR(3),EXITGR(3)
	DATA ICOL/9,25,41,57/ !LABLING POSITIONS
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
C
	ICNT=ICNT+1
	IADJ=4
	IF(ICNT.NE.0)GOTO 5
	IADJ=0
	GOTO 10
5	IF (ICNT.LT.5)RETURN
10	CALL OUTSTR(EXITGR) !LEAVE GRAPHICS MODE FOR LABLING
	DO 30 J=1,4
	F=FLOAT(((ICNT-IADJ)*128)+((J-1)*128))*FACTOR
	ENCODE(10,20,CMD)F
20	FORMAT(1PE10.3)
	CMD(11)=0
	CALL VTHTXT(0,IROW,ICOL(J),CMD)
30	CONTINUE
	CALL OUTSTR(ENTRGR) !RETURN TO GRAPHICS MODE
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                          