C	PROGRAM FOR TESTING AUTOCORRELATION AND AUTOCORRELATION
C	MATRIX SOLUTION FAST PROGRAMS
C	LINKING PROCEDURE:
C	XSOLVE=XSOLVE/F,SOLVE,SYSLIB,AUTO
C
	DIMENSION COEFF(20,5,3),ALPHA(20,5),F(20,5),C(20,13)
	DIMENSION GAIN(20),XMULT(17),LRSS(17),AA(20)
	DIMENSION XPCH(128),IR(40),XR(20),YR(20),A(20)
	DIMENSION CT(20,13),PRED(20,12),RC(20)
	DIMENSION XP(20),NXPCH(128),IP(20)
	INTEGER*4 IIR(20)
	EQUIVALENCE (IR(1),IIR(1))
	COMMON /YY/NXPCH
	DATA F(1,1),F(1,2),F(1,3)/270.,2290.,3010./
	DATA F(2,1),F(2,2),F(2,3)/390.,1990.,2550./
	DATA F(3,1),F(3,2),F(3,3)/530.,1840.,2480./
	NTOT=3
	TT=1./8000.
	DO 1 NPHON=1,NTOT
	GAIN(NPHON)=1.
	ALPHA(NPHON,1)=30.
	ALPHA(NPHON,2)=50.
	ALPHA(NPHON,3)=60.
	ALPHA(NPHON,4)=87.5
1	F(NPHON,4)=3500.
	PI=3.1415926
C
C	CREATE 10'TH ORDER PREDICTION COEFFS VIA POLYNOMIAL
C	MULTIPLICATION (4 FORMANTS, SOURCE/SINK)
	DO 2 NPHON=1,NTOT
	DO 2 NFORM=1,4
	COEFF(NPHON,NFORM,1)=1.0
	X=-2.*EXP(-2.*PI*ALPHA(NPHON,NFORM)*TT)
	COEFF(NPHON,NFORM,2)=X*COS(2.*PI*F(NPHON,NFORM)*TT)
2	COEFF(NPHON,NFORM,3)=EXP(-4.*PI*ALPHA(NPHON,NFORM)*TT)
	DO 3 NPHON=1,NTOT
	DO 4 J=1,11
	C(NPHON,J)=0.0
4	CT(NPHON,J)=0.0
	CT(NPHON,1)=1.
	CT(NPHON,2)=-EXP(-400.*PI*TT)+EXP(-5000.*PI*TT)
	CT(NPHON,3)=-EXP(-400.*PI*TT)*EXP(-5000.*PI*TT)
	NPOWER=2
	NPOW1=NPOWER+1
	DO 5 NFORM=1,4
	DO 6 K=1,NPOW1
	DO 7 NCOEF=1,3
	NDEG=NCOEF+K-2
	NSLOT=NDEG+1
	X=C(NPHON,NSLOT)
7	C(NPHON,NSLOT)=X+COEFF(NPHON,NFORM,NCOEF)*CT(NPHON,K)
6	CONTINUE
	NPOWER=NPOWER+2
	NPOW1=NPOWER+1
	DO 8 J=1,NPOW1
	CT(NPHON,J)=C(NPHON,J)
8	C(NPHON,J)=0.0
5	CONTINUE
3	CONTINUE
C
C
	DO 9 J=1,NTOT
	DO 10 K=1,10
 	PRED(J,K)=-CT(J,K+1)
C	WRITE OUT PREDICTION COEFFS VIA POLYNOMIAL MULT
10	WRITE(7,30) PRED(J,K)
C
C	SYNTHESIZE SPEECH
	XPCH(1)=1.
	NPITCH=128
	DO 11 N=2,NPITCH
	MIN=10
	IF(N.LE.10) MIN=N-1
	XPCH(N)=0.0
	DO 12 K=1,MIN
	NX=N-K
12	XPCH(N)=XPCH(N)+PRED(J,K)*XPCH(NX)
11	CONTINUE
C
	SIGMAX=0.0
	DO 13 K=1,NPITCH
13	IF(ABS(XPCH(K)).GT.SIGMAX) SIGMAX=ABS(XPCH(K))
C
C	ASSUME 14 BIT 2'S COMP SAMPLES
	DO 14 K=1,NPITCH
14	NXPCH(K)=XPCH(K)*(2.**13-1.)/SIGMAX+.5
C
C	COMPUTE 32 BIT AUTOCORRELATION 128 POINTS X 10 LAGS
	CALL AUTO(IR(1))
C	CONVERT FROM 32 BIT INTEGER TO FLOATING POINT
	DO 15 K=1,11
15	XR(K)=AJFLT(IIR(K))
C
C	GET FLOATING POINT AUTO CORRELATION
	MP1=11
	DO 16 K=1,MP1
	YR(K)=0.0
	NK=NPITCH-K+1
	DO 17 NP=1,NK
17	YR(K)=YR(K)+XPCH(NP)*XPCH(NP+K-1)
16	CONTINUE
C
C	SOLVE AUTOCORRELATION EQUATIONS
C	A) USE MACRO 'SOLVE'
	CALL SOLVE(A(1),XR(1),9,XP(1))
C	B) USE PROGRAM FROM MARKEL
	CALL SOLVB(AA,XR,10,IP)
C
C	WRITE OUT IN EACH ROW
C	A)NORMALIZED AUTOCORRELATION VIA 32 BIT MACRO PROGR
C	B)NORMALIZED AUTOCORRELATION VIA 24 BIT FRACTION FLT PT
C	C)A'S,REFLECTION COEFFS VIA MACRO PROG (MORRIS)
C	D)A'S,REFLECTION COEFFS VIA FORTAN PROG (MARKEL)
	XX=XR(1)
	YY=YR(1)
	DO 18 K=1,10
	XR(K)=XR(K)/XX
	YR(K)=YR(K)/YY
	WRITE(7,30) XR(K),YR(K),A(K),XP(K),AA(K),IP(K)
18	CONTINUE
30	FORMAT(1X,2(F10.7,2X),F10.6,2X,F10.1,2X,F10.6,2X,I7)
9	CONTINUE
	STOP
	END
C	NOTES:AUTOCORRELATION COEFFS VIA MACRO USE 32 BIT
C	ACCUMULATIONS AND ARE THEREFORE MORE ACCURATE THAN
C	FLOATING POINT WHICH ONLY USES 24 BIT FRACTIONS.
C	COEFFICIENTS OBTAINED VIA ANALYSIS OF SYNTHESIZED SPEECH
C	WILL NOT EXACTLY EQUAL COEFFICIENTS OF SYNTHESIZER
C	SINCE OUTPUT OF SYNTHESIZER WAS CONVERTED TO 14 BIT FIXED POINT
C
	SUBROUTINE SOLVB(A,R,M,IP)
	DIMENSION R(20),A(20),IP(20)
	A(1)=-R(2)/R(1)
	IP(1)=A(1)*(2.**15-1.)
	AL=R(1)+A(1)*R(2)
	BE=R(3)+A(1)*R(2)
	MM1=M-1
	DO 10 I=1,MM1
	IP1=I+1
	CC=-BE/AL
	IP(IP1)=CC*(2.**15-1.)
	I2=IP1/2
	DO 20 J=1,I2
	IJ=IP1-J
	TA=A(J)+CC*A(IJ)
	A(IJ)=A(IJ)+CC*A(J)
20	A(J)=TA
	A(IP1)=CC
	AL=AL+CC*BE
	BE=R(I+3)
	DO 10 J=1,IP1
	NJ=I-J+3
10	BE=BE+A(J)*R(NJ)
	RETURN
	END
                                                                                                                                                                                                                                                                                                            