;
;FFTR45.RSX  MAY 1974
;WRITTEN BY BOB DAY
;COMPUTER SPECIAL SYSTEMS
;DIGITAL EQUIPMENT CORPORATION
;


;GLOBALS

.GLOBL FFTR



;IDENTIFIERS

F.R:	0		;(LOG N)-2
ARRAY:	0		;DATA ARRAY
F.N:	0		;NUMBER OF DATA POINTS
F.SCLF:	0		;SCALE FACTOR
F.INV:	0		;FORWARD/INVERSE FLAG
F.SPCT:	0		;POWER SPECTRUM OPTION FLAG
F.LL:	0		;NO. OF SUBGROUPS WITHIN A COLUMN
F.M:	0		;USED TO LOCATE ORIGIN OF A SUBGROUP
F.L:	0		;INDEX FOR MAIN LOOP
F.A1:	0		;OFFSET OF 1ST HALF OF A SUBGROUP
F.A2:	0		;OFFSET OF 2ND HALF OF A SUBGROUP
F.K:	0		;INDEX FOR NO. OF SUBGPS W/IN A COL.
F.SR:	0		;TEMP STORAGE FOR CURRENT POINTS
F.ORG:	0		;ORIGIN OF NEXT SUBGROUP
F.H:	0		;POWER OF W
F.HH:	0		;TRIG TABLE INCREMENT
F.TRT:	0		;TEMP STORAGE
F.COS:	0		;CURRENT COSINE
F.SIN:	0		;CURRENT SINE
F.MM:	0		;TEMP STORAGE
F.GRPN:	0		;NO. OF POINTS IN CURRENT GROUP
F.SCT:	0		;COUNTER FOR POINTS IN CURRENT GROUP
R.HH:	0
R.CTR:	0
R.B:	0
R.D:	0
XR0:	0		;TEMP.
XR1:	0		;TEMP.
X.BIT:	0		;POINTER FOR BIT REVERSAL
F.TCNT:	1		;TIMING COUNTER


	R0=%0
	R1=%1
	R2=%2
	R3=%3
	R4=%4
	R5=%5
	SP=%6
	PC=%7
	PS=	177776



;
;SUBROUTINE FOR COMPUTING FAST FOURIER
;TRANSFORM OF STRICTLY REAL DATA POINTS.
;THE NUMBER OF DATA POINTS MUST BE A
;POWER OF TWO NOT LESS THAN 16. OR
;GREATER THAN 2048.
;
;CALLING SEQUENCE
;	JSR R5,FFTR
;	BR  [AROUND PARAMATERS]
;	A[DATA ARRAY ADDRESS]
;	A[NUMBER OF DATA POINTS]
;	A[SCALE FACTOR, F.SCLF, RETURNED HERE]
;	A[0 FOR FORWARD; 1 FOR INVERSE]
;	A[0 FOR POWER SPECTRUM; 1 FOR NOT]*
;	A[ERROR WORD]
;	*THIS FLAG IS IGNORED IF INVERSE HAS BEEN REQUESTED
;
;ON ERROR, SUBROUTINE SETS C AND RETURNS
;
FFTR:	MOV	R0,-(SP)	;SAVE REGISTERS
	MOV	R1,-(SP)	;	"
	MOV	R2,-(SP)	;	"
	MOV	R3,-(SP)	;	"
	MOV	R4,-(SP)	;	"
	MOV	R5,-(SP)	;	"
	MOVB	@R5,R1		;CHECK NO. OF PARAMS
	CMP	#3,R1		;AT LEAST 3?
	BGT	R.EREX		;NO, BEAT IT
	CMP	#6,R1		;MORE THAN 6?
	BLT	R.EREX		;YES, SCRAM
	BGT	R.IN4		;HOP OVER IF NO ERROR WORD
	MOV	#1,@12.(R5)	;INIT ERROR WORD TO 1
R.IN4:	MOV	#5,R0		;INIT INTERNAL PARAMS
	MOV	#F.N,R2		;	"
R.IN5:	CLR	(R2)+		;	"
	DEC	R0		;	"
	BGT	R.IN5		;	"
	MOV	#4,R.IN6+2	;INSERT USER'S PARAMS
	DEC	R1		;	"
	MOV	#ARRAY,R2	;	"
	MOV	2(R5),(R2)+	;	"
R.IN6:	MOV	@4(R5),(R2)+	;	"
	ADD	#2,R.IN6+2	;	"
	DEC	R1		;	"
	BGT	R.IN6		;	"
	ASR	F.N		;N = COMPLEX TYPE N
	BCS	R.EREX		;ERROR IF LOW ORDER BIT SET
	TST	F.N		;N LEQ ZERO?
	BLE	R.EREX		;YES, ERROR
	CMP	#1024.,F.N	;N GTR 1024.?
	BLT	R.EREX		;YES,ERROR
	MOV	F.N,F.M		;TEMP STORE
	CLR	F.R		;
R.IN1:	ROR	F.M
	BCS	R.IN2
	INC	F.R
	BR	R.IN1
R.IN2:	BNE	R.EREX		;NOT PWR OF TWO, ERROR
	SUB	#2,F.R		;R IS PWR OF TWO MINUS 2
	BLE	R.EREX		;N LESS THAN 16.,ERROR
	CLR	R1		;CALCULATE INC FOR TRIG TABLE
	MOV	#1024.,R0	;	"
R.IN3:	ASR	R0		;	"
	INC	R1		;	"
	CMP	F.R,R1		;	"
	BGT	R.IN3		;	"
	MOV	R0,R.HH		;INCREMENT FOR TRIG TABLE
	MOV	R0,F.HH		;AGAIN
	CLR	F.SCLF		;INIT SCALE FACTOR
	TST	F.INV		;INVERSE REQUESTED?
	BNE	R.M1		;YES,BRANCH
	JSR	PC,F.MAIN	;NO, DO FORWARD TRANSFORM
	MOV	R.HH,F.HH	;GET INC IN TRIG TABLE
	ASR	F.HH		;ADJUST TRIG INC.
	JSR	PC,R.RIZE	;GO COMPUTE REAL TRANSFORM
	TST	F.SPCT		;DO POWER SPECTRUM?
	BNE	R.EXIT		;NO,SKIP
	JSR	PC,F.SPM	;YES, GO COMPUTE IT
	BR	R.EXIT		;EXIT
R.M1:	ASR	F.HH		;ADJUST TRIG INC.
	JSR	PC,R.RIZE	;INVERSE: GO REAL-IZE
	ASL	F.HH		;ADJUST TRIG INC
	JSR	PC,F.MAIN	;DO TRANSFORM
R.EXIT:	CLC			;CLEAR ERROR FLAG
R.EXER:	MOV	(SP)+,R5	;RESTORE REGS
	MOV	F.SCLF,@6(R5)	;RETURN SCALE FACTOR
R.ERR2:	MOV	(SP)+,R4	;RESTORE REGISTERS
	MOV	(SP)+,R3	;	"
	MOV	(SP)+,R2	;	"
	MOV	(SP)+,R1	;	"
	MOV	(SP)+,R0	;	"
	RTS	PC		;RETURN
R.EREX:	MOV	(SP)+,R5	;GET NO. OF PARAMS
	CMPB	#6,@R5		;IS ERROR WORD THERE?
	BGT	R.ERR1		;NO, BR
	MOV	#2,@12.(R5)	;YES,INSERT ERROR CODE
R.ERR1:	SEC			;SET ERROR FLAG
	BR	R.ERR2		;GO EXIT


;
;ROUTINE TO COMBINE OR SEPARATE THE
;REAL AND COMPLEX PARTS OF A COMPLEX
;TRANSFORM TO PRODUCE THE REAL TRANSFORM
;
;CALL BY JSR PC,R.RIZE
;
R.RIZE:	MOV	F.N,R.CTR	;SET UP LOOP COUNTER
	ASR	R.CTR		;	"
	MOV	F.N,R4		;SET UP UPPER POINTER
	ASL	R4		;	"
	ASL	R4		;	"
	MOV	ARRAY,R3	;SET UP LOWER POINTER
	ADD	R3,R4		;ADD BASE TO UPPER POINTER
	CLR	F.H		;CLEAR POINTER TO TRIG TABLE
	MOV	#R.R5,F.ORTN
	BR	R.SKP1
R.OFL1:	JMP	F.OFL
R.SKP1:
R.R5:	MOV	(R3),R2		;X(I)
	MOV	2(R3),R0	;Y(I)
	MOV	R2,XR1		;X(I)
	MOV	R0,R5		;Y(I)
	ADD	(R4),R2		;X(I)+ X(N-I)
	BVS	R.OFL1		;OVERFLOW
	ADD	2(R4),R0	;Y(I)+Y(N-I)
	BVS	R.OFL1		;
	SUB	(R4),XR1	;X(I)-X(N-I)
	BVS	R.OFL1		;
	SUB	2(R4),R5	;Y(I)-Y(N-I)
	BVS	R.OFL1		;
	JSR	PC,R.TRIG	;GET CURRENT SINE & COSINE
	MOV	R0,XR0		;SAVE R0
	MUL	F.COS,R0	;FORM THE POINT TRANSFORM
	ASHC	#1,R0		;	"
	MOV	R0,R.B		;	"
	MOV	XR1,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	SUB	R0,R.B		;	"
	BVS	R.OFL1
	MOV	XR0,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,R.D		;	"
	MOV	XR1,R0		;	"
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	ADD	R0,R.D		;	"
	BVS	R.OFL1
	TST	F.INV		;INVERSE REQUESTED?
	BNE	R.R3		;YES,BRANCH
	MOV	R2,R0		;A
	MOV	R5,R1		;C
	ADD	R.B,R2		;NEW X(I)
	BVS	R.OFL2
	SUB	R.B,R0		;NEW X(N-I)
	BVS	R.OFL2
	SUB	R.D,R1		;NEW Y(I)
	BVS	R.OFL2
	NEG	R5
	SUB	R.D,R5		;NEW Y(N-I)
	BVS	R.OFL2
	BR	R.R4		;GO STORE NEW VALUES
R.OFL2:	JMP	F.OFL
R.R3:	MOV	R2,R0		;A
	MOV	R5,R1		;C
	SUB	R.B,R2		;X(I)
	BVS	R.OFL2		;
	ADD	R.B,R0		;X(N-I)
	BVS	R.OFL2
	ADD	R.D,R1		;Y(I)
	BVS	R.OFL2
	NEG	R5
	ADD	R.D,R5		;Y(M-I)
	BVS	R.OFL2
R.R4:	MOV	R2,(R3)		;STORE NEW VALUES
	MOV	R0,(R4)		;	"
	MOV	R1,2(R3)	;	"
	MOV	R5,2(R4)	;	"
	ADD	F.HH,F.H	;BUMP TRIG TABLE POSITION
	CMP	(R3)+,(R3)+	;INC LOWER POINTER
	CMP	-(R4),-(R4)	;DEC UPPER POINTER
	DEC	R.CTR		;LOOP?
	BGE	R.R5		;YES, BRANCH
	TST	F.INV		;ADJUST SCALE FACTOR
	BNE	R.R6		;	"
	DEC	F.SCLF		;	"
R.R6:	RTS	PC		;RETURN
;
;ROUTINE TO LOOK UP TRIG TABLE VALUES
;
;CALL BY JSR PC,R.TRIG
;
;
R.TRIG:	MOV	R4,-(SP)
	CMP	F.H,#1024.
	BLE	R.HOP1
	MOV	#2048.,R4
	SUB	F.H,R4
	MOV	F.TRIG(R4),F.SIN
	MOV	F.H,R4
	SUB	#1024.,R4
	MOV	F.TRIG(R4),F.COS
	NEG	F.COS
	BR	R.HOP2
R.HOP1:	MOV	F.H,R4
	MOV	F.TRIG(R4),F.SIN
	NEG	R4
	ADD	#1024.,R4
	MOV	F.TRIG(R4),F.COS
R.HOP2:	TST	F.INV
	BEQ	R.HOP3
	NEG	F.SIN
R.HOP3:	MOV	(SP)+,R4
	RTS	PC
;START OF PROGRAM


F.MAIN:	MOV	#1,F.LL		;1 SUBGROUP IN FIRST COLUMN
	MOV	F.N,F.M		;M IS POINTER TO NEXT SUBGP
	ASL	F.M		;ADDRESSES GO BY 4'S
	ASL	F.M		;	"
	MOV	F.N,F.GRPN	;NO. OF POINTS IN SUBGROUP
	MOV	#F.ORT1,F.ORTN	;SET UP RETURN FROM OFLOW RTN
	MOV	F.R,F.L		;START MAIN LOOP:(LOG N)-2 TIMES
	BR	F.SKP8
F.OFL2:	JMP	F.OFL
F.SKP8:
F.NXTC:	MOV	F.M,F.ORG	;OFFSET OF NEXT SUBGROUP
	ASR	F.M		;M=M/2
	ASR	F.GRPN		;INIT SUBGROUP POINT COUNTER
	MOV	F.GRPN,F.SCT	;	"
	CLR	F.A1		;POINTER TO TOP HALF SUBGROUP
	MOV	F.M,F.A2	;POINTER TO BOTTOM HALF SUBGROUP
	MOV	F.LL,F.K	;NUMBER OF SUBGROUPS PER COL
	CLR	F.H		;SET TRIG TABLE POINTER
F.SBGP:	MOV	ARRAY,R2	;PTR TO TOP HALF OF SUBGROUP
	MOV	R2,R3		;PTR TO BOTTOM HALF OF SUBGRP
	ADD	F.A1,R2		;SET UP SUBGP HALF ADDRESSES
	ADD	F.A2,R3		;      "
	MOV	R4,-(SP)	;STORE R4
	CMP	F.H,#1024.	;LOOK UP SINE AND COSINE
	BLE	F.HOP1		;(2 BYTES = 1 WORD)
	MOV	#2048.,R4	;H GT 512
	SUB	F.H,R4		;
	MOV	F.TRIG(R4),F.SIN ;SINE
	MOV	F.H,R4
	SUB	#1024.,R4
	MOV	F.TRIG(R4),F.COS ;COSINE
	NEG	F.COS
	BR	F.HOP2
F.HOP1:	MOV	F.H,R4		;H LE 512
	MOV	F.TRIG(R4),F.SIN  ;SINE
	NEG	R4
	ADD	#1024.,R4
	MOV	F.TRIG(R4),F.COS  ;COSINE
F.HOP2:	TST	F.INV
	BEQ	F.HOP3		;NO, SKIP
	NEG	F.SIN		;YES, NEGATE SINE
F.HOP3:	MOV	(SP)+,R4	;RESTORE R4
F.ORT1:	MOV	(R2),R4		;GET 1ST HALF, REAL
	MOV	2(R2),R5	;GET 1ST HALF, IMAG
	MOV	R4,XR0		;TEMP
	MOV	R5,XR1		;TEMP
	ADD	(R3),XR0	;DON'T ADD DIRECTLY, SINCE YOU
	BVS	F.OFL2		;DON'T WANT TO ALTER THE DATA
	ADD	2(R3),XR1	;BEFORE CHECKING FOR OVERFLOW
	BVS	F.OFL2
	SUB	(R3),R4		;FORM SR-TR
	BVS	F.OFL2
	SUB	2(R3),R5	;FORM SI-TI
	BVS	F.OFL2
	MOV	R4,R0		;FORM 2ND HALF SUBGROUP ENTRY
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,F.TRT	;	"
	MOV	R5,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	ADD	R0,F.TRT	;	"
	BVS	F.OFLO
	MOV	R5,R0		;	"
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,R5		;	"
	MOV	R4,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	SUB	R0,R5		;	"
	BVS	F.OFLO
	MOV	XR0,(R2)	;INSERT TRANSFORMED POINTS
	MOV	XR1,2(R2)	;     "
	MOV	F.TRT,(R3)		;     "
	MOV	R5,2(R3)	;     "
	DEC	F.K		;SUBGROUP SCAN DONE?
	BLE	F.SKP4		;BR IF ALL SUBGROUPS DONE
	ADD	F.ORG,R2	;SET UP FOR POINT IN
	ADD	F.ORG,R3	;NEXT SUBGROUP
	BR	F.ORT1		;GO DO IT
F.SKP4:	DEC	F.SCT		;DONE WITH COLUMN?
	BLE	F.SKP5		;YES, BR
	MOV	F.LL,F.K	;RE-INIT NO. OF SUBGROUPS
	ADD	F.HH,F.H	;NO, NEXT W
	ADD	#4,F.A1		;SET UP FOR NEXT
	ADD	#4,F.A2		;SUBGROUP SCAN
	JMP	F.SBGP		;GO DO IT
F.SKP5:	DEC	F.L		;N-2 COLUMNS DONE
	BLE	F.SKP1		;YES, BR TO FIRST SPEC. LOOP
	ASL	F.LL		;DOUBLE NO. OF SUBGROUPS
	ASL	F.HH		;DOUBLE TRIG INC TOO
	JMP	F.NXTC		;GO DO NEXT COLUMN
F.OFLO:	JMP	F.OFL		;JUMP TO OVERFLOW ROUTINE

;DONE WITH (LOG N)-2 COLUMNS
;NOW DO 2 SPECIAL LOOPS

;FIRST SPECIAL LOOP

F.SKP1:	MOV	F.N,F.K		;K=N/4
	ASR	F.K
	ASR	F.K
	MOV	ARRAY,R2	;R2 KEEPS TRACK OF CURRENT FOUR
F.SPL1:	MOV	#F.ORT2,F.ORTN	;SET UP OVERFLOW ROUTINE
F.ORT2:	MOV	(R2),R0
	MOV	2(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	8.(R2),R0	;REAL PART OF FIRST HALF
	BVS	F.OFLO
	ADD	2+8.(R2),R1	;IMAG PART OF FIRST HALF
	BVS	F.OFLO
	SUB	8.(R2),R4	;1ST POINT IN 2ND HALF OF SBGP
	BVS	F.OFLO
	SUB	2+8.(R2),R5	;
	BVS	F.OFLO
	MOV	R0,(R2)		;STORE THE POINTS
	MOV	R1,2(R2)
	MOV	R4,8.(R2)
	MOV	R5,2+8.(R2)
	MOV	#F.ORT4,F.ORTN	;SET UP OVERFLOW ROUTINE
F.ORT4:	MOV	4(R2),R0	;DO 2ND POINTS IN SUBGROUP
	MOV	2+4(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	12.(R2),R0
	BVS	F.OFLO
	ADD	2+12.(R2),R1
	BVS	F.OFLO
	SUB	2+12.(R2),R5	;REAL PART
	BVS	F.OFLO
	NEG	R4
	ADD	12.(R2),R4	;IMAGINARY PART
	BVS	F.OFLO
	TST	F.INV
	BEQ	F.SP11		;NO, SKIP
	NEG	R5		;YES, NEGATE BOTTOM POINT
	NEG	R4		;	"
F.SP11:	MOV	R0,4(R2)	;STORE THE POINTS
	MOV	R1,2+4(R2)
	MOV	R5,12.(R2)
	MOV	R4,2+12.(R2)
	ADD	#16.,R2
	DEC	F.K
	BGT	F.SPL1

;END OF FIRST SPECIAL LOOP

;SECOND SPECIAL LOOP

	BR	F.SKP3
F.OFL1:	JMP	F.OFL
F.SKP3:	MOV	ARRAY,R2	;DATA ARRAY ADDRESS
	MOV	F.N,F.M		;SET UP COUNTER
	ASR	F.M		;	"
	MOV	#F.ORT3,F.ORTN	;SET UP OVERFLOW RETURN
F.SPL2:
F.ORT3:	MOV	(R2),R0
	MOV	2(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	4(R2),R0
	BVS	F.OFL1
	ADD	2+4(R2),R1
	BVS	F.OFL1
	SUB	4(R2),R4
	BVS	F.OFL1
	SUB	2+4(R2),R5
	BVS	F.OFL1
	MOV	R0,(R2)
	MOV	R1,2(R2)
	MOV	R4,4(R2)
	MOV	R5,2+4(R2)
	ADD	#8.,R2
	DEC	F.M
	BGT	F.SPL2

;END OF SECOND SPECIAL LOOP


;DO UNSCRAMBLING

F.UNSH:	MOV	#11.,X.BIT	;CALC. OFFSET IN BIT TABLE
	SUB	F.R,X.BIT	;	"
	ASL	X.BIT		;	"
	ADD	#X.S,X.BIT	;	"
	CLR	R3		;R3 COUNTS BIT REVERSED
	MOV	ARRAY,R0	;SAVE DATA ARRAY ADRS.
	MOV	F.N,F.M
	SUB	#2,F.M
	MOV	#4,R2
F.NSLP:	MOV	X.BIT,R1	;CALC. NEXT BIT
	BR	F.UN15		;REVERSED NUMBER
F.UN10:	BIC	(R1)+,R3	;	"
F.UN15:	BIT	(R1),R3		;	"
	BNE	F.UN10		;	"
	BIS	(R1),R3		;R3 NOW HAS BIT REV. NO.
	CMP	R3,R2
	BLE	F.NSCR
	ADD	R0,R2		;ADD ADRS. OF DATA ARRAY
	ADD	R0,R3		;	"
	MOV	(R2),R4
	MOV	(R3),(R2)
	MOV	R4,(R3)
	MOV	2(R2),R4
	MOV	2(R3),2(R2)
	MOV	R4,2(R3)
	SUB	R0,R2		;SUB. ADRS. OF DATA ARRAY
	SUB	R0,R3		;	"
F.NSCR:	ADD	#4,R2
	DEC	F.M
	BGT	F.NSLP
	MOV	F.N,R2		;SET Z(N)=Z(0)
	ASL	R2		;	"
	ASL	R2		;	"
	ADD	R0,R2		;	"
	MOV	(R0)+,(R2)+	;	"
	MOV	(R0),(R2)	;	"
	RTS	PC		;RETURN

X.S:	40000
	20000
	10000
	4000
	2000
	1000
	400
	200
	100
	40
	20
	10
	4
	0



;COMPUTE SPECTRAL ESTIMATES RE**2+IM**2

F.SPM:	MOV	F.N,F.M		;SET UP COUNTER
	MOV	ARRAY,R2
	MOV	R2,R4
F.ESTL:	MOV	(R2),R0
	MUL	R0,R0
	ASHC	#1,R0
	BVC	F.ESL1		;BR IF NO O'FLOW
	MOV	#77777,F.SR	;YES, SET MAX.
	BR	F.ESL2		;BR
F.ESL1:	MOV	R0,F.SR
F.ESL2:	MOV	2(R2),R0
	MUL	R0,R0
	ASHC	#1,R0
	BVC	F.ESL3		;BR IF NO O'FLOW
	ADD	#77777,F.SR	;YES, ADD MAX.
	BR	F.ESL4		;BR
F.ESL3:	ADD	R0,F.SR
F.ESL4:	BVS	F.ROFL
	MOV	F.SR,(R4)+
	CMP	(R2)+,(R2)+
	DEC	F.M
	BGE	F.ESTL
	RTS	PC


;OVERFLOW ROUTINE

F.OFL:	MOV	F.N,R0
	ASR	R0
	MOV	ARRAY,R1
F.OFLP:	ASR	(R1)+
	ASR	(R1)+
	ASR	(R1)+
	ASR	(R1)+
	DEC	R0
	BGT	F.OFLP
	ASR	(R1)+		;SHIFT LAST TWO POINTS ALSO
	ASR	(R1)		;	"
	INC	F.SCLF		;BUMP SCALE FACTOR
	JMP	@F.ORTN

F.ORTN:	0

;OVERFLOW ROUTINE FOR SPECTRAL ESTIMATES

F.ROFL:	MOV	F.N,F.MM
	ASL	F.MM
	ASL	F.MM
	MOV	ARRAY,R3
	ADD	R3,F.MM		;ADD IN DATA ARRAY ADRS.
	CMP	R3,R2
	BEQ	F.ROF2
F.ROF1:	ASR	(R3)
	ASR	(R3)+
	CMP	R2,R3
	BHI	F.ROF1
F.ROF2:	ASR	(R3)+
	ASR	(R3)+
	CMP	F.MM,R3
	BHIS	F.ROF2
	INC	F.SCLF
	JMP	F.ESTL


;SINE/COSINE TABLE

F.TRIG:	00000
	00145
	00311
	00456
	00622
	00767
	01133
	01300
	01444
	01611
	01755
	02122
	02266
	02433
	02577
	02743
	03110
	03254
	03421
	03565
	03731
	04076
	04242
	04406
	04553
	04717
	05063
	05227
	05373
	05540
	05704
	06050
	06214
	06360
	06524
	06670
	07034
	07200
	07344
	07507
	07653
	10017
	10163
	10326
	10472
	10636
	11001
	11145
	11310
	11453
	11617
	11762
	12125
	12271
	12434
	12577
	12742
	13105
	13250
	13413
	13556
	13721
	14063
	14226
	14371
	14533
	14676
	15040
	15203
	15345
	15507
	15651
	16014
	16156
	16320
	16461
	16623
	16765
	17127
	17270
	17432
	17573
	17735
	20076
	20237
	20401
	20542
	20703
	21044
	21204
	21345
	21506
	21647
	22007
	22147
	22310
	22450
	22610
	22750
	23110
	23250
	23410
	23550
	23707
	24047
	24206
	24345
	24505
	24644
	25003
	25142
	25301
	25437
	25576
	25734
	26073
	26231
	26367
	26525
	26663
	27021
	27157
	27314
	27452
	27607
	27745
	30102
	30237
	30374
	30531
	30665
	31022
	31156
	31313
	31447
	31603
	31737
	32073
	32227
	32362
	32516
	32651
	33004
	33137
	33272
	33425
	33560
	33712
	34045
	34177
	34331
	34463
	34615
	34747
	35100
	35232
	35363
	35514
	35645
	35776
	36127
	36257
	36410
	36540
	36670
	37020
	37150
	37300
	37427
	37557
	37706
	40035
	40164
	40313
	40441
	40570
	40716
	41044
	41172
	41320
	41446
	41573
	41721
	42046
	42173
	42320
	42444
	42571
	42715
	43041
	43165
	43311
	43435
	43560
	43704
	44027
	44152
	44275
	44417
	44542
	44664
	45006
	45130
	45252
	45373
	45515
	45636
	45757
	46100
	46221
	46341
	46461
	46601
	46721
	47041
	47161
	47300
	47417
	47536
	47655
	47773
	50112
	50230
	50346
	50464
	50601
	50717
	51034
	51151
	51266
	51403
	51517
	51633
	51747
	52063
	52177
	52312
	52425
	52540
	52653
	52766
	53100
	53212
	53324
	53436
	53547
	53661
	53772
	54103
	54214
	54324
	54434
	54544
	54654
	54764
	55073
	55202
	55311
	55420
	55527
	55635
	55743
	56051
	56157
	56264
	56371
	56476
	56603
	56710
	57014
	57120
	57224
	57327
	57433
	57536
	57641
	57744
	60046
	60150
	60252
	60354
	60456
	60557
	60660
	60761
	61062
	61162
	61262
	61362
	61462
	61561
	61660
	61757
	62056
	62154
	62253
	62351
	62446
	62544
	62641
	62736
	63033
	63127
	63223
	63320
	63413
	63507
	63602
	63675
	63770
	64062
	64155
	64247
	64340
	64432
	64523
	64614
	64705
	64775
	65066
	65156
	65245
	65335
	65424
	65513
	65602
	65670
	65756
	66044
	66132
	66217
	66304
	66371
	66456
	66542
	66626
	66712
	66776
	67061
	67144
	67227
	67311
	67373
	67455
	67537
	67620
	67702
	67762
	70043
	70123
	70203
	70263
	70343
	70422
	70501
	70560
	70636
	70714
	70772
	71050
	71125
	71202
	71257
	71334
	71410
	71464
	71537
	71613
	71666
	71741
	72013
	72066
	72140
	72211
	72263
	72334
	72405
	72455
	72526
	72576
	72646
	72715
	72764
	73033
	73102
	73150
	73216
	73264
	73331
	73376
	73443
	73510
	73554
	73620
	73664
	73730
	73773
	74036
	74100
	74143
	74205
	74246
	74310
	74351
	74412
	74452
	74512
	74552
	74612
	74652
	74711
	74747
	75006
	75044
	75102
	75140
	75175
	75232
	75267
	75323
	75357
	75413
	75447
	75502
	75535
	75570
	75622
	75654
	75706
	75737
	75771
	76021
	76052
	76102
	76132
	76162
	76211
	76240
	76267
	76316
	76344
	76372
	76417
	76445
	76472
	76516
	76543
	76567
	76612
	76636
	76661
	76704
	76726
	76751
	76773
	77014
	77036
	77057
	77077
	77120
	77140
	77160
	77177
	77216
	77235
	77254
	77272
	77310
	77326
	77343
	77360
	77375
	77412
	77426
	77442
	77455
	77470
	77503
	77516
	77530
	77542
	77554
	77565
	77576
	77607
	77620
	77630
	77640
	77647
	77656
	77665
	77674
	77702
	77710
	77716
	77723
	77731
	77735
	77742
	77746
	77752
	77755
	77761
	77764
	77766
	77770
	77772
	77774
	77776
	77777
	77777
	77777
	77777

	.END

                                                                                                                                                                                                                                                                       