/*+
 * VOID sbuild(out, len, str1, str2, ...., strm, NULL)
 *     TEXT  *out, *str1;
 *     COUNT len;
 *
 * Description  : Concatenates n strings to an output string, but no more
 *                then a given number of characters
 *
 * Arguments    : OUT    = STRING to which all others are concatenated
 *                LEN    = (optional) INTEGER maximum number of chars. in OUT
 *                STRm   = a STRING to be concatenated
 *                NULL   = 0 to indicate end of list
 * Author       : T.Pijl
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.0      Date : 6-jan-83
 *
 * Module name  : SBUILD.MAC
 *
 * Package      : RTLIB
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : sbuild.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>

VOID sbuild(out, len, str1)
    TEXT  *out, *str1;
    COUNT len;

    {
    FAST TEXT  **p;
    FAST COUNT i;

    p = &str1;
    i = lenstr(out);
    out += i;
    while(i < len)
        {
        if(**p == NULL  && *p != NULL) /* if end of strm */
            {                          /* and not end of string list */
            ++p;                       /*   then get next string */
            }
        if(*p == NULL)      /* if end of string list - return */
            {
            return;
            }
       *(out++) = *((*p)++); /* copy char then point to next char */
        ++i;
        }
    }
                                                                                                                                                                                            