
	SUBROUTINE CVAI (INSTR, NUM, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Converted to Fortran-77, 2-Mar-84
C
C	Converts an ASCII string into an integer.
C	Input is string, output is num, number of characters
C	to be converted is N1.
C	Specify starting position in string in call (i.e.,
C	call CVAI with STRING(3)).
C	If the string has trailing blanks, the number gets properly
C	right-justified.
C	New fix on right justification, 16-Oct-85.
C	Set ASCII characters > 9 to binary 0.
C	Allow minus signs on ASCII strings to produce negative number.
C
	REAL*4 RN(5), MAXNUM
	LOGICAL*1 BLNCTR
	BYTE INSTR(1), STRING(20)
C
	PARAMETER (MAXNUM=32786.)
C
	IF (N1.EQ.0) THEN		!No number of digits specified.
	  TYPE 70, 7
	  RETURN
	ENDIF
C
	NUM= 0				!Integer answer.
	RNUM= 0.			!Intermediate answer.
	BLNCTR= .FALSE.			!Trailing blank counter.
	L= N1
C
	DO 20 K= N1,1,-1		!Right-justify the string.
	  IF (INSTR(K).NE."40) THEN	!Shift the non-blank characters
	    STRING(L)= INSTR(K)		!to the output string.
	    L= L- 1
	    BLNCTR= .TRUE.
	  ELSE IF (BLNCTR) THEN		!Don't do this for leading blanks.
	    DO 10 J= 1,L
10	      STRING(J)= "40		!Blank the output.
	    GO TO 30
	  ENDIF
20	CONTINUE
C
30	CONTINUE
	NUMSGN= 1
	BLNCTR= .TRUE.
	DO 40 K= 1,N1			!If we have a leading - sign, set the
	  IF (STRING(K).GE.'0') BLNCTR= .FALSE.	!negative flag.
	  IF (BLNCTR .AND. STRING(K).EQ.'-') NUMSGN= -1
40	CONTINUE
C
	DO 50 K= 1,N1
	  RN(K)= STRING(K)- "60		!Convert ASCII to number.
	  IF (RN(K).LT.0. .OR. RN(K).GT.9.) RN(K)= 0.	!Convert blanks to zeros.
50	CONTINUE
C
	DO 60 K= 1,N1
	  L= N1- K			!Power of 10.
	  RNUM= RNUM+ RN(K)*10**L	!Build a number.
60	CONTINUE
	IF (RNUM.GT.MAXNUM) THEN
	  TYPE 80, 7, INSTR
	  RETURN
	ENDIF
C
	NUM= RNUM* NUMSGN
	RETURN
C
70	FORMAT (' CVAI-F-No Specification of Digits' A1)
80	FORMAT (' CVAI-F-Integer Overflow:' A1, 20A1)
	END
	SUBROUTINE CVIA (INUM, STRING, NDIGIT)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	This routine converts an integer into an ASCII string
C	(left-justified).
C	The number can be up to 32767 (10).
C	The position in the string where the digits are placed is
C	controlled by the call, (e.g., STRING(3)).
C	The number of digits in the string converted is returned in NDIGIT.
C	If the routine is entered with NDIGIT=0, leading zeros are not copied.
C	If NDIGIT >0, NDIGIT digits (including possibly leading zeros) are
C	copied over.  If the number is bigger than the NDIGIT digits specified
C	in the subroutine call, all the digits in the number will be converted
C	(make sure your string is big enough)!
C	Allow negative numbers.  Note - if you specify more digits to be
C	converted than the number has, you will get the following effect:
C	"-00xxx".  This may or may not be aesthetically pleasing.
C
	DIMENSION N(5)
	INTEGER*2 SIGN, OFFSET, NSTART
	BYTE STRING(1)
C
	PARAMETER (NPWR=5)		!Max number of digits.
C
	NUM= ABS (INUM)			!Save the original number.
	N1= 0				!Initialize.
C
	DO 10 K= 1,NPWR
	  L= NPWR- K			!Power of 10.
	  N(K)= NUM/10**L		!Split up the digits.
C	Find the number of digits after the leading zeros.
	  IF (N(K).NE.0 .AND. N1.EQ.0) N1= L+ 1
	  NUM= NUM- N(K)*10**L		!Subtract off digit found.
10	CONTINUE
C
	IF (INUM.lt.0) THEN		!See if we are dealing with a -ve #.
	  STRING(1)= '-'		!Take care of negative numbers.		
	  SIGN= 1
	ELSE
	  SIGN= 0
	ENDIF
C
C	Now figure out how many digits to copy, and where to place
C	them in the output string.  (This depends on the number requested,
C	and whether there is a minus sign).
	IF (NDIGIT.EQ.0) THEN		!Copy all the significant digits.
	  NSTART= 1
	  OFFSET= SIGN
	  NDIGIT= N1+ SIGN
	ELSE IF (NDIGIT.GE.N1+SIGN) THEN	!We have less digits than
	  NSTART= 1+ SIGN		!were specified (including any sign).
	  OFFSET= 0			!Don't take more digits than the
	  N1= NDIGIT			!program expects.
	ELSE				!Too many digits (including sign).
	  TYPE 40, N1+SIGN, NDIGIT
	  DO 20 K= 1,NDIGIT		!Just set the number of digits
	    STRING(K)= "60		!originally in the string to 0.
20	  CONTINUE
	  RETURN
	ENDIF
C
	DO 30 K= NSTART, N1		!Now copy over the digits.
	  L= NPWR- N1+ K		!Start at non-zero values in N(K)
	  STRING(OFFSET+K)= N(L)+ "60	!Make ASCII
30	CONTINUE
	RETURN
C
40	FORMAT (' CVIA-F-String Overflow:'I2,' digits in a'I2,'-char string')
	END
	SUBROUTINE CVAJ (INSTR, NUM, N1)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Converts an ASCII string into a double-precision integer.
C	Input is string, output is num, number of characters
C	to be converted is N1.
C	Specify starting position in string in call (i.e.,
C	call CVAI with STRING(3)).
C	If the string has trailing blanks, the number gets properly
C	right-justified.
C	Set ASCII characters > 9 to binary 0.
C	Allow - sign in ASCII string to give negative number.
C
	REAL*4 RN(10)
	REAL*8 RNUM, MAXNUM
	LOGICAL*1 BLNCTR
	INTEGER*4 NUM, TEN
	BYTE INSTR(1), STRING(30)
C
	PARAMETER (MAXNUM=2147385345., TEN=10)
C
	IF (N1.EQ.0) THEN		!No number of digits specified
	  TYPE 70, 7
	  RETURN
	ENDIF
C
	NUM= 0				!Integer answer
	RNUM= 0.			!Intermediate answer
	BLNCTR= .FALSE.			!Trailing blank counter
	L= N1
C
	DO 20 K= N1,1,-1		!Right-justify the string.
	  IF (INSTR(K).NE."40) THEN	!Shift the non-blank characters
	    STRING(L)= INSTR(K)		!to the output string.
	    L= L- 1
	    BLNCTR= .TRUE.
	  ELSE IF (BLNCTR) THEN		!Don't do this for leading blanks.
	    DO 10 J= 1,L
10	      STRING(J)= "40		!Blank the output.
	    GO TO 30
	  ENDIF
20	CONTINUE
C
30	CONTINUE
	NUMSGN= 1
	BLNCTR= .TRUE.
	DO 40 K= 1,N1			!If we have a leading - sign, set the
	  IF (STRING(K).GE.'0') BLNCTR= .FALSE.	!negative flag.
	  IF (BLNCTR .AND. STRING(K).EQ.'-') NUMSGN= -1
40	CONTINUE
C
	DO 50 K= 1,N1
	  RN(K)= STRING(K)- "60		!Convert ASCII to number
	  IF (RN(K).LT.0. .OR. RN(K).GT.9.) RN(K)= 0.	!Convert blanks to zeros.
50	CONTINUE
C
	DO 60 K= 1,N1
	  L= N1- K			!Power of 10
	  RNUM= RNUM+ RN(K)*TEN**L	!Build a number
60	CONTINUE
	IF (RNUM.GT.MAXNUM) THEN
	  TYPE 80, 7, INPSTR
	  RETURN
	ENDIF
C
	NUM= RNUM* NUMSGN
	RETURN
C
70	FORMAT (' CVAJ-F-No Specification of Digits' A1)
80	FORMAT (' CVAJ-F-Integer Overflow:' A1, 30A1)
	END
	SUBROUTINE CVJA (INUM, STRING, NDIGIT)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	This routine converts a double-precision integer into an
C	ASCII string (left-justified).
C	The number can be up to 2147385345 (10).
C	The position in the string where the digits are placed is
C	controlled by the call, (e.g., STRING(3)).
C	The number of digits in the string converted is returned in NDIGIT.
C	If the routine is entered with NDIGIT=0, leading zeros are not copied.
C	If NDIGIT >0, NDIGIT digits (including possibly leading zeros) are
C	copied over.  If the number is bigger than the NDIGIT digits specified
C	in the subroutine call, all the digits in the number will be converted
C	(make sure your string is big enough)!
C	Allow negative numbers.  Note - if you specify more digits to be
C	converted than the number has, you will get the following effect:
C	"-00xxx".  This may or may not be aesthetically pleasing.

C
	DIMENSION N(10)
	INTEGER*2 SIGN, OFFSET
	INTEGER*4 INUM, NUM, TEN
	BYTE STRING(1)
C
	PARAMETER (NPWR=10, TEN=10)	!Max number of digits
C
	NUM= ABS (INUM)			!Save the original number
	N1= 0				!Initialize
C
	DO 10 K= 1,NPWR
	  L= NPWR- K			!Power of 10
	  N(K)= NUM/TEN**L		!Split up the digits
C	  Find the number of digits after the leading zeros.
	  IF (N(K).NE.0 .AND. N1.EQ.0) N1= L+ 1
	  NUM= NUM- N(K)*TEN**L		!Subtract off digit found
10	CONTINUE
C
	IF (INUM.lt.0) THEN
	  STRING(1)= '-'		!Take care of negative numbers.
	  SIGN= 1
	ELSE
	  SIGN= 0
	ENDIF
C
	IF (NDIGIT.EQ.0) THEN		!Copy all the significant digits.
	  NSTART= 1
	  OFFSET= SIGN
	  NDIGIT= N1+ SIGN
	ELSE IF (NDIGIT.GE.N1+SIGN) THEN	!We have less digits than
	  NSTART= 1+ SIGN		!were specified (including any sign).
	  OFFSET= 0			!Don't take more digits than the
	  N1= NDIGIT			!program expects.
	ELSE				!Too many digits (including sign).
	  TYPE 40, N1+SIGN, NDIGIT
	  DO 20 K= 1,NDIGIT		!Just set the number of digits
	    STRING(K)= "60		!originally in the string to 0.
20	  CONTINUE
	  RETURN
	ENDIF
C
	DO 30 K= NSTART, N1		!Now copy over the digits.
	  L= NPWR- N1+ K		!Start at non-zero values in N(K)
	  STRING(OFFSET+K)= N(L)+ "60	!Make ASCII
30	CONTINUE
	RETURN
C
40	FORMAT (' CVJA-F-String Overflow:'I2,' digits in a'I2,'-char string')
	END
                                                                                                                                                                                                                                                                                                                                                                                    