	PROGRAM MMIND	!Mastermind for multi-terminal /L.C.P. - 11/79


	INTEGER TIME(2),STAT(8),AST(8),GCNT(8)
	INTEGER A(4,8),G(4,8),BCNT(8)

	LOGICAL*1 NG(4),ANSI(3),VT52(12)
	LOGICAL*1 URGES(13),BMESG(10),BAD,NSW
	LOGICAL*1 H(10,8),B,W,Z,TOKEN,NGES(16)

	COMMON /MTEXT/MTEXT
	COMMON /PARAM/ A,G,I,J,BCNT,LUN,B,W,H,Z

	DATA AST/0,0,0,0,0,0,0,0/
	DATA NG/0,0,0,0/
	DATA B,W,Z/'B','W',0/
	DATA ANSI/"33,"76,0/
	DATA VT52/"33,"133,"77,"62,"154,"33,"134,"33,"110,"33,"112,0/
	DATA URGES/'Y','o','u','r',' ','g','u','e','s','s','?',' ',"200/
	DATA NGES/'#',' ','o','f',' ','g','u','e','s','s','e','s',
	1	' ','=',' ',"200/
	DATA BMESG/'?','I','L','L','E','G','A','L','?',0/

C	INITIALIZATION ...

	IF (MTSTAT(STAT).NE.0) STOP '?Not Multi-terminal system?'

	NLUN=STAT(3)				!Get # of terminals on system
	DO 1 I=1,NLUN				!Attach as many terminals
	LUN=I					! as we can ...
	IF(MTATCH(LUN,AST(LUN)).NE.0) GOTO 1
	CALL MTGET(LUN,STAT)			!Get TCB status words
	STAT(1)=STAT(1).OR."100			!Set TCBIT$
	CALL MTSET(LUN,STAT)			! in terminal's TCB
	H(10,LUN)=Z				!ASCIZ to terminate tokens ...
	GCNT(LUN)=0				!Initialize guess count ...
	CALL MTPRNT(LUN,ANSI)			!VT100s to ANSI/VT52 mode ...
	CALL MTPRNT(LUN,VT52)
	CALL MTPRNT(LUN,MTEXT)
	CALL MTPRNT(LUN,URGES)
1	CONTINUE

C	"SEED" THE RANDOM # GENERATOR ...

	L=0
	M=0
	CALL GTIM(TIME)
	DO 2 I=1,IABS(TIME(2))
2	X=RAN(L,M)

C	TERMINAL POLLING ...

C	LUN=1					!Start with 1st terminal ...
C3	IF(AST(LUN).AND."40000) GOTO 5		!Branch if input ready
C4	LUN=MOD(LUN,NLUN)+1			!Get next LUN ...
C	IF(ISLEEP(0,0,0,33).NE.0) STOP 'NO Q-ELEMENT' !Ease up for 1/2 sec
C	GOTO 3					!Continue polling ...
C5	IF(GCNT(LUN))4,8,12			!Ah-ha ... service player

5	DO 90 LUN=1,NLUN
	IF(.NOT.AST(LUN).AND."40000) GOTO 90
	IF(GCNT(LUN))90,8,12

C	GAME LOGIC ...

C	PICK A RANDOM NUMBER BETWEEN 1 & 7 ("SUPER" MASTERMIND)
C	FOLLOW COMMENTED DIRECTIONS TO ALLOW DUPLICATE #S

8	DO 11 I=1,4
9	A(I,LUN)=RAN(L,M)*7+1			!No '0's please ...
	IF(I.EQ.1) GOTO 11			!COMMENT OUT FOR DUPLICATE #S
	DO 10 J=1,I-1				!COMMENT OUT FOR DUPLICATE #S
	IF(A(J,LUN).EQ.A(I,LUN))GOTO 9		!COMMENT OUT FOR DUPLICATE #S
10	CONTINUE				!COMMENT OUT FOR DUPLICATE #S
11	CONTINUE

	TYPE 111,LUN,(A(I,LUN),I=1,4)		!Display answer on console
111	FORMAT(' LUN ',I2,' = ',4I1)

C	GET THE GUESS ...

12	GCNT(LUN)=GCNT(LUN)+1			!Bump guess count ...
	CALL MTIN(LUN,H(1,LUN),8)		!Input the guess ...
	IF(H(1,LUN).EQ.'Q'.AND.H(2,LUN).EQ.'U') GOTO 50 !For quitters

C	CHECK FOR VALID # THEN COPY IT IN INTEGER FORM ...

	BAD=0					!Initialize switch
	DO 13 I=1,4				!Check for valid entry
	IF((H(I,LUN).LT.48).OR.(H(I,LUN).GT.55)) BAD=1 !?ILLEGAL?
13	CONTINUE
	IF(BAD.EQ.0) GOTO 14			!Branch if entry ok
	CALL MTPRNT(LUN,BMESG)			!Tell them that's a no-no
	GOTO 35					!Go prompt again ...

14	DECODE(4,100,H(1,LUN))(G(I,LUN),I=1,4)	!Copy guess ...

C	LOOK FOR HITS ...

	BCNT(LUN)=0				!Initialize hit count
	DO 15 I=1,4				!Look for exact matches
	A(I,LUN)=IABS(A(I,LUN))			!UN-COMMENT FOR DUP #S
	H(5+I,LUN)=' '				!Initialize clue token
	IF (A(I,LUN).EQ.G(I,LUN)) CALL CLUE(B)	!Got a match !!!
15	CONTINUE
	IF(BCNT(LUN).EQ.4) GOTO 30		!They guessed the #

C	NOW LOOK FOR "NEAR MISSES" ...

	DO 25 I=1,4				!Look for right #
	DO 20 J=1,4				! but in wrong position
	IF(A(I,LUN).EQ.G(J,LUN)) CALL CLUE(W)	!Found one ...
20	CONTINUE
25	CONTINUE

C	DISPLAY THE GUESS AND THE CLUE TOKENS ...

30	H(5,LUN)=' '				!Insert a space between
	CALL MTPRNT(LUN,H(1,LUN))		! number & clue tokens
	IF(H(9,LUN).EQ.'B')GOTO 40		! & display them ...

C	PROMPT FOR HUMAN'S GUESS ...

35	CALL MTPRNT(LUN,URGES)			!Ask for another guess
	GOTO 90

C	GAME'S OVER - DISPLAY # GUESSES ...	!"ENCODE" 'cause F4's broken

40	J=100					!"ENCODE" guess count in ASCII
	NSW=1
	DO 42 I=1,3
	NG(I)="40
	K=((GCNT(LUN)-MOD(GCNT(LUN),J))/J)
	IF((K.EQ.0).AND.NSW) GOTO 41
	L=K+"60
	NG(I)=L
	NSW=0
	GCNT(LUN)=GCNT(LUN)-K*J
41	J=J/10
42	CONTINUE

	CALL MTPRNT(LUN,Z)			!Tell them how many guesses
	CALL MTPRNT(LUN,NGES)			! it took ...
	CALL MTPRNT(LUN,NG)

C	PAUSE WHILE HUMAN READS ...

	IF(ISLEEP(0,0,3,0).NE.0) STOP 'NO Q-ELEMENT'	!Wait awhile ...

C	REINITIALIZE FOR ANOTHER GAME ...

50	GCNT(LUN)=0				!Initialize guess count
	CALL MTPRNT(LUN,VT52)			!Intialize screen ...
	CALL MTPRNT(LUN,MTEXT)
	CALL MTPRNT(LUN,URGES)
90	CONTINUE
	CALL ISLEEP(0,0,0,33)
	GOTO 5

C	FORMAT FOR DECODE ...

100	FORMAT(4I1)

	END



	SUBROUTINE CLUE(TOKEN)

	INTEGER A(4,8),G(4,8),BCNT(8)

	LOGICAL*1 H(10,8),B,W,Z,TOKEN

	COMMON /PARAM/ A,G,I,J,BCNT,LUN,B,W,H,Z

	BCNT(LUN)=BCNT(LUN)+1			!Bump token count ...
	H(5+BCNT(LUN),LUN)=TOKEN		!Insert proper token ...
	A(I,LUN)=-A(I,LUN)			!Change # so won't match again
C	IF(TOKEN.EQ.B) G(I,LUN)=0		!UN-COMMENT FOR DUP #S
C	IF(TOKEN.EQ.W) G(J,LUN)=0		!UN-COMMENT FOR DUP #S
	RETURN
	END
                                                                                                                                                                     