/*
 *  Convert ASCII file name to radix-50 format
 */


#include "types.h"
#include "r50fil.h"


#define	FSMAX	14

#define	DEV	001
#define	FIL	002
#define	EXT	004

#define	NULLCHR	'\0'
#define	NULLSTR	""


char	_r50c_[128] = {			/* ASCII to Radix-50 conversion table */
	 -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	 -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	 -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	 -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
	000,  -1,  -1,  -1, 033,  -1,  -1,  -1,
	 -1,  -1,  -1,  -1,  -1,  -1, 034,  -1,
	036, 037, 040, 041, 042, 043, 044, 045,
	046, 047,  -1,  -1,  -1,  -1,  -1,  -1,
	 -1, 001, 002, 003, 004, 005, 006, 007,
	010, 011, 012, 013, 014, 015, 016, 017,
	020, 021, 022, 023, 024, 025, 026, 027,
	030, 031, 032,  -1,  -1,  -1,  -1,  -1,
	 -1, 001, 002, 003, 004, 005, 006, 007,
	010, 011, 012, 013, 014, 015, 016, 017,
	020, 021, 022, 023, 024, 025, 026, 027,
	030, 031, 032,  -1,  -1,  -1,  -1,  -1
};


_cvtr50(filspec,dblk)
char		*filspec;
struct r50fil	*dblk;
{

	char		fstmp[FSMAX+1];
	int		pflags;
	register char	*p;
	register char	*q;
	char		*dv;
	char		*fl;
	char		*xt;
	ushort		_ator50();

	if ( strlen(filspec) > FSMAX )
		return(0);
	strcpy(fstmp,filspec);

	for (  pflags=0, p=fstmp; *p; ) {

		for ( q=p; isalph(*q)||isdigit(*q); ++q )
			;

		if ( *q == ':' ) {
			if ( pflags&(DEV|FIL|EXT) )
				return(0);
			if ( q-p > 3 || q == p )
				return(0);
			dv = p;
			pflags |= DEV;
			*q++ = NULLCHR;
			p = q;
			continue;
		}

		if ( *q == '.' || *q == NULLCHR ) {

			if ( !(pflags&FIL) ) {
				if ( q-p > 6 || ( *q && q == p ) )
					return(0);
				fl = p;
				pflags |= FIL;
			} else if ( !(pflags&EXT) ) {
				if ( q-p > 3 )
					return(0);
				xt = p;
				pflags |= EXT;
			} else
				return(0);

			if ( *q == NULLCHR ) {
				if ( !(pflags&EXT) )
					xt = NULLSTR;
				break;
			}
			*q++ = NULLCHR;
			p = q;
			continue;
		}

		return(0);
	}

	if ( !pflags )
		return(0);
	if ( !(pflags&DEV) )
		dv = "dk";
	dblk->dev    = _ator50(&dv);
	dblk->fil[0] = _ator50(&fl);
	dblk->fil[1] = _ator50(&fl);
	dblk->ext    = _ator50(&xt);
	return(1);
}


/*
 *  Convert up to three ASCII characters to 16-bit radix-50 value; scanning
 *  stops after three characters, or when a non-radix-50 character is found,
 *  whichever occurs first; note type of s (char **, not char *); *s is left
 *  pointing to the byte following the last character converted
 */

ushort
_ator50(s)
register char	**s;
{
	int	i;
	ushort	scale;
	ushort	r;

	for ( i=3, scale=050*050, r=0; i; --i ) {
		if ( _r50c_[**s] == -1 )
			break;
		r += _r50c_[*(*s)++] * scale;
		scale /= 050;
	}
	return(r);
}
                                                                                                                                                                                                                                                                                                                                  