C
C
C DISK LOAD UTILITITY  *DLU*
C THIS VERSION USES RT-11 DRIVERS TO TALK TO THE DISK.
C IT INCLUDES RL01 SUPPORT
C
C
C JOHN C. DAVIES III
C
C MAY 1979
C
C----------------------------------------------------------------------
C
	INTEGER BUFF(5120),BUFF2(5120)
	INTEGER DBLK(4),RLBLK(4),RKBLK(4),DXBLK(4)
	INTEGER DA(5),TI(4)
	INTEGER DTYPE,DUNIT,RL,RK,DX
	INTEGER COMMD
	INTEGER YES,NO
	INTEGER DT,DU,MT,MU,PO,DI,FO,BO,VE,CO,EN,Q
C
C
C.DATA STATEMENTS
C
	DATA DXBLK/3RDX0,0,0,0/
	DATA RLBLK/3RDL0,0,0,0/
	DATA RKBLK/3RRK0,0,0,0/
	DATA DA(5)/'  '/
	DATA YES,NO/'YE','NO'/
	DATA RL,RK,DX/'RL','RK','DX'/
	DATA DT,DU,MT,MU,PO,DI,FO/'DT','DU','MT','MU','PO','DI','FO'/
	DATA BO,VE,CO,EN/'BO','VE','CO','EN'/
	DATA ID,Q/'ID','? '/
C
C
C.GET TODAY'S DATE AND TIME
C
	CALL DATE(DA)
	CALL TIME(TI)
C
C
C.ANNOUNCE PROGRAM
C
	WRITE(7,9000)
9000	FORMAT(/10X,' DLU     Pre release         Ver.  14-Aug-79'//)
C
C
C.ASSIGN DELFAULTS
C
C	SET UP FOR RK05 AND 9 TRACK MAG TAPE
C
C	CHANGE DTYPE,NTRAK,IWCNT,IBLKCT AND DBLK
C	TO SWITCH TO RL01'S.  THE PROPER NUMBERS FOR
C	RL01'S ARE STORED NEAR STATMENT NUMBER 120
C
C
	DTYPE=RK
	DUNIT=0
	MUNIT=0
	MTRACK=9
	MDENS=800
	MFILE=1
	NTRAK=406
	IWCNT=3072
	IBLKCT=12
	DO 5 I=1,4
	DBLK(I)=RKBLK(I)
 5	CONTINUE
	IZERO=DBLK(1)
C
C
C.WRITE STATUS OF DLU
C
 10	WRITE(7,9010)DTYPE,DUNIT,MUNIT,MTRACK,MDENS,MFILE
9010	FORMAT(/' DLU STATUS'//
     1	' Disk type is a ',A2/
     2	' Disk unit # is ',I1/
     3	' Mag tape unit # is ',I1/
     4  ' Mag tape is ',I1,' track, ',I4,' bpi'/
     5  ' Current mag tape file position is ',I1/)
C
C
C.GET STATUS OF DEVICES
C
	MRDY=1
	IF(IREADY(MUNIT).LT.0)MRDY=-1
	IF(MRDY.EQ.-1)WRITE(7,9011)
9011	FORMAT(' ?DLU-W-Mag tape not ready')
	IF(MRDY.EQ.1.AND.MFILE.EQ.1)CALL RWD(MUNIT)
	CALL DREADY(DTYPE,DUNIT,ICODE)
	IF(ICODE.LT.0)WRITE(7,9012)
9012	FORMAT(' ?DLU-W-Disk not ready')
C
C
C.ASK FOR A COMMAND
C
 20	WRITE(7,9020)
9020	FORMAT(/' DLU Command? ',$)
	READ(5,9030) COMMD
9030	FORMAT( A2)
C
C
C.COMMAND INTERPRETER
C
	IF(COMMD.EQ.Q )GO TO 50
	IF(COMMD.EQ.DT)GO TO 100
	IF(COMMD.EQ.DU)GO TO 200
	IF(COMMD.EQ.MT)GO TO 300
	IF(COMMD.EQ.MU)GO TO 400
	IF(COMMD.EQ.EN)GO TO 2000
C
C
C.DON'T ALLOW CERTAIN COMMANS IF DEVICES ARE NOT READY
C
	IF(ICODE.LT.0)GO TO 45
	IF(COMMD.EQ.BO)GO TO 700
	IF(MRDY.EQ.-1)GO TO 45
C
C
C.BELOW COMMAND REQUIRE DEVICES TO BE READY
C
	IF(COMMD.EQ.PO)GO TO 500
	IF(COMMD.EQ.DI)GO TO 600
	IF(COMMD.EQ.ID)GO TO 800
	IF(COMMD.EQ.VE)GO TO 900
	IF(COMMD.EQ.CO)GO TO 1000
  44	WRITE(7,9040)
9040	FORMAT(/' ?DLU-W-Ambiguous Command. Type ? for Help')
	GO TO 10
  45	WRITE(7,9045)
9045	FORMAT(/' ?DLU-W-Device not ready')
	GO TO 44
C
C
C.?-SIMPLE INSTRUCTIONS
C
 50	WRITE(7,9050)
9050	FORMAT(/' DT	change disk type'/
     1	' DU	change disk unit'/
     2	' MT	change MT type'/
     3	' MU	change MT unit'/
     4	' DI	DLU MT directory'/
     5	' PO	position MT'/
     6	' CO	copy'/
     7	' VE	verify'/
     8	' ID	read MT ID'/
     9	' BO	boot disk'/
     1	' EN	end')
	GO TO 10
C
C
C.DT-DISK TYPE
C
 100	WRITE(7,9100)
9100	FORMAT(' Enter disk type: ',$)
	READ(5,9110)DTYPE
9110	FORMAT(A2)
	DUNIT=0
	IF(DTYPE.EQ.RL)GO TO 120
	IF(DTYPE.EQ.RK)GO TO 110
C	IF(DTYPE.EQ.DX)GO TO 130
	WRITE(7,9120)DTYPE
9120	FORMAT(' ?DLU-W-',A2,' is unsupported')
	DTYPE=RK
	GO TO 10
C
C
C	RK05
C
C
110	NTRAK=406
	IWCNT=3072
	IBLKCT=12
	DO 115 I=1,4
	DBLK(I)=RKBLK(I)
115	CONTINUE
	IZERO=DBLK(1)
	GO TO 10
C
C
C	RL01'S
C
C
120	NTRAK=511
	IWCNT=5120
	IBLKCT=20
	DO 125 I=1,4
	DBLK(I)=RLBLK(I)
125	CONTINUE
	IZERO=DBLK(1)
	GO TO 10
C
C
C	RX01 -- NEVER TESTED
C
C
130	GO TO 10
	NTRAK=74
	IWCNT=1
	IBLKCT=6
	GO TO 10
C
C
C.DU-DISK UNIT
C
 200	WRITE(7,9200)
9200	FORMAT(' Enter disk unit #: ',$)
	READ(5,9210)DUNIT
9210	FORMAT(I1)
	IF(DUNIT.LT.0.OR.DUNIT.GT.8)GO TO 200
	IF(DTYPE.EQ.RL.AND.DUNIT.GT.4)GO TO 200
	DBLK(1)=IZERO+DUNIT
	GO TO 10
C
C
C.MT-MAG TAPE TYPE
C
 300	WRITE(7,9300)
9300	FORMAT(' Enter # mag tape tracks: ',$)
	READ(5,9310)MTRACK
9310	FORMAT(I1)
	IF(MTRACK.NE.9.AND.MTRACK.NE.7)GO TO 300
320	WRITE(7,9320)
9320	FORMAT(' Enter mag tape density: ',$)
	READ(5,9340) MDENS
9340	FORMAT(I4)
	IF(MDENS.NE.800.AND.MDENS.NE.1600)GO TO 320
	IF(MTRACK.EQ.9)CALL L9
	IF(MTRACK.EQ.7)CALL CD7
	GO TO 10
C
C
C.MU-MAG TAPE UNIT
C
 400	WRITE(7,9400)
9400	FORMAT(' Enter mag tape unit #: ',$)
	READ(5,9410)MUNIT
9410	FORMAT(I1)
	IF(MUNIT.LT.0.OR.MUNIT.GT.8)GO TO 400
	GO TO 10
C
C
C.PO-POSITION MAGTAPE
C
500	CALL POS(MUNIT,MFILE)
	GO TO 10
C
C
C.DI-DIRECTORY
C
 600	WRITE(7,9600)DA
9600	FORMAT(//' Directory of a DLU magnetic tape: ',5A2)
	CALL CRWD(MUNIT)
	IDUM=0
610	CALL BFINP(MUNIT,BUFF,5120)
	IF(IEOF(MUNIT).LT.0)WRITE(7,9610)
9610	FORMAT(/' ?DLU-I-Double EOF')
	IF(LENGTH(BUFF).NE.36)GO TO 650
	IDUM=IDUM+1
	WRITE(7,9620)IDUM,(BUFF(I),I=1,36)
9620	FORMAT(/' File # ',I1,/' DISK = ',A2/1X,26A2/1X,9A2)
	CALL PTAPE(MUNIT,1,0)
	GO TO 610
650	CALL CRWD(MUNIT)
	MFILE=1
	GO TO 10
C
C
C.BO-BOOT DISK
C
 700	CONTINUE
	WRITE(7,9700)DTYPE,DUNIT
9700	FORMAT(' Ready to boot ',A2,I1/' Are you sure? ',$)
	READ(5,9710)IANS
9710	FORMAT(A2)
	IF(IANS.NE.YES)GO TO 10
C
C
C.OPEN THE DISK VIA RT-11 CHANNEL
C
	CALL OPENFL(DBLK,ICHAN,IERR)
	IF(IERR.LT.0)GO TO 10
	IERR=IREADW(512,BUFF,0,ICHAN)
	CALL CLOSFL(ICHAN)
	CALL BOOT(BUFF)
C
C
C.ID- READ MT ID RECORD
C
 800	CONTINUE
	CALL BFINP(MUNIT,BUFF,36)
	CALL PTAPE(MUNIT,0,-1)
	WRITE(7,9800)(BUFF(I),I=1,36)
9800	FORMAT(/' MT RECORD IS FOR DISK TYPE = ',A2/
     1	1X,35A2)
	GO TO 10
C
C
C.VE-VERIFY DISK
C
 900	CONTINUE
	CALL POS(MUNIT,MFILE)
C
C
C.GET MT FILE ID
C
	CALL BFINP(MUNIT,BUFF,36)
	CALL PTAPE(MUNIT,0,-1)
901	WRITE(7,91060)(BUFF(I),I=1,36)
	READ(5,91065)IANS
	IF(IANS.EQ.NO)GO TO 10
	IF(IANS.NE.YES)GO TO 901
	IF(BUFF(1).EQ.DTYPE)GO TO 905
	WRITE(7,91066)
	READ(5,91067)IANS
	IF(IANS.NE.YES)GO TO 10
 905	CALL PTAPE(MUNIT,0,1)
C
C
C.OPEN THE DISK VIA RT-11 CHANNEL
C
	CALL OPENFL(DBLK,ICHAN,IERR)
	IF(IERR.LT.0)GO TO 10
C
C
C.READ TAPE AND DISK AND VERIFY
C
	IBLK=0
	DO 910 I=1,NTRAK
	IERR=IREADW(IWCNT,BUFF,IBLK,ICHAN)
	IF(IERR.LT.0)GO TO 950
	IBLK=IBLK+IBLKCT
	CALL BFINP(MUNIT,BUFF2,IWCNT)
	IF(IEOF(MUNIT).LT.0)GO TO 950
	DO 920 J=1,IWCNT
	IF(BUFF(J).EQ.BUFF2(J))GO TO 920
	WRITE(7,9915)I,J
 9915	FORMAT(' ?DLU-W-Verify error starting on track ',I3,', word ',I4)
	GO TO 910
 920 	CONTINUE
 910	CONTINUE
	CALL PTAPE(MUNIT,0,1)
 950	I=I-1
	WRITE(7,9950)I
 9950	FORMAT(' ?DLU-I-Verified ',I3,' tracks')
	MFILE=MFILE+1
	CALL CLOSFL(ICHAN)
	GO TO 10
C
C
C.CO-COPY COMMAND
C
 1000	WRITE(7,91000)
91000	FORMAT(' Copy from: ',$)
	READ(5,91010) IANS
91010	FORMAT(A2)
	IF(IANS.EQ.DI)GO TO 1010
	IF(IANS.EQ.MT)GO TO 1050
	WRITE(7,91020)
91020	FORMAT(/' ?DLU-W-Ambiguous device; try MT or DISK')
	GO TO 1000
C
C
C.COPY DISK TO MT
C
 1010	IF(IRING(MUNIT).LT.0)GO TO 1011
	WRITE(7,91011)
91011	FORMAT(/' ?DLU-W-No write ring on mag tape')
	GO TO 10
 1011	CALL POS(MUNIT,MFILE)
C
C
C.OPEN THE DISK VIA RT-11 CHANNEL
C
	CALL OPENFL(DBLK,ICHAN,IERR)
	IF(IERR.LT.0)GO TO 10
C
C
C.GET ID INFO
C
	WRITE(7,91012)
91012	FORMAT(' Type in a MT file ID. DLU will add date and time.'/
     1	' Please be descriptive as possible:')
	DO 1020	I=1,36
	BUFF(I)=2H  
 1020	CONTINUE
	READ(5,91025)(BUFF(I),I=2,26)
91025	FORMAT(26A2)
	CALL TIME(TI)
	DO 1025 I=1,4
	BUFF(I+27)=DA(I)
	BUFF(I+32)=TI(I)
1025	CONTINUE
	BUFF(32)=DA(5)
	BUFF(1)=DTYPE
	CALL BFOUT(MUNIT,BUFF,36)
C
C
C.READ THE DISK AND WRITE TO TAPE
C
	IBLK=0
	DO 1030 I=1,NTRAK
	IERR=IREADW(IWCNT,BUFF,IBLK,ICHAN)
	IF(IERR.LT.0) WRITE(7,91030)IERR
91030	FORMAT(' ?DLU-W-Error code = ',I5)
	IF(IERR.LT.0)GO TO 1035
	IBLK=IBLK+IBLKCT
	CALL BFOUT(MUNIT,BUFF,IWCNT)
 1030	CONTINUE
C
C
C.CLOSE DISK AND TAPE
C
 1035	I=I-1
	CALL CLOSFL(ICHAN)
	WRITE(7,91035)I
91035	FORMAT(/' ?DLU-I-Disk had ',I3,' good tracks')
	CALL EFILE(MUNIT)
	CALL EFILE(MUNIT)
	CALL PTAPE(MUNIT,0,-1)
	MFILE=MFILE+1
	GO TO 10
C
C
C.MAG TAPE TO DISK COPY
C
 1050	CONTINUE
	IF(ICODE.EQ.1)WRITE(7,91050)
91050	FORMAT(' ?DLU-W-Disk write protected')
	IF(ICODE.EQ.1)GO TO 10
	CALL POS(MUNIT,MFILE)
C
C
C.GET MT FILE ID
C
	CALL BFINP(MUNIT,BUFF,36)
	CALL PTAPE(MUNIT,0,-1)
 1060	WRITE(7,91060)(BUFF(I),I=1,36)
91060	FORMAT(' DISK TYPE=',A2/1X,35A2/' Is this the correct file? ',$)
	READ(5,91065)IANS
91065	FORMAT(A2)
	IF(IANS.EQ.NO)GO TO 10
	IF(IANS.NE.YES)GO TO 1060
	IF(BUFF(1).EQ.DTYPE)GO TO 1069
	WRITE(7,91066)
91066	FORMAT(/' ?DLU-W-Posible incompatability on target device'/
     1	' Do you wish to proceed? ',$)
	READ(5,91067)IANS
91067	FORMAT(A2)
	IF(IANS.NE.YES)GO TO 10
C
C
C.OPEN THE DISK VIA RT-11 CHANNEL
C
 1069	CALL PTAPE(MUNIT,0,1)
	CALL OPENFL(DBLK,ICHAN,IERR)
	IF(IERR.LT.0)GO TO 10
C
C
C.COPY TAPE TO DISK
C
	IBLK=0
	DO 1070 I=1,NTRAK
	CALL BFINP(MUNIT,BUFF,IWCNT)
	IF(IEOF(MUNIT).LT.0)GO TO 1075
	IERR=IWRITW(IWCNT,BUFF,IBLK,ICHAN)
	IF(IERR.LT.0)GO TO 1075
	IBLK=IBLK+IBLKCT
 1070	CONTINUE
	CALL PTAPE(MUNIT,1,0)		!SKIP TO NEXT FILE
 1075	I=I-1
	WRITE(7,91075)I
91075	FORMAT(/'?DLU-I-',I3,' good tracks written to disk')
	MFILE=MFILE+1
	CALL CLOSFL(ICHAN)
	GO TO 10
C
C
C.EN-END OF SESSION
C
 2000	IF(MRDY.NE.-1)CALL RWDNW(MUNIT)
	STOP 'DLU'
	END
C
C
	SUBROUTINE POS(MUNIT,MFILE)
C
C ROUTINE TO POSITION TAPE
C
 500	WRITE(7,9500)
9500	FORMAT(' Enter desired MT file number: ',$)
	READ(5,9510)IFILE
9510	FORMAT(I1)
	IF(IFILE.LE.0)GO TO 500
C
C
C.TELL OPERATOR WHAT WE'RE DOING
C
	WRITE(7,9000)MUNIT,IFILE
9000	FORMAT(' ?DLU-I-Positioning tape # ',I1,' to file # ',I1)
C
C
C.LET'S DO IT
C
	IF(IFILE.EQ.1)GO TO 510
	IDUM=IFILE-MFILE
	IF(IDUM.EQ.0)RETURN
	IF(IDUM.LT.0)GO TO 520
	CALL PTAPE(MUNIT,IDUM,0)
	MFILE=IFILE
	RETURN
510	CALL CRWD(MUNIT)
	MFILE=1
	RETURN
520	IF(-IDUM.GT.IFILE)GO TO 530
	IDUM=IDUM-1
	CALL PTAPE(MUNIT,IDUM,0)
	MFILE=IFILE
	RETURN
530	CALL CRWD(MUNIT)
	IDUM=IFILE-1
	CALL PTAPE(MUNIT,IDUM,0)
	MFILE=IFILE
	RETURN
	END
C
	SUBROUTINE CRWD(MUNIT)
C
C ROUTINE TO OUT INFO MESSAGE AND REWIND TAPE
C
	WRITE(7,9000)MUNIT
9000	FORMAT(' ?DLU-I-Rewinding mag tape ',I1)
	CALL RWD(MUNIT)
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                