


PROCEDURE BuildDir(DeviceName:String6;VAR ListPtr:FileSpecRecordPtr);


CONST
	SequentialAccess	=100000B;
	HomeBlock		=1;
	StartOfDirectory	=6;
		{The file attributes}
	TentativeFile		=   400B;
	EmptyFile		=  1000B;
	PermanentFile		=  2000B;
	EndOfSegment		=  4000B;
	ProtectedpermanentFile	=102000B;

TYPE


	OneByte		= CHAR;

	ElementOfDirRecord = RECORD
	    CASE FileStatus	:INTEGER OF

		PermanentFile,
		ProtectedpermanentFile:
		   (FileName	 :Array[1..3] OF Radix50;
		    FilesLength,
		    ChannelNumber,
		    CreationDate :INTEGER);

		{EndOfSegment,
		TentativeFile,
		EmptyFile	:();}
				END {RECORD};

	DirRecord		=RECORD
	      CASE INTEGER OF
		1:
		  (ReservedBlock:ARRAY[0..511] OF OneByte;
		  {Home Block!!!!}
		  BadBlockReplacementTable
				:ARRAY[1..201B] OF OneByte;
		   BlankWord1	:INTEGER;
		   InitRestoreDataArea
				:ARRAY[204B..251B] OF OneByte;
		   FreeSpace	:ARRAY[252B..677B] OF OneByte;
		   VRTRad50,
		   BlockNumberOf1stUserFile
				:INTEGER;
		   FreeSpace2	:ARRAY[704B..721B] OF OneByte;
		   PackClusterSize,
		   SystemVersion:INTEGER;
		   VolumeID,
		   OwnersName,
		   SystemID	:String12;
		   BlankWord2,
		   Checksum	:INTEGER);

		2:
		  {Dir segment structure}
		  (NumberOfSegments,
		   LinkToNextSegment,
		   HighestSegmentInUse:INTEGER;
		   CASE NumberExtraBytesInElementOfDirs
				:INTEGER OF
		     0:(StartBlockOfStoredData
				:INTEGER;

			Entry:ARRAY[1..72] OF 
					  ElementOfDirRecord;
			   Unused1,
			   Filestatus,
			   Unused2,Unused3,Unused4,Unused5
				:OneByte));

			END {RECORD};
VAR	DeviceDir:RECORD
	    CASE INTEGER OF
		1:(f:FILE OF DirRecord);
		2:(pointer:^DirRecord; {To access file control info}
		   mode,
		   Blocknumber,
		   Buffer,
		   WordCount,
		   WaitFlag,
		   IOStatus:INTEGER)
		END;
	HighSegment:INTEGER;
	i,size	:INTEGER;
	ElementPtr:FileSpecRecordPtr;
	EndofDir:BOOLEAN;



PROCEDURE  LinkElement(VAR ElementPtr,ListPtr:FileSpecRecordPtr);

VAR	WeveArrived:BOOLEAN;


BEGIN
    WeveArrived:=FALSE;
    IF ListPtr#NIL THEN		BEGIN
	{DEBUG
	   IF Options[SortAlpha] THEN WRITELN('LinkEl-I-Sort by Alpha')
				ELSE  WRITELN('LinkEl-I-Sort by Type');
		}
	IF Options[SortAlpha] 
	THEN   weveArrived :=
			(ElementPtr^.FileName.All
				  <ListPtr^.FileName.All)
	ELSE 	IF ElementPtr^.FileName.extension
			<ListPtr^.FileName.extension
		THEN WeveArrived:=TRUE
		ELSE IF ElementPtr^.FileName.extension
			      =ListPtr^.FileName.extension
		     THEN weveArrived :=
				(ElementPtr^.FileName.Name
				      <ListPtr^.FileName.Name);

	IF WeveArrived THEN			BEGIN
	    ElementPtr^.NextEntry:=ListPtr;
	    Listptr:=ElementPtr;
	    END
	ELSE LinkElement(ElementPtr,ListPtr^.NextEntry);
	END
    ELSE ListPtr:=ElementPtr;
END;




FUNCTION Decode(Entry:ElementOfDirRecord):FileSpecRecordPtr;


PROCEDURE R50ASC( VAR inputPtr:RadixString3;
		  VAR output:String9;
		 NumberOfChars:INTEGER);EXTERNAL;



BEGIN
	NEW(TempPtr);
{debug	WRITELN('calling r50asc');}
	R50ASC(Entry.FileName,
		  TempPtr^.FileName.All,
		  9);
	IF Entry.CreationDate # 0 THEN
	    TempPtr^.DateCreated := Entry.CreationDate
	ELSE TempPtr^.DateCreated := -1;
	TempPtr^.DateOtherFileCreated := 0;
	Decode:= TempPtr;
END;


BEGIN{BuildDir}
{$A-}
{Turn off array bounds checking to access eoseg word
 after 72nd entry}
   size := SequentialAccess;
   RESET( DeviceDir.f, DeviceName, '   ', Size );
   IF size>=0    THEN					BEGIN
{     IF VolumeID THEN ProcessVolumeID;*/
      Devicedir.BlockNumber := StartOfDirectory;
      GET( DeviceDir.f );
      HighSegment:=DeviceDir.F^.HighestSegmentInUse;
      EndofDir:=FALSE;
      WHILE NOT endofDir DO		 BEGIN
	I:=1;
	WHILE (i<=72) AND (DeviceDir.F^.entry[i].FileStatus # EndOfSegment) 
		DO					BEGIN
	   IF (DeviceDir.F^.Entry[i].FileStatus = permanentFile ) OR
 	      (DeviceDir.F^.Entry[i].FileStatus = ProtectedPermanentFile)
 	    THEN					BEGIN
	       ElementPtr := Decode(DeviceDir.F^.Entry[i]);
	       LinkElement(Elementptr,ListPtr);
	       END;
           i:=i+1;
	   END;
	IF DeviceDir.F^.LinkToNextSegment=0
	THEN	endofDir:=TRUE
	ELSE					BEGIN
		DeviceDir.Blocknumber:=(StartOfDirectory-2)
					+(DeviceDir.f^.LinkToNextSegment*2);
		GET(DeviceDir.f);
		END;
	END;
      CLOSE(DeviceDir.F);
      END
{   ELSE  WRITE('Error in RESET of   ',Devicename);}
END;

BEGIN
END.

                                                                                                   