	subroutine MSGPRT (NINICC, MESSAG, LENMSG, NUMBER, LENNUM, 
	1 NENDCC, VIDATR, BEEP)
c
c	This routine will take a message string and print it,
c	providing carriage returns before and after the string,
c	as desired.
c	If LENMSG is 0, the string MESSAG must be terminated in 
c	the calling routine by a $.
c	If LENNUM is nonzero, the number NUMBER will be appended
c	to the MESSAG string, occupying LENNUM positions.
c	NINICC and NENDCC are the number of CRLF's you want typed - 
c	not the standard Fortran carriage control symbols.
c	VIDATR is video attributes for the message.  In the calling
c	routine VIDATR should be a string terminated by a blank.
c	Thus, for BOLD and BLINK, VIDATR would look like '1;5 ';
c	for no attributes, use a '0 '.
c	If BEEP is nonzero, the string will also include a ^G.
c
c		Written by:
c		R. W. Barnard
c		BIO/COMP Applications
c		P. O. Box 5342
c		Albuquerque, NM 87185
c		Version 1.0,	8-Jan-87.
c
	integer*2 NINICC, NENDCC, BEEP
	character*8 CNUM		!Maximum allowable field length for 
	byte MESSAG(1), VIDATR(1)
	byte LOCAL(96), ATTR(4), BNUM(8)	!appended number is 8!!
c
	data ATTR /27, '[', '0', 'm'/
c
	equivalence (CNUM, BNUM(1))
c
	external INDEX
c
	LENATR= INDEX (VIDATR, ' ')- 1		!Find out how many attributes.
	if (LENATR.ne.0 .and. VIDATR(1).ne.'0') then	!We have attributes.
	  LOCAL(1)= ATTR(1)			!Get the ESC and [.
	  LOCAL(2)= ATTR(2)
	  do 10 K= 1, LENATR
	    LOCAL(K+2)= VIDATR(K)		!Get the attributes.
10	  continue
	  J= LENATR+ 3
	  LOCAL(J)= ATTR(4)			!Add the 'm'.
	else
	  J= 0					!Start at the beginning.
	endif
c
	if (LENMSG.eq.0) then
	  LENSTR= INDEX (MESSAG, '$')- 1
	else
	  LENSTR= LENMSG
	endif
	do 20 K= 1, LENSTR
	  I= J+ K
	  LOCAL(I)= MESSAG(K)			!Move the message.
20	continue
c
	J= J+ LENSTR	  
	if (J.ne.0) then			!We have attributes.
	  do 30 K= 1, 4
	    I= J+ K
	    LOCAL(I)= ATTR(K)			!Turn off attributes.
30	  continue
	  J= J+ 4
	endif
c
	if (LENNUM.ne.0) then			!Now append the number.
	  write (CNUM, 100) NUMBER		!Need to convert to
	  do 40 K= 1, LENNUM			!ASCII and copy to
	    I= J+ K				!local array.
	    LOCAL(I)= BNUM(K)
40	  continue
	  J= J+ LENNUM
	endif
c
	if (BEEP.ne.0) then
	  LOCAL(J+1)= 7
	  LOCAL(J+2)= '200'O			!No terminating CRLF.
	else
	  LOCAL(J+1)= '200'O
	endif
c
	do 50 K= 1, NINICC			!Do initial CRLF's.
	  call CRLF
50	continue
	call PRINT (LOCAL)			!Print the string.
	do 60 K= 1, NENDCC			!Do ending CRLF's.
	  call CRLF
60	continue
	return
c
100	format (I<LENNUM>)
	end	
	subroutine ASCRAD (ASCFIL, IRADBK)
c
c	Converts a filespec string written by PARSE into RAD-50
c	words for use by SYSLIB routines.
c	The sizes of ASCFIL and IRADBK are specified in the calling
c	program.
c
	integer*2 IRADBK(1)
	byte ASCFIL(1)
c
	external INDEX
c
	N= IRAD50 (3, ASCFIL(1), IRADBK(1))	!Convert for 3 chars, or
	I= N+ 2					!until you hit the :
	NDX= INDEX (ASCFIL(I), '.')- 1		!Find the . in file name.
	N= IRAD50 (NDX, ASCFIL(I), IRADBK(2))	!Convert from next char for
	I= I+ N+ 1				!6 chars or until you hit .
	N= IRAD50 (3, ASCFIL(I), IRADBK(4))	!Do the last 3.
	return
c
	end
                                                                                                                                                                                                                                                                                                                                                                                                