c	Initialise the internal variables prior to setting up a screen

	subroutine	NEWSCR()
c	Assume all fields are character: default

	include		'SCRLIB.INC'
	common		/newzzz/fresh
	logical*1	fresh
	data		fresh/.true./

	if(fresh)then					!Intercept these:
	  call errset(55,.true.,.false.,.true.,.false.,) !'O/P Convsn Error'
	  call errset(56,.true.,.false.,.true.,.false.,) !'I/P Convsn Error'
	  fresh=.false.
	endif

	ind=0
	maxind=0
	changd=.false.
	do 10 i=1,40
	  ix(i)=0
	  iy(i)=0
	  L(i)=0
	  LDP(i)=0
	  nvar(i)=0
	  fvar(i)=0.0
	  intf(i)=.false.
	  realf(i)=.false.
10	continue

	return
	end

c	PUTx routines transfer data from the user to the internal screen
c	 manager. The data is displayed and editied by the EDITIT routine
c	 above. The data is retrieved by the MATCHING (in type and order)
c	 GETx routines.
c	As an extra convenience the user specifies the format to be used
c	 in the display for each variable.

	subroutine	PUTC(ixc,iyc,string,formt)
c	Character string
c	formt MUST be of the form '(An)' or '(Ann)', where 0<N<=40
c	Note that N = data base string length, but only N-1
c	 characters are usable: the last one has to be the '|' to terminate
c	 the string (thanks be to RSX Fortran designers - yuk!)

	include		'SCRLIB.INC'
	character*42	string		!A bit of a safety margin: +2
	character*10	formt

	ind=ind+1
	maxind=ind		!Field counters
	ll=length(string)
	field(ind)(1:ll)=string(1:ll)	!Put string in table
	ix(ind)=ixc		!Put position in table
	iy(ind)=iyc
	frmt(ind)=formt		!Put format in table
	if(formt(4:4).eq.')')then
	  read(formt,1000,err=20) j
1000	  format(2x,I1)		!2x skips the (C
	elseif(formt(5:5).eq.')')then
	  read(formt,1010,err=20) j
1010	  format(2x,I2)
	else
	  goto 20
	endif
	L(ind)=j-1		!Put string length in table, one less!
	do 10 i=ll+1,j-1
	  field(ind)(i:i)=' '	!Optional pad out of string
10	continue
	field(ind)(j:j)='|'

	return

20	call goXY(1,24)
	type 1020,bell,formt
1020	format('+',A,'PUTC-F-Invalid format  ',A,$)
	call exit()
	end

	subroutine	PUTCD(jx,jy,text,formt,ll)
c	Same as PUTC but for a character variable without the '|'
c	It is assumed that the variable is padded with spaces to the 
c	 given length LL
c	Formt is declared here to pass it thru'

	include		'SCRLIB.INC'
	character*40	text
	character*42	string
	character*10	formt

	if(ll.gt.40)goto 100
	call scopy(text,string,ll)	!Copy the given length
	string(ll+1:ll+1)='|'		!Put in the terminator
	call putC(jx,jy,string,formt)
	return

100	call goXY(1,24)
	type 1000,bell,text
1000	format('+',a,'PUTCD-F-String too long: ',a,$)
	stop 'PUTCD length'
	end


	subroutine	PUTB(ixn,iyn,byt,formt)
c	byt is a byte variable
c	formt should be of the form '(O3)' but it doesn't matter

	byte		byt
	integer*2	ixn,iyn
	integer*4	J
	character*8	formt
	character*4	form
	data		form/'(O3)'/

	J=byt				!Convert I*1 to I*4
	j=j.and."377
	call putJ(ixn,iyn,J,form)

	return
	end


	subroutine	putI(ixn,iyn,I,formt)
c	I is I*2
c	formt MUST be of the form '(In)' or '(Inn)', where 0<N<12

	integer*2	ixn,iyn,I
	integer*4	J
	character*8	formt

	J=I				!Convert I*2 to I*4
	call putJ(ixn,iyn,J,formt)

	return
	end


	subroutine	putJ(ixn,iyn,JJ,formt)
c	JJ is I*4
c	formt MUST be of the form '(In)' or '(Inn)', where 0<N<12

	include		'SCRLIB.INC'
	character*42	string
	character*8	formt
	integer*4	J,JJ
	integer*2	I

	J=JJ			!Local save in case of errors
	ind=ind+1
	maxind=ind
	write(field(ind),formt,err=20) J
10	ix(ind)=ixn
	iy(ind)=iyn
	intf(ind)=.true.
	nvar(ind)=J
	frmt(ind)=formt
	if(formt(4:4).eq.')')then
	  read(formt,1000,err=30) i
1000	format(2x,I1)
	elseif(formt(5:5).eq.')')then
	  read(formt,1010,err=30) i
1010	  format(2x,I2)
	else
	  goto 30
	endif
	L(ind)=i
	LDP(ind)=0
	field(ind)(i+1:i+1)='|'

	return

20	call goXY(1,24)
	type 1020,J
1020	format('+','PUTJ-F-Variable too big for format: ',I,$)
	J=0
	write(field(ind),formt,err=30) J
	goto 10

30	call goXY(1,24)
	type 1030,formt
1030	format('+','PUTJ-F-Invalid format  ',A,$)
	call exit()
	end


	subroutine	putF(ixn,iyn,FF,formt)
c	Real*4 variable FF
c	formt MUST be of the form '(Fa.b)' or '(Faa.b)',
c	 where 1<a<12 and 0<b<9 and b<a-1 (or whatever)

	include		'SCRLIB.INC'
	character*10	formt
	real*4		F,FF

	F=FF			!Local save in case of errors
	ind=ind+1
	maxind=ind
	write(field(ind),formt,err=20) F
10	ix(ind)=ixn
	iy(ind)=iyn
	realf(ind)=.true.
	fvar(ind)=F
	frmt(ind)=formt
	if(formt(6:6).eq.')')then
	  read(formt,1000,err=30) j,k
1000	  format(2x,I1,x,I1)
	elseif(formt(7:7).eq.')')then
	  read(formt,1010,err=30) j,k
1010	  format(2x,I2,x,I1)
	else
	  goto 30
	endif
	L(ind)=j		!Total number of digits
	LDP(ind)=k		!Digits after the DP
	field(ind)(j+1:j+1)='|'

	return

20	call goXY(1,24)
	type 1020,F
1020	format('+','PUTF-F-Variable too big for format: ',F,$)
	F=0.0
	write(field(ind),formt,err=30) F
	goto 10

30	call goXY(1,24)
	type 1030,bell,formt
1030	format('+',A,'PUTF-F-Invalid format  ',A,$)
	call exit()
	end


	subroutine	PutLF(ixn,iyn,flag)
c	Logical flags, represented by T or F

	include		'SCRLIB.INC'
	logical*1	flag
	integer*2	ixn,iyn

	ind=ind+1
	maxind=ind

	if(flag)then
	  field(ind)='T|'
	else
	  field(ind)='F|'
	endif

	ix(ind)=ixn
	iy(ind)=iyn
	L(ind)=1
	frmt(ind)='A1'

	return
	end

	subroutine	getC(string)
c	Matches PUTC

	include		'SCRLIB.INC'
	character*42	string

	ind=ind+1
	if(intf(ind).or.realf(ind))goto 30
	j=L(ind)		!Nominal format length of string
	string(1:j)=field(ind)(1:j)	!Copy over only that much string
	do 10 i=j,1,-1		!Find effective end of string
	  if(string(i:i).gt.' ')goto 20
10	continue
	i=1			!Oops: string was deleted to blank
	string(1:1)=' '		!We'll have a single blank in it
20	string(i+1:i+1)='|'	!Put in terminating <|>
	return

30	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETC-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end

	subroutine	getCD(text)

	include		'SCRLIB.INC'
	character*40	text

	ind=ind+1
	if(intf(ind).or.realf(ind))goto 30
	j=L(ind)			!User supplied length of TEXT
	text(1:j)=field(ind)(1:j)	!Copy over that much text
	return

30	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETCD-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end


	subroutine	getB(B)
c	Matches PUTB

	include		'SCRLIB.INC'
	integer*4	J
	byte		B

	ind=ind+1
	if(.not.intf(ind))goto 10
	J=nvar(ind)
	J=J.and."377
	B=J
	return

10	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETB-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end


	subroutine	getI(I)
c	Matches PUTI

	include		'SCRLIB.INC'
	integer*4	J
	integer*2	I

	ind=ind+1
	if(.not.intf(ind))goto 10
	J=nvar(ind)
	J=J.and."177777
	I=J
	return

10	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETI-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end


	subroutine	getJ(J)
c	Matches PUTJ

	include		'SCRLIB.INC'
	integer*4	J

	ind=ind+1
	if(.not.intf(ind))goto 10
	J=nvar(ind)
	return

10	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETJ-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end


	subroutine	getF(F)
c	Matches PUTF

	include		'SCRLIB.INC'

	ind=ind+1
	if(.not.realf(ind))goto 10
	F=fvar(ind)
	return

10	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETF-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end


	subroutine	GetLF(flag)
c	Matches PUTLF

	include		'SCRLIB.INC'
	logical*1	flag
	character*1	fred

	ind=ind+1
	if(intf(ind).or.realf(ind))goto 10
	fred=field(ind)(1:1)

	if(fred.eq.'t'.or.fred.eq.'T')then
	  flag=.true.
	else
	  flag=.false.
	endif
	return

10	call goXY(1,24)
	type 1000,bel,ind
1000	format('+',A,'GETLF-F-Order of GET commands incorrect at ',I2,$)
	call exit()
	end

c	Special format Date routines

	subroutine	PutDat(ix,iy,day,month,year)
c	Put up the date in editable format

	integer*2	ix,iy,day,month,year


	call putI(ix,iy,day,'(I2)')
	type 1000
1000	format('+','/',$)
	call putI(ix+3,iy,month,'(I2)')
	type 1000
	call putI(ix+6,iy,year,'(I2)')

	return
	end

	subroutine	GetDat(day,month,year)
c	Matches PUTDAT

	integer*2	day,month,year

	call getI(day)
	call getI(month)
	call getI(year)

	return
	end
	subroutine	EraseS(x,y)
c	Go to (x,y) and erase rest of screen

	integer*2	x,y
	include		'SCRLIB.INC'

	call goxy(x,y)
	type 1000,esc
1000	format(x,A,'[0J',$)

	return
	end


	subroutine	EraseR(x,y)
c	Go to (x,y) and erase rest of Row

	include		'SCRLIB.INC'
	integer*2	x,y

	call goXY(x,y)
	type 1000,esc
1000	format(x,A,'[0K',$)

	return
	end
                                                                                                                                                                                                                                                                                                                                     