	Program SPIRAL
c
c	Author: R N Caffin
c
c	Test routine for Plotter, HVPLOT Library and, optionally, PL Handler
c	Draws a labelled axis and a double spiral.
c
C	4-may-88 slight modifications to allow for colour on vt screens
c
	real	x(1050),y(1050)
	byte	string(80),dummy(8),help(80)
	real*8 ddummy
	equivalence (ddummy,dummy(1))
	real*8 plotter,tttype
	integer colour
	common /ttid/tttype,color
	common/plotid/plotter,sclx,scly
	common/zzhv/hv,plonsw,flh,flv,flsh,flsv
	byte hv,plonsw,flh,flv,flsh,flsv
	INTEGER HP,TT
	COMMON/HPTTNO/HP,TT
	DATA HP/20/
	DATA TT/12/
	integer q
	common/TEMP/q
	data q/0/
C	ASSIGN 'TT' TO TT: (INTERACTIVE DEVICE).
	CALL ASSIGN (TT,'TT:',3)

350	WRITE(TT,1000)
1000	format(x,'What size steps in spiral (1-20)?:',$)
	READ(TT,1020,END=999)istep
1020	FORMAT(I5)
	if(istep.lt.1.or.istep.gt.20)goto 350
c	Calculate the spiral
	lim=1021
	do 100 j=1,lim
	  x(j)=(0.01*j)*sin(0.02*j)
	  y(j)=(0.01*j)*cos(0.02*j)
100	  continue

c	Initialise the system

	call init()			!Basic set-up and select device
	if (q.ne.0) goto 999
	IF ((FLH.EQ..FALSE.).AND.(FLV.EQ..FALSE.))GOTO 999
	CALL PLON(1)			! CHOOSE PEN AND TURN PLOTTER ON
	IF ((PLONSW.EQ..FALSE.).AND.(HV.EQ..FALSE.)) GOTO 999
	if (hv)CALL VTCLR
	CALL SETLTS
	call scale(-12.,+12.,-12.,+12.)	!Set up the scale

c	Draw the axis and write the big labels

	call axis(0.,0.,2.,2.)
	call select(2)
	call labexy(-1.2,5.,0.2,90.,'Y Axis')
	call labexy(5.,-1.5,0.2,00.,'X Axis')
	call select(3)			!Choose pen
	if (hv) goto 10
		ddummy=plotter
		dummy(8)=0
		call trim(dummy)
	goto 20
10		ddummy=tttype
		dummy(8)=0
		call trim(dummy)
20	call concat(dummy,' Test Plot',string)
	call text(1.,10.5,0.2,0.,string)
	call text(-11.5,-9.0,0.2,0.,'R N Caffin & S L Hewett')
	call text(-11.5,-10.0,0.2,0.,'C S I R O Textile Physics')
	call select(4)			!Choose pen
	call text(-11.5,+11.0,0.2,0.0,'Step Size:')
c	call jump(-10.0,+10.0)
	step=0.02*float(istep)
	encode(6,1010,string) step
1010	format(F6.3)
	string(7)=0
	call label(string)
	call label(' radians')

c	Label X axis
	call select(5)			!Choose pen
	call size(0.15,0.22)
	do 200 i=-10,10,2
	  call jump(float(i),-0.5)
	  if(i.ne.0)call labeln(i)
200	  continue
	call select(6)			!Choose pen
c	Label Y axis

	do 300 i=-10,10,2
	  call jump(-0.8,float(i))
	  if(i.ne.0)call labeln(i)
300	  continue

c	Change pen

	call select(7)

c	Plot the double spiral

	call jump(x(lim),y(lim))
	do 400 j=lim,1,-istep
	  call draw(x(j),y(j))
400	  continue
	do 410 j=1,lim,istep
	  call draw(-x(j),-y(j))
410	  continue
c	Clean up

420	call home			!Return pen to holder and eject paper
	call check()			!Check for errors
	call ploff			!Disable the plotter

999	write(tt,2000)
2000	format(x)
	CALL EXIT
	end
                                                                                                                                                                                                                                                    