      subroutine PARSE (tchar,mxchr,nchar)
c
c     rearranges the characters in a title so that no more than one space
c     separates words, and returns the total number of characters up to
c     the last non-space. The parameter nchar must be supplied when the
c     routine is called; it should be minimised by prior use of 'len'.
c
c     An obvious improvement on this routine would be one with adjustable
c     dimensions for tchr as well, removing the restriction of 40 chars.
c     on the compressed title, but tchr would then have to appear
c     in the argument list.
c
      logical*1 tchar(mxchr),tchr(40)
      ichr=0
c
c     reduce the no. of characters by any trailing spaces
      nchr=nchar
      do 10 ichar=nchar,1,-1
      if (tchar(ichar).ne.' ') go to 11
      nchr=nchr-1
10    continue
c
c     delete leading spaces & shrink any spaces longer than one character
11    do 20 ichar=1,nchr
      if ((ichar.eq.1).and.(tchar(ichar).eq.' ')) go to 20
      if (ichar.eq.1) go to 15
      if ((tchar(ichar).eq.' ').and.(tchar(ichar-1).eq.' ')) go to 20
15    ichr=ichr+1
      tchr(ichr)=tchar(ichar)
20    continue
c
c     return the compressed title and the no. of characters
      nchar=ichr
      do 30 ichar=1,nchar
30    tchar(ichar)=tchr(ichar)
      do 40 ichar=nchar+1,mxchr
40    tchar(ichar)=0
      return
      end
                                                                                                                                                        