c---------------------------------------------------------------------
c
c		copyright (c) 1986 by
c		the Bone and Calcium Research Laboratory
c		c/o Metabolic Unit
c		Repatriation General Hospital
c		Concord NSW  2139
c		Australia
c
c	This software is furnished under license and may be used
c	and copied only in accordance with the terms of such
c	license and only with the inclusion of the above copyright
c	notice.  This software or any other copies thereof may be
c	provided or otherwise made available to any other person.
c	No title to and ownership of the software is hereby
c	transferred.
c
c	Support in the implementation or advice in the usage of
c	the software cannot be offered by BCRL.  Criticism and
c	comments are nevertheless welcomed.
c
c	The BCRL assumes no responsibility for the use, reliability
c	or any damage of any nature which may result from the use
c	of this software.
c
c---------------------------------------------------------------------
c---------------------------------------------------------------------
c
c	NAME
c		graph.for
c
c	USAGE
c		ru[n] graph
c
c	ABSTRACT
c		This program read co-ordinate data from ascii data
c	files then does scatter plots of the data.  The program uses
c	algorithms to choose 'nice' scales for the axes and also
c	includes error bars.
c
c	INPUT
c		xdat - abscissa vector of length 100.
c		xerr - x error vector of length 100.
c		ydat - ordinate vector of length 100.
c		yerr - y error vector of length 100.
c		xlabel - ascii array
c		ylabel - ascii array
c
c		common /limit/xmin,xmax,ymin,ymax
c		common /zzhv/hv,plonsw,flh,flv
c
c	OUTPUT
c		A graph on the screen or plotter.
c
c	AUTHOR
c		SYP Wong		Jul 86
c
c	EDITS
c
c---------------------------------------------------------------------
	program graph

	byte xlabel(82),ylabel(82)
	byte datfil(15)
	logical*1 err
	integer*2 i,ndata,ntype
	real xdat(100),xerr(100),xmin,xmax,xtic,xwin
	real ydat(100),yerr(100),ymin,ymax,ytic,ywin
	real penv

	common /limit/xmin,xmax,ymin,ymax

	byte hv,plonsw,flh,flv
	common /zzhv/hv,plonsw,flh,flv

c*********************************************************************
c		get data file name and read data
c*********************************************************************
	call filnam(1,datfil,'dat')
	open (unit=2,name=datfil,type='OLD',readonly)
	read (2,5)(xlabel(i),i=1,80)
	read (2,5)(ylabel(i),i=1,80)
5	format (80a1)
	call trim(xlabel)
	call trim(ylabel)

	do 10 i=1,100
	  read (2,*,end=20) xdat(i),xerr(i),ydat(i),yerr(i)
10	  continue

20	close (unit=2)
	ndata=i-1
c*********************************************************************
c		massage data before plotting
c*********************************************************************
c
c***		special code since library functions can't accept
c		implied do loops

	xmin=1.0E30
	xmax=-1.0E30
	ymin=1.0E30
	ymax=-1.0E30

	do 30 i=1,ndata
	  if (xdat(i).lt.xmin) xmin=xdat(i)
	  if (xdat(i).gt.xmax) xmax=xdat(i)
	  if (ydat(i).lt.ymin) ymin=ydat(i)
	  if (ydat(i).gt.ymax) ymax=ydat(i)
30	  continue

	call autosc(xmin,xmax,xtic)
	call autosc(ymin,ymax,ytic)
	xwin=xmin-(xmax-xmin)*0.1
	ywin=ymin-(ymax-ymin)*0.1

c*********************************************************************
c		initilize plotting device and draw
c*********************************************************************
	type 35
35	format ('$Please select point style [0-11] = ')
	accept 45,ntype
45	format(i)
50	call init
	if (hv) goto 70

	type 55
55	format ('$Please select pen speed [38.1] = ')
	accept 65,penv
65	format(f5.0)
	if (penv.eq.0.0) penv=38.1
	if (penv.ge.127.0) penv=38.1
	call setvs(penv)
70	continue
	call select(1)				!select pen

	call scale(xwin,xmax,ywin,ymax)		!scale plot window
	call aaxis(xtic,ytic)			!draw axes
	call labax(0,xmin,xmax,xtic)		!label x axis tics
	call labax(1,ymin,ymax,ytic)		!label y axis tics
	call llabel(0,xlabel)			!label x axis
	call llabel(1,ylabel)			!label y axis
	call settl(0.4,0.4)			!set tic size for errbar

	do 80 i=1,ndata				!plot data
	  call ppoint(xdat(i),ydat(i),ntype)	
	  call errbar(xdat(i),ydat(i),xerr(i),yerr(i))
80	  continue

	call home
	call ploff
	if (.not.hv) goto 90
	type 85
85	format('$Do you want another copy? ')
	if (ireply()) goto 50
c*********************************************************************
c		the end
c*********************************************************************
90	continue
	call vtclr
	call exit
	end
                                      