
C
C	THIS PROGRAM CONVERTS 6800 HEX FILES
C	TO A FORM SUITABLE FOR PROM BURNING.
C
C	THE PROGRAM TO BE BURNED FIRST SHOULD
C	BE ASSEMBLED USING A 6800 ASSEMBLER.
C	THE HEX CODE GENERATED IS THEN RUN THROUGH
C	THIS PROGRAM TO GENERATE A .MAC FILE.
C	THE .MAC PROGRAM CAN BE BURNED IN THE
C	WAY NORMALLY USED BY THE PROM BURNER.
C	OUR SYSTEM USES AN INTERPLEX PROM BURNER
C	THAT REQUIRES A .SAV FILE AS INPUT.
C	THE .SAV FILE IS CREATED BY USING MACRO
C	AND LINK. SEE MINITASKER MARCH 1985 FOR
C	PATCHES TO THE LINKER PROGRAM TO GENERATE
C	A PURE .SAV FILE.
C
C	THIS CONVERSION PROGRAM IS WRITTEN TO
C	MINIMIZE PROGRAM DEVELOPMENT AT THE
C	EXPENSE OF DISK SPACE. THE PROGRAM
C	BREAKS APART EACH RECORD OF HEX CODE
C	AND CONVERTS EACH TWO HEX DIGITS
C	INTO AN OCTAL NUMBER. THE OCTAL NUMBER
C	IS WRITTEN TO A FILE AS:
C
C		.BYTE	OOO,377
C
C	THE 377 IS APPENDED SO THAT ONLY ONE
C	PROM IS BURNED AT A TIME. THIS IS DUE
C	TO THE NATURE OF ALTERNATING BYTES
C	IN DEC PROMS VS 6800 PROMS.
C
C	ADDRESSES ARE CONVERTED TO FLOATING
C	POINT VALUES AND ARE STORED IN THE FILE
C	IN THE FORM:
C
C		.=	DDDDD.
C
C	THE VALUE OF THE ADDRESS IS GIVEN BY
C	TAKING THE ADDRESS MINUS THE BASE ADDRESS
C	MULTIPLIED BY TWO. THE MULTIPLICATION
C	TAKES INTO ACCOUNT THE 377 APPENDED
C	TO THE DATA.
C
C
C	WRITTEN BY JOHN DAVIES 1/17/83
C	MODIFIED BY JOHN DAVIES 5/8/85
C
C	THERMO ELECTRON INSTRUMENTS, INC.
C	524 ALPHA DRIVE
C	PITTSBURGH, PENNSYLVANIA 15238-2912
C	(412) 963-0903
C
C
C
      LOGICAL * 1 INLIN ( 80 ), NAME1 ( 80 ), NAME2 ( 80 )
C	DETERMINE NAME OF THE HEX FILE
      TYPE 100
100   FORMAT ( 35H$WHAT IS THE NAME OF THE HEX FILE?  )
      ACCEPT 110, L1, NAME1
110   FORMAT ( Q, 80A1 )
      CALL EXT ( L1, NAME1, NAME2 )
C
C	OPEN INPUT AND OUTPUT FILES
C
      OPEN ( UNIT = 1, NAME = NAME1, TYPE = 3HOLD, ERR = 990, READONLY 
     $)
      OPEN ( UNIT = 2, NAME = NAME2, TYPE = 3HNEW, ERR = 991 )
C
C	SKIP FIRST LINE, IT CONTAINS NO VALUABLE INFORMATION
C
      READ ( 1, 120, END = 500 ) L, INLIN
120   FORMAT ( Q, 80A1 )
C	GET FIRST LINE
      READ ( 1, 120, END = 500 ) L, INLIN
C	CONVERT BASE ADDRESS TO FLOATING POINT
      BADDR = 256 . * FLOAT ( ICNVT ( INLIN ( 7 ), INLIN ( 8 ), 1 ) )
      BADDR = BADDR + FLOAT ( ICNVT ( INLIN ( 9 ), INLIN ( 10 ), 1 ) )
      WRITE ( 2, 130 )
130   FORMAT ( 6H.ASECT )
      GOTO 15
C
C	MAIN LOOP
C
10    READ ( 1, 120, END = 500 ) L, INLIN
15    IF (.NOT.( L .EQ. 12 )) GOTO 20000
      GOTO 500
20000 CONTINUE
      ADDR = 256 . * FLOAT ( ICNVT ( INLIN ( 7 ), INLIN ( 8 ), 1 ) )
      ADDR = ADDR + FLOAT ( ICNVT ( INLIN ( 9 ), INLIN ( 10 ), 1 ) )
      OUT = ( ADDR - BADDR ) * 2
      IF (.NOT.( OUT .LT. 0 )) GOTO 20002
      OUT = 0
20002 CONTINUE
      WRITE ( 2, 135 ) OUT
135   FORMAT ( 2H.=, F9 . 0 )
       I = 11
20004 IF (.NOT.( I .LE. L - 2)) GOTO 20006
      CALL ICNVT ( INLIN ( I ), INLIN ( I + 1 ), 0 )
20005 I = I + 2 
      GOTO 20004
20006 CONTINUE
      GOTO 10
C
500   WRITE ( 2, 140 )
140   FORMAT ( 4H.END )
      CLOSE ( UNIT = 2 )
      CLOSE ( UNIT = 1 )
      STOP
C	ERROR STATES
990   TYPE 1000
1000  FORMAT ( 26H INPUT FILE DOES NOT EXIST )
      STOP
991   TYPE 1001
1001  FORMAT ( 27H UNABLE TO OPEN OUTPUT FILE )
      STOP
      END

      SUBROUTINE EXT ( L1, F1, F2 )
C	ROUTINE TO ADD .HEX AND .MAC EXTENSIONS (IF NEEDED)
C	  TO SUPPLIED NAMES
      LOGICAL * 1 F1 ( 80 ), F2 ( 80 )
       I = 1
20007 IF (.NOT.( I .NE. L1)) GOTO 20009
      IF (.NOT.( F1 ( I ) .EQ. 1H. )) GOTO 20010
      GOTO 3
20010 CONTINUE
20008 I = I + 1 
      GOTO 20007
20009 CONTINUE
      F1 ( L1 + 1 ) = 1H.
      F1 ( L1 + 2 ) = 1HH
      F1 ( L1 + 3 ) = 1HE
      F1 ( L1 + 4 ) = 1HX
      L1 = L1 + 4
3     F1 ( L1 + 1 ) = 0
C
C	GIVE .MAC EXTENSION FOR OUTPUT FILE
C
       I = 1
20012 IF (.NOT.( I .NE. L1 + 2)) GOTO 20014
      F2 ( I ) = F1 ( I )
20013 I = I + 1 
      GOTO 20012
20014 CONTINUE
      F2 ( L1 - 2 ) = 1HM
      F2 ( L1 - 1 ) = 1HA
      F2 ( L1 ) = 1HC
      RETURN
      END

      FUNCTION ICNVT ( H, L, WRIT )
C	FUNCTION TO CONVERT TWO LOGICAL*1 HEX DIGITS
C	  TO AN INTEGER NUMBER
      LOGICAL * 1 L, H, Q, N
      INTEGER WRIT
      COMMON / IMAT / N, Q
      Q = 0
      N = H
      H = ICNVT2 ( )
      Q = 0
      N = L
      L = ICNVT2 ( )
      ICNVT = H * 16 + L
      IF (.NOT.( WRIT .EQ. 1 )) GOTO 20015
      GOTO 110
20015 CONTINUE
      WRITE ( 2, 100 ) ICNVT
100   FORMAT ( 6H.BYTE , O7, 4H,377 )
110   RETURN
      END

      FUNCTION ICNVT2
C	FUNCTION TO CONVERT A HEX DIGIT TO AN INTEGER
      COMMON / IMAT / N, Q
      EQUIVALENCE ( N1, N )
      IF (.NOT.( N1 .LT. 58 )) GOTO 20017
      ICNVT2 = N1 - 48
      GOTO 20018
20017 CONTINUE
      ICNVT2 = N1 - 55
20018 CONTINUE
      RETURN
      END

                                                                                                                                                                                                                                         