PROGRAM INCTRL; { V2A Edit #12 18-Mar-85  File: INCTRL.PAS  }

{druckt das Direct-Access-File R65INS.ASM}


CONST
  VersionNumber = 'V2A-012/RT'; VersionDate = '18-Mar-85';
  NOINSTR = 111;

TYPE
  ADDRMODE = (IMM,ABS,ZPAG,ACCU,IMPL,INDZPAGX,INDZPAGY,ZPAGX,
              ABSX,ABSY,REL,INDABS,ZPAGY,INDZPAG,INDABSX,ZPAGREL);
  SYMBOL   = (ADDR,BSS,BYTES,EQU,ORG,WORDS,MNEMS,TEXTS,MARK,LIST,NOLIST,
	      NEWPAG,NEWFILE,SUBFILE,RETURN,ENDS,CHARS,IDENT,NUMBER,
              STRNG);
  ALFA     = PACKED ARRAY[1..10] OF CHAR;
  BYTE     = PACKED ARRAY[1..2] OF CHAR;
  CODELIST = ARRAY[ADDRMODE] OF BYTE;

VAR
  INSTRTAB            : FILE OF RECORD
				  NAME     : ALFA;
				  SYM      : SYMBOL;
				  OPCODE   : CODELIST
				END;
  INSTR    : ALFA;
  J,N      : INTEGER;
  ADDRM    : ADDRMODE;
  OPC      : BYTE;
  OPCLST   : CODELIST;
  CH       : CHAR;
  SYM      : SYMBOL;

 PROCEDURE NEUESEITE;

 BEGIN
   PAGE(OUTPUT);
   WRITELN;
   WRITELN(' ':17,'#  A  Z  A  I  [  [  Z  A  A  R  [  Z  [  [  Z');
   WRITELN(' ':17,'I  B  E  C  M  I  I  E  B  B  E  I  E  I  I  P');
   WRITELN(' ':17,'M  S  R  C  P  N  N  R  S  S  L  N  R  N  N  A');
   WRITELN(' ':17,'M  O  O  U  L  D  D  O  O  O  A  D  O  D  D  G');
   WRITELN(' ':17,'E  L  P  M  I  Z  Z  P  L  L  T  A  P  Z  A  E');
   WRITELN(' ':17,'D  U  A  U  E  P  P  A  U  U  I  B  A  P  B  ,');
   WRITELN(' ':17,'I  T  G  L  D  A  A  G  T  T  V  S  G  A  S  R');
   WRITELN(' ':17,'A  E  E  A     G  G  E  E  E  E  ]  E  G  ,  E');
   WRITELN(' ':17,'T        O     ,  ]  ,  ,  ,        ,  ]  X  L');
   WRITELN(' ':17,'E        R     X  ,  X  X  Y        Y     ]   ');
   WRITELN(' ':17,'               ]  Y                           ');
   WRITELN;

 END {NEUESEIT};


 BEGIN
   WRITELN('INCTRL: ',VERSIONNUMBER,' (',VERSIONDATE,')');
   RESET(INSTRTAB,'DK:R65INS.ASM/SEEK');
   REWRITE(OUTPUT,'LST:R65INS.LST');
   N:=0;

    REPEAT
     IF (N mod 37)=0 THEN NEUESEITE;
     N:=N+1;
     SEEK(INSTRTAB,N);
     WRITE('  ',N:3,'  ');
     WRITE(INSTRTAB^.NAME);
     FOR ADDRM:=IMM TO ZPAGREL DO
      BEGIN
	OPC:=INSTRTAB^.OPCODE[ADDRM];
        IF OPC='  '
         THEN
          WRITE('.. ')
         ELSE
          WRITE(OPC,' ')
      END;
        SYM:=INSTRTAB^.SYM;
        CASE SYM OF
          ADDR    : WRITE('ADDR');
          BSS     : WRITE('BSS');
          BYTES   : WRITE('BYTES');
          ENDS    : WRITE('ENDS');
          EQU     : WRITE('EQU');
          NEWFILE : WRITE('NEWFILE');
          SUBFILE : WRITE('SUBFILE');
          RETURN  : WRITE('RETURN');
          TEXTS   : WRITE('TEXTS');
          NEWPAG  : WRITE('NEWPAG');
          ORG     : WRITE('ORG');
          WORDS   : WRITE('WORDS');
          LIST    : WRITE('LIST');  
          NOLIST  : WRITE('NOLIST');
          MARK    : WRITE('MARK');
          MNEMS   : WRITE('MNEMS');
          ELSE WRITE('ERROR')
         END;
      WRITELN;
    UNTIL N=NOINSTR
 END.
                                                              