vread                      VIRTUAL ARRAYS                            vread



NAME
    vread - read a data element from a virtual array;

SYNOPSIS
    TEXT *vread(array_select, index)
    	COUNT array_select;
    	LONG index;

FUNCTION
    vread() returns a pointer to the data element specified by
    index.  There is no quarentee in arbitrary files that this
    pointer is going to be properly aligned on a valid storage
    boundary for the required data type.

RETURNS
    a pointer to TEXT which can be coerced into the pointer of the
    required type.

EXAMPLE
    To read a double precision value from a virtual array as set up in
    the vdim manual page's example:

    DOUBLE d;

    d = (double *)vread( 2, 130L);

BUGS
    The worst problem comes from poking around in files that may have
    items stored at odd word boundaries.  The way around this is to
    copy byte for byte into a value that the compiler has assured is
    at a correct boundary.  This is only a problem if there's a mixture
    of data items out there and you're playing games by getting things
    out sequence.
                                                                                                                                                                                                                                                                                                                                                                                                             