/*+
 * METACH tfrget(field, ift)
 *     TEXT *field;
 *     BOOL ift;
 *
 * Description  : Routine to get input from keyboard
 *
 * Arguments    : field  = STRING containing the field name where data-entry
 *                         starts.
 *                         If the string is a null-string, data-entry starts
 *                         at the first field of the form
 *                ift    = INTEGER to indicate whether TAB and BS means
 *                         return control
 *                         to application: 1 - single field operation
 *                                         0 - normal operation
 * Returns      : tfrget = INTEGER indicating how returned after operation
 *                         with IFT=1. Result is 8,9 or 13. Argument obliged
 *                         if IFT=1.
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.1      Date : 22-apr-83
 *
 * Module name  : TFRGET.FOR
 *
 * Package      : TRAMP
 *
 * Compilation/Linking : FORT/NOLINE TFRGET
 *
 * Updates      : name R.Beetz          version
 *  description : BS returns to application too when IFT=1
 *                IRETCH argument implemented
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrget.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

METACH tfrget(field, ift)
    TEXT *field;
    BOOL ift;

    {
    VOID  ttbclr(), scvtlu(), tfrru(), tfrfs(), swrite(), inpmod();
    METACH igtkey();

    IMPORT TFRCOM t;

#include <upddef.h>

    LOCAL TEXT  tab =   9,
                lf  =  10,
                cr  =  13,
                esc =  27,
                rub = 127;
    LOCAL TEXT  bs[]    = "\b",
                bel[]   = "\7",
                schar[] = " ",
                cc[]    = "+$",
                prog[]  = "TFRGET",
                ermsg[] = "-Field not found";

    FAST COUNT j;

    METACH iretch, ch;
    COUNT jsw, irec, jmin, jmax, ipoint, insrep, ihrec;
    COUNT *pf;

    pf = &t.frec;
/*
 *    search first or specified field
 */
    if(!t.nrfufr)
        {
        error(prog, ermsg);
        }
    scvtlu(field);
    for(irec = t.nrfufr; irec <= t.nrlufr; ++irec)
        {
        tfrru(irec, "VAR");            /* read update field record */
        if(!lenstr(field)  ||  cmpstr(field, &pf->updfld))
            {
            tfrru(irec, "FCR");        /* read field copy record(s) */
            break;
            }
        }
    if(irec > t.nrlufr)
        {
        error(prog, ermsg);
        }
    

    jsw = JSW;                         /* save Job Status Word */
    ttbclr();                          /* clear input ring buffer */
    inpmod("NOECHO+WAIT+LOWER");
/*
 *    position at field, set video attributes and get character
 */
    insrep = FALSE;       /* replace/insert (0/1) toggle switch */
    ipoint = 0;           /* character pointer FCR */
    swrite(t.iscr, cc, &pf->updesc, NULL);
    FOREVER
        {
        ch = igtkey();
        if(ch == cr  ||              /* return to calling routine */
           ch == tab   &&  ift  ||
           ch == '\b'  &&  ift)
            {
            JSW = jsw;                 /* reset Job Status Word */
            if(t.iheflg)
                {
                swrite(t.iscr, cc, &t.herpos, &t.erlstr, NULL);
                }
            t.iheflg = FALSE;
            return(ch);
            }
        else if(ch == rub)
            {
            if(ipoint)
                {
                if(insrep)            /* delete character to left of cursor */
                    {
                    jmax = pf->npfcr + pf->lenupd - 1;
                    for(j = pf->npfcr+ipoint;
                        j <= jmax;
                        t.fcr[j-1] = t.fcr[j], ++j);
                    t.fcr[jmax] = ' ';
                    --ipoint;
                    swrite(t.iscr, cc, bs, &t.fcr[pf->npfcr+ipoint], NULL);
                        /* back to original position */
                    for(j = 0;
                        j < pf->lenupd-ipoint;
                        cwrite(t.iscr, bs, 1), ++j);
                    }
                else                  /* rubout last character */
                    {
                    j = pf->npfcr + ipoint;
                    if(t.fcr[j] == ' '  ||
                       t.fcr[j] == NULL)
                        {
                        t.fcr[j-1] = ' ';
                        }
                    --ipoint;
                    cwrite(t.iscr, bs,1);
                    cwrite(t.iscr, &t.fcr[j-1], 1);
                    cwrite(t.iscr, bs, 1);
                    }
                continue;
                }
            }
/*
 *    printable ASCII characters
 */
        else if(ch >= ' '  &&  ipoint < pf->lenupd)
            {
            if(insrep)     /* insert a character */
                {
                j = pf->npfcr + pf->lenupd - 1;
                if(t.fcr[j] == ' ')
                    {
                    jmin = pf->npfcr + ipoint + 1;
                    for( ; j >= jmin; t.fcr[j] = t.fcr[j-1], --j);
                    t.fcr[j] = ch;
                    swrite(t.iscr, cc, &t.fcr[j], NULL);
                    ++ipoint;
                    if(ipoint < pf->lenupd)
                        {
                        for(j = 0;
                            j < pf->lenupd-ipoint;
                            cwrite(t.iscr, bs, 1), ++j);
                        }
                    continue;
                    }
                }
            else                /* add a character */
                {
                j = pf->npfcr+ipoint;
                t.fcr[j] = ch;
                cwrite(t.iscr, &t.fcr[j], 1);
                ++ipoint;
                continue;
                }
            }
/*
 *    special characters
 */
        else if(ch > 0)
            {
            switch(ch)
                {
            case '\n':        /* LINEFEED: clear field */
                for(j = pf->npfcr;
                    j <= (pf->npfcr + pf->lenupd - 1);
                    t.fcr[j++] = ' ');
                swrite(t.iscr, cc, &pf->updesc, &t.fcr[pf->npfcr], NULL);
                insrep = FALSE;
                ipoint = 0;
                swrite(t.iscr, cc, &pf->updesc, NULL);
                continue;
            case '\t':        /* TAB: next field */
                if(irec != t.nrlufr)
                    {
                    ++irec;
                    j = TRUE;
                    }
                else
                    {
                    j = FALSE;
                    }
                break;
            case '\b':        /* BACKSPACE: former field */
                if(irec != t.nrfufr)
                    {
                    --irec;
                    j = TRUE;
                    }
                else
                    {
                    j = FALSE;
                    }
                break;
            default:         /* invalid character */
                j = FALSE;
                break;
                }
            if(j)
                {
                tfrru(irec, "ALL"); /* read update field record and FCR */
                if(t.iheflg)
                    {
                    swrite(t.iscr, cc, &t.herpos, &t.erlstr, NULL);
                    }
                t.iheflg = FALSE;
                insrep = FALSE;
                ipoint = 0;
                swrite(t.iscr, cc, &pf->updesc, NULL);
                continue;
                }
            }
/*
 *    arrow and keypad keys
 */
        else
            {
            switch(ch)
                {
            case -22:             /* RIGHT ARROW */
                if(ipoint < pf->lenupd)
                    {
                    cwrite(t.iscr, &t.fcr[pf->npfcr+ipoint], 1);
                    ++ipoint;
                    continue;
                    }
                break;
            case -21:             /* LEFT ARROW */
                if(ipoint)
                    {
                    --ipoint;
                    cwrite(t.iscr, bs, 1);
                    continue;
                    }
                break;
            case -11:             /* PF1-key: INSERT/REPLACE */
                insrep = insrep ^ 1;
                continue;
            case -12:             /* PF2-key: HELP */
                ihrec = pf->nrhlp;
                *t.sbuf = *bel;
                if(ihrec)
                    {
                    tfrfs(&ihrec);
                    }
                else
                    {
                    cpystr(&t.sbuf[1], "No help available", NULL);
                    }
                swrite(t.iscr, cc, &t.herpos, &t.hlpatt, &t.sbuf, NULL);
                t.iheflg = TRUE;
                insrep = FALSE;
                ipoint = 0;
                swrite(t.iscr, cc, &pf->updesc, NULL);
                continue;
                }
            }
        swrite(t.iscr, cc, bel,NULL);
        }
    }
                                                                                                                                             