/*+
 * COUNT rcread(unit, recnum, reclen, recbuf)
 *     COUNT unit, recnum, reclen;
 *     TEXT  *recbuf;
 *
 * Description  : This routine provides direct access for simulated fortran
 *                I/O.
 *
 * Arguments    : unit   = unit number to read.
 *                recnum = record number to be read.
 *                reclen = record length of file records.
 *                recbuf = buffer to be filled - must be reclen long.
 *
 * Returns      : > 0 if successful(number of char read s/b RECLEN).
 *                = 0 if end of file.
 *                -1 or RT11 error or'd with 0400 if failed.
 *
 * Author       : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : rcread.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <fortio.h>

COUNT rcread(unit, recnum, reclen, recbuf)
    COUNT unit, recnum, reclen;
    TEXT  *recbuf;

    {
    COUNT lseek();

    IMPORT FIO fortio[NFCHNL];

    COUNT rcr;

    --unit;
    if((rcr = lseek(fortio[unit]._fd, (LONG)((recnum-1)*reclen), 0)))
        {
        rcr = fread(fortio[unit]._fd, recbuf, reclen);
        }
    return(rcr);
    }
                                                                                