/*+
 * VOID mprsav(file)
 *     TEXT *file;
 *
 * Description  : Routine to save the menu-status of MPR
 *
 * Arguments    : file   = STRING containing the save-file name without
 *                         extension
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 10-feb-1983
 *
 * Module name  : MPRSAV.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprsav.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprsav(file)
    TEXT *file;

    {
    VOID  swrite(), rcread();
    COUNT copen();

    IMPORT MPRCOM m;

    LOCAL TEXT  prog[] = "MPRSAV";

    TEXT  save[344], filnam[16];

/*
 *    close MPR-library, generate complete save-file name and open
 */
    cclose(m.nunit);
    cpystr(filnam, file, NULL);
    cpystr(&filnam[scnstr(filnam, '.')], ".MAV", NULL);
    if(ccreat(m.nunit, filnam) < 0)
        {
        error(prog, "Error opening MPR save file");
        }
/*
 *    write MPRCOM to the save-file
 */
    cpybuf(save, &m, 342);
    save[342] = 0;
    save[343] = 0;
    cwrite(m.nunit, save, 344);
    cclose(m.nunit);
    }
                                                                                                                                                                                                                                                                                                                                                                                                        