/*+
 * COUNT cclose(unit)
 *    COUNT unit;
 *
 * Description  : This routine simulates the fortran close function.
 *
 * Arguments    : UNIT   = unit number to close
 *
 * Returns      : >0 if successful.
 *                -1 or RT11 error or'd with 0400 if failed.
 * Author       : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : cclose.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <fortio.h>

COUNT cclose(unit)
    COUNT unit;

    {
    IMPORT FIO fortio[NFCHNL];

    --unit;
    if(fortio[unit]._fd >= 0)
        {
        if((fclose(&fortio[unit])) >= 0);
            {
            fortio[unit]._fd = -1;
            }
        return(0);
        }
    else
        {
        return(-1);
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   