C
C       EGYPT.FTN
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C       BENCHMARK PROGRAM TO COMPARE THE COMPUTING POWER OF
C       DIFFERENT COMPUTERS.
C       TAKEN FROM THE GENERAL EGYPTIAN ELECTRICITY CORP.
C       RFP FOR A NATIONAL ENERGY CONTROL CENTER.
C       
C       A SIMPLE MATRIX INVERSION BENCHMARK PROGRAM
C       REFERENCE: ROCKWELL INTERNATIONAL    (21-FEB-77 OEM MKTG MEMO)
C
C       THE PROGRAM GENERATES A DATA MATRIX AND THEN PERFORMS 
C       A DOUBLE MATRIX INVERSION. THE DIFFERENCE BETWEEN
C       THE ORIGINAL MATIX ELEMENTS AND THE DOUBLE INVERTED MATRIX
C       ELEMENTS YIELDS A RELATIVE ACCURACY.
C       ORIGINAL MATRIX
C       1.      2.      3.      ...     50.
C       2.      3.      4.      ...     51.
C       .
C       50.     51.     52.     ...     99.
C
        COMMON /LUNS/ ICRD,ILPT,IKBD,ITTY
        DIMENSION Z(50,50)
        write (itty,*) 'BENCHMARK - EGYPTD'
        L = 50
        CALL TIMRB
        DO 10  I=1,L
            S = FLOAT(I)
            DO 5 J=1,L
                Z(I,J) = S
                S = S+1
5               CONTINUE
            S = Z(I,L)
            Z(I,L) = Z(I,I)
            Z(I,I) = S
10          CONTINUE


        DO 35 JA = 1,2
            DO 30 I = 1,L
                S = Z(I,I)
                Z(I,I) = 1./S
                DO 20 J = 1,L
                    IF (J .EQ. I) GO TO 20
                    DO 15 K = 1,L
                        IF (K .EQ. I) GO TO 15
                        Z(J,K) = Z(J,K) - Z(J,I)*Z(I,K)/S
15                      CONTINUE
20                  CONTINUE


                DO 25 J = 1,L
                    IF (J .EQ. I) GO TO 25
                    Z(J,I) = Z(J,I)/S
                    Z(I,J) = -Z(I,J)/S
25                  CONTINUE


30              CONTINUE
35          CONTINUE


        CALL TIMRE
C       WRITE (ITTY,40)
40      FORMAT (7H  (I,J),5X,'ERROR AFTER DOUBLE MATRIX INVERSION')
        S = 50.
C       DO 60 I = 1,50
C       ERR = Z(I,I) - S
C       WRITE (ITTY,50) (I,I,ERR)
50      FORMAT (2I3,4X,F20.15)
        S = S+1.
60      CONTINUE
        STOP
        END
                                                                                                                                                                                                                                                                                                                                                                                                            